/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.testparameterinjector;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.testing.junit.testparameterinjector.AutoValue_TestParameters_TestParametersValues;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.CONSTRUCTOR, ElementType.METHOD})
@Repeatable(value=RepeatedTestParameters.class)
public @interface TestParameters {
    public String[] value() default {};

    public String customName() default "";

    public Class<? extends TestParametersValuesProvider> valuesProvider() default DefaultTestParametersValuesProvider.class;

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.CONSTRUCTOR, ElementType.METHOD})
    public static @interface RepeatedTestParameters {
        public TestParameters[] value();
    }

    public static class DefaultTestParametersValuesProvider
    implements TestParametersValuesProvider {
        @Override
        public List<TestParametersValues> provideValues() {
            return ImmutableList.of();
        }
    }

    @AutoValue
    public static abstract class TestParametersValues {
        public abstract String name();

        public abstract Map<String, Object> parametersMap();

        public static Builder builder() {
            return new Builder();
        }

        TestParametersValues() {
        }

        public static final class Builder {
            private String name;
            private final LinkedHashMap<String, Object> parametersMap = new LinkedHashMap();

            public Builder name(String name) {
                this.name = name.replaceAll("\\s+", " ");
                return this;
            }

            public Builder addParameter(String parameterName, @Nullable Object value) {
                this.parametersMap.put(parameterName, value);
                return this;
            }

            public Builder addParameters(Map<String, Object> parameterNameToValueMap) {
                this.parametersMap.putAll(parameterNameToValueMap);
                return this;
            }

            public TestParametersValues build() {
                Preconditions.checkState((this.name != null ? 1 : 0) != 0, (String)"This set of parameters needs a name (%s)", this.parametersMap);
                return new AutoValue_TestParameters_TestParametersValues(this.name, Collections.unmodifiableMap(new LinkedHashMap<String, Object>(this.parametersMap)));
            }
        }
    }

    public static interface TestParametersValuesProvider {
        public List<TestParametersValues> provideValues();
    }
}

