/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.testparameterinjector;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.testing.junit.testparameterinjector.AutoAnnotation_TestParametersMethodProcessor_TestIndexHolderFactory_create;
import com.google.testing.junit.testparameterinjector.ExecutableValidationResult;
import com.google.testing.junit.testparameterinjector.ParameterValueParsing;
import com.google.testing.junit.testparameterinjector.TestInfo;
import com.google.testing.junit.testparameterinjector.TestMethodProcessor;
import com.google.testing.junit.testparameterinjector.TestParameters;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

final class TestParametersMethodProcessor
implements TestMethodProcessor {
    private final LoadingCache<Executable, ImmutableList<TestParameters.TestParametersValues>> parameterValuesByConstructorOrMethodCache = CacheBuilder.newBuilder().maximumSize(1000L).build(CacheLoader.from(TestParametersMethodProcessor::toParameterValuesList));

    TestParametersMethodProcessor() {
    }

    @Override
    public ExecutableValidationResult validateConstructor(Constructor<?> constructor) {
        if (TestParametersMethodProcessor.hasRelevantAnnotation(constructor)) {
            try {
                this.getConstructorParameters(constructor);
            }
            catch (Throwable t) {
                return ExecutableValidationResult.validated(t);
            }
            return ExecutableValidationResult.valid();
        }
        return ExecutableValidationResult.notValidated();
    }

    @Override
    public ExecutableValidationResult validateTestMethod(Method testMethod, Class<?> testClass) {
        if (TestParametersMethodProcessor.hasRelevantAnnotation(testMethod)) {
            try {
                this.getMethodParameters(testMethod);
            }
            catch (Throwable t) {
                return ExecutableValidationResult.validated(t);
            }
            return ExecutableValidationResult.valid();
        }
        return ExecutableValidationResult.notValidated();
    }

    @Override
    public List<TestInfo> calculateTestInfos(TestInfo originalTest) {
        boolean constructorIsParameterized = TestParametersMethodProcessor.hasRelevantAnnotation(TestParametersMethodProcessor.getOnlyConstructor(originalTest.getTestClass()));
        boolean methodIsParameterized = TestParametersMethodProcessor.hasRelevantAnnotation(originalTest.getMethod());
        if (!constructorIsParameterized && !methodIsParameterized) {
            return ImmutableList.of((Object)originalTest);
        }
        ImmutableList.Builder testInfos = ImmutableList.builder();
        ImmutableList<Optional<TestParameters.TestParametersValues>> constructorParametersList = this.getConstructorParametersOrSingleAbsentElement(originalTest.getTestClass());
        ImmutableList<Optional<TestParameters.TestParametersValues>> methodParametersList = this.getMethodParametersOrSingleAbsentElement(originalTest.getMethod());
        for (int constructorParametersIndex = 0; constructorParametersIndex < constructorParametersList.size(); ++constructorParametersIndex) {
            Optional constructorParameters = (Optional)constructorParametersList.get(constructorParametersIndex);
            for (int methodParametersIndex = 0; methodParametersIndex < methodParametersList.size(); ++methodParametersIndex) {
                Optional methodParameters = (Optional)methodParametersList.get(methodParametersIndex);
                int constructorParametersIndexCopy = constructorParametersIndex;
                int methodParametersIndexCopy = methodParametersIndex;
                testInfos.add((Object)originalTest.withExtraParameters((List<TestInfo.TestInfoParameter>)FluentIterable.of((Object)constructorParameters.transform(param -> TestInfo.TestInfoParameter.create(param.name(), param.parametersMap(), constructorParametersIndexCopy)), (Object[])new Optional[]{methodParameters.transform(param -> TestInfo.TestInfoParameter.create(param.name(), param.parametersMap(), methodParametersIndexCopy))}).filter(Optional::isPresent).transform(Optional::get).toList()).withExtraAnnotation(TestIndexHolderFactory.create(constructorParametersIndex, methodParametersIndex)));
            }
        }
        return testInfos.build();
    }

    private ImmutableList<Optional<TestParameters.TestParametersValues>> getConstructorParametersOrSingleAbsentElement(Class<?> testClass) {
        Constructor<?> constructor = TestParametersMethodProcessor.getOnlyConstructor(testClass);
        return TestParametersMethodProcessor.hasRelevantAnnotation(constructor) ? FluentIterable.from(this.getConstructorParameters(constructor)).transform(Optional::of).toList() : ImmutableList.of((Object)Optional.absent());
    }

    private ImmutableList<Optional<TestParameters.TestParametersValues>> getMethodParametersOrSingleAbsentElement(Method method) {
        return TestParametersMethodProcessor.hasRelevantAnnotation(method) ? FluentIterable.from(this.getMethodParameters(method)).transform(Optional::of).toList() : ImmutableList.of((Object)Optional.absent());
    }

    @Override
    public Optional<List<Object>> maybeGetConstructorParameters(Constructor<?> constructor, TestInfo testInfo) {
        if (TestParametersMethodProcessor.hasRelevantAnnotation(constructor)) {
            ImmutableList<TestParameters.TestParametersValues> parameterValuesList = this.getConstructorParameters(constructor);
            TestParameters.TestParametersValues parametersValues = (TestParameters.TestParametersValues)parameterValuesList.get(testInfo.getAnnotation(TestIndexHolder.class).constructorParametersIndex());
            return Optional.of(TestParametersMethodProcessor.toParameterList(parametersValues, constructor.getParameters()));
        }
        return Optional.absent();
    }

    @Override
    public Optional<List<Object>> maybeGetTestMethodParameters(TestInfo testInfo) {
        Method testMethod = testInfo.getMethod();
        if (TestParametersMethodProcessor.hasRelevantAnnotation(testMethod)) {
            ImmutableList<TestParameters.TestParametersValues> parameterValuesList = this.getMethodParameters(testMethod);
            TestParameters.TestParametersValues parametersValues = (TestParameters.TestParametersValues)parameterValuesList.get(testInfo.getAnnotation(TestIndexHolder.class).methodParametersIndex());
            return Optional.of(TestParametersMethodProcessor.toParameterList(parametersValues, testMethod.getParameters()));
        }
        return Optional.absent();
    }

    @Override
    public void postProcessTestInstance(Object testInstance, TestInfo testInfo) {
    }

    private ImmutableList<TestParameters.TestParametersValues> getConstructorParameters(Constructor<?> constructor) {
        try {
            return (ImmutableList)this.parameterValuesByConstructorOrMethodCache.getUnchecked(constructor);
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), IllegalStateException.class);
            throw e;
        }
    }

    private ImmutableList<TestParameters.TestParametersValues> getMethodParameters(Method method) {
        try {
            return (ImmutableList)this.parameterValuesByConstructorOrMethodCache.getUnchecked((Object)method);
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), IllegalStateException.class);
            throw e;
        }
    }

    private static ImmutableList<TestParameters.TestParametersValues> toParameterValuesList(Executable executable) {
        TestParametersMethodProcessor.checkParameterNamesArePresent(executable);
        ImmutableList parametersList = ImmutableList.copyOf((Object[])executable.getParameters());
        if (executable.isAnnotationPresent(TestParameters.class)) {
            Preconditions.checkState((!executable.isAnnotationPresent(TestParameters.RepeatedTestParameters.class) ? 1 : 0) != 0, (Object)"Unexpected situation: Both @TestParameters and @RepeatedTestParameters annotating the same method");
            TestParameters annotation2 = executable.getAnnotation(TestParameters.class);
            boolean valueIsSet = annotation2.value().length > 0;
            boolean valuesProviderIsSet = !annotation2.valuesProvider().equals(TestParameters.DefaultTestParametersValuesProvider.class);
            Preconditions.checkState((!valueIsSet || !valuesProviderIsSet ? 1 : 0) != 0, (String)"It is not allowed to specify both value and valuesProvider in @TestParameters(value=%s, valuesProvider=%s) on %s()", (Object)Arrays.toString(annotation2.value()), (Object)annotation2.valuesProvider().getSimpleName(), (Object)executable.getName());
            Preconditions.checkState((valueIsSet || valuesProviderIsSet ? 1 : 0) != 0, (String)"Either a value or a valuesProvider must be set in @TestParameters on %s()", (Object)executable.getName());
            if (!annotation2.customName().isEmpty()) {
                Preconditions.checkState((annotation2.value().length == 1 ? 1 : 0) != 0, (String)"Setting @TestParameters.customName is only allowed if there is exactly one YAML string in @TestParameters.value (on %s())", (Object)executable.getName());
            }
            if (valueIsSet) {
                return FluentIterable.from((Object[])annotation2.value()).transform(yamlMap -> TestParametersMethodProcessor.toParameterValues(yamlMap, (List<Parameter>)parametersList, annotation2.customName())).toList();
            }
            return TestParametersMethodProcessor.toParameterValuesList(annotation2.valuesProvider(), (List<Parameter>)parametersList);
        }
        Verify.verify((boolean)executable.isAnnotationPresent(TestParameters.RepeatedTestParameters.class), (String)"This method should only be called for executables with at least one relevant annotation", (Object[])new Object[0]);
        return FluentIterable.from((Object[])executable.getAnnotation(TestParameters.RepeatedTestParameters.class).value()).transform(annotation -> TestParametersMethodProcessor.toParameterValues(TestParametersMethodProcessor.validateAndGetSingleValueFromRepeatedAnnotation(annotation, executable), (List<Parameter>)parametersList, annotation.customName())).toList();
    }

    private static ImmutableList<TestParameters.TestParametersValues> toParameterValuesList(Class<? extends TestParameters.TestParametersValuesProvider> valuesProvider, List<Parameter> parameters) {
        try {
            Constructor<? extends TestParameters.TestParametersValuesProvider> constructor = valuesProvider.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            List<TestParameters.TestParametersValues> testParametersValues = constructor.newInstance(new Object[0]).provideValues();
            for (TestParameters.TestParametersValues testParametersValue : testParametersValues) {
                TestParametersMethodProcessor.validateThatValuesMatchParameters(testParametersValue, parameters);
            }
            return ImmutableList.copyOf(testParametersValues);
        }
        catch (NoSuchMethodException e) {
            if (!Modifier.isStatic(valuesProvider.getModifiers()) && valuesProvider.isMemberClass()) {
                throw new IllegalStateException(String.format("Could not find a no-arg constructor for %s, probably because it is a not-static inner class. You can fix this by making %s static.", valuesProvider.getSimpleName(), valuesProvider.getSimpleName()), e);
            }
            throw new IllegalStateException(String.format("Could not find a no-arg constructor for %s.", valuesProvider.getSimpleName()), e);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void checkParameterNamesArePresent(Executable executable) {
        Preconditions.checkState((boolean)FluentIterable.from((Object[])executable.getParameters()).allMatch(Parameter::isNamePresent), (String)"No parameter name could be found for %s, which likely means that parameter names aren't available at runtime. Please ensure that the this test was built with the -parameters compiler option.\n\nIn Maven, you do this by adding <parameters>true</parameters> to the maven-compiler-plugin's configuration. For example:\n\n<build>\n  <plugins>\n    <plugin>\n      <groupId>org.apache.maven.plugins</groupId>\n      <artifactId>maven-compiler-plugin</artifactId>\n      <version>3.8.1</version>\n      <configuration>\n        <compilerArgs>\n          <arg>-parameters</arg>\n        </compilerArgs>\n      </configuration>\n    </plugin>\n  </plugins>\n</build>\n\nDon't forget to run `mvn clean` after making this change.", (Object)executable.getName());
    }

    private static String validateAndGetSingleValueFromRepeatedAnnotation(TestParameters annotation, Executable executable) {
        Preconditions.checkState((boolean)annotation.valuesProvider().equals(TestParameters.DefaultTestParametersValuesProvider.class), (String)"Setting a valuesProvider is not supported for methods/constructors with multiple @TestParameters annotations on %s()", (Object)executable.getName());
        Preconditions.checkState((annotation.value().length > 0 ? 1 : 0) != 0, (String)"Either a value or a valuesProvider must be set in @TestParameters on %s()", (Object)executable.getName());
        Preconditions.checkState((annotation.value().length == 1 ? 1 : 0) != 0, (String)"When specifying more than one @TestParameter for a method/constructor, each annotation must have exactly one value. Instead, got %s values on %s(): %s", (Object)annotation.value().length, (Object)executable.getName(), (Object)Arrays.toString(annotation.value()));
        return annotation.value()[0];
    }

    private static void validateThatValuesMatchParameters(TestParameters.TestParametersValues testParametersValues, List<Parameter> parameters) {
        ImmutableMap parametersByName = Maps.uniqueIndex(parameters, Parameter::getName);
        Preconditions.checkState((boolean)testParametersValues.parametersMap().keySet().equals(parametersByName.keySet()), (String)"Cannot map the given TestParametersValues to parameters %s (Given TestParametersValues are %s)", (Object)parametersByName.keySet(), (Object)testParametersValues);
        testParametersValues.parametersMap().forEach((paramName, paramValue) -> {
            Class expectedClass = Primitives.wrap(((Parameter)parametersByName.get(paramName)).getType());
            if (paramValue != null) {
                Preconditions.checkState((boolean)expectedClass.isInstance(paramValue), (String)"Cannot map value '%s' (class = %s) to parameter %s (class = %s) (for TestParametersValues %s)", (Object[])new Object[]{paramValue, paramValue.getClass(), paramName, expectedClass, testParametersValues});
            }
        });
    }

    private static TestParameters.TestParametersValues toParameterValues(String yamlString, List<Parameter> parameters, String maybeCustomName) {
        Object yamlMapObject = ParameterValueParsing.parseYamlStringToObject(yamlString);
        Preconditions.checkState((boolean)(yamlMapObject instanceof Map), (String)"Cannot map YAML string '%s' to parameters because it is not a mapping", (Object)yamlString);
        Map yamlMap = (Map)yamlMapObject;
        ImmutableMap parametersByName = Maps.uniqueIndex(parameters, Parameter::getName);
        Preconditions.checkState((boolean)yamlMap.keySet().equals(parametersByName.keySet()), (String)"Cannot map YAML string '%s' to parameters %s", (Object)yamlString, (Object)parametersByName.keySet());
        Map checkedYamlMap = yamlMap;
        return TestParameters.TestParametersValues.builder().name(maybeCustomName.isEmpty() ? yamlString : maybeCustomName).addParameters(Maps.transformEntries((Map)checkedYamlMap, (parameterName, parsedYaml) -> ParameterValueParsing.parseYamlObjectToJavaType(parsedYaml, TypeToken.of((Type)((Parameter)parametersByName.get(parameterName)).getParameterizedType())))).build();
    }

    private static boolean hasRelevantAnnotation(Constructor<?> executable) {
        return executable.isAnnotationPresent(TestParameters.class) || executable.isAnnotationPresent(TestParameters.RepeatedTestParameters.class);
    }

    private static boolean hasRelevantAnnotation(Method executable) {
        return executable.isAnnotationPresent(TestParameters.class) || executable.isAnnotationPresent(TestParameters.RepeatedTestParameters.class);
    }

    private static List<Object> toParameterList(TestParameters.TestParametersValues parametersValues, Parameter[] parameters) {
        return Arrays.asList(FluentIterable.from(Arrays.asList(parameters)).transform(Parameter::getName).transform(name -> parametersValues.parametersMap().get(name)).toArray(Object.class));
    }

    private static Constructor<?> getOnlyConstructor(Class<?> testClass) {
        ImmutableList constructors = ImmutableList.copyOf((Object[])testClass.getDeclaredConstructors());
        Preconditions.checkState((constructors.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly one constructor, but got %s", (Object)constructors);
        return (Constructor)Iterables.getOnlyElement((Iterable)constructors);
    }

    static class TestIndexHolderFactory {
        static TestIndexHolder create(int constructorParametersIndex, int methodParametersIndex) {
            return new AutoAnnotation_TestParametersMethodProcessor_TestIndexHolderFactory_create(constructorParametersIndex, methodParametersIndex);
        }

        private TestIndexHolderFactory() {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface TestIndexHolder {
        public int constructorParametersIndex();

        public int methodParametersIndex();
    }
}

