package com.google.testing.junit.testparameterinjector;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

// Generated by com.google.auto.value.processor.AutoValueProcessor
final class AutoValue_TestInfo extends TestInfo {

  private final Method method;

  private final Class<?> testClass;

  private final ImmutableList<TestInfo.TestInfoParameter> parameters;

  private final ImmutableList<Annotation> annotations;

  AutoValue_TestInfo(
      Method method,
      Class<?> testClass,
      ImmutableList<TestInfo.TestInfoParameter> parameters,
      ImmutableList<Annotation> annotations) {
    if (method == null) {
      throw new NullPointerException("Null method");
    }
    this.method = method;
    if (testClass == null) {
      throw new NullPointerException("Null testClass");
    }
    this.testClass = testClass;
    if (parameters == null) {
      throw new NullPointerException("Null parameters");
    }
    this.parameters = parameters;
    if (annotations == null) {
      throw new NullPointerException("Null annotations");
    }
    this.annotations = annotations;
  }

  @Override
  public Method getMethod() {
    return method;
  }

  @Override
  public Class<?> getTestClass() {
    return testClass;
  }

  @Override
  ImmutableList<TestInfo.TestInfoParameter> getParameters() {
    return parameters;
  }

  @Override
  public ImmutableList<Annotation> getAnnotations() {
    return annotations;
  }

  @Override
  public String toString() {
    return "TestInfo{"
        + "method=" + method + ", "
        + "testClass=" + testClass + ", "
        + "parameters=" + parameters + ", "
        + "annotations=" + annotations
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof TestInfo) {
      TestInfo that = (TestInfo) o;
      return this.method.equals(that.getMethod())
          && this.testClass.equals(that.getTestClass())
          && this.parameters.equals(that.getParameters())
          && this.annotations.equals(that.getAnnotations());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= method.hashCode();
    h$ *= 1000003;
    h$ ^= testClass.hashCode();
    h$ *= 1000003;
    h$ ^= parameters.hashCode();
    h$ *= 1000003;
    h$ ^= annotations.hashCode();
    return h$;
  }

}
