/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.testparameterinjector;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.reflect.Constructor;

class TestParameterInjectorUtils {
    static Constructor<?> getOnlyConstructor(Class<?> testClass) {
        ImmutableList constructors = ImmutableList.copyOf((Object[])testClass.getConstructors());
        if (constructors.isEmpty()) {
            constructors = ImmutableList.copyOf((Object[])testClass.getDeclaredConstructors());
        }
        Preconditions.checkState((constructors.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly one constructor, but got %s", (Object)constructors);
        return (Constructor)Iterables.getOnlyElement((Iterable)constructors);
    }

    private TestParameterInjectorUtils() {
    }
}

