/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.testparameterinjector;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import com.google.common.primitives.UnsignedLong;
import com.google.common.reflect.TypeToken;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.testing.junit.testparameterinjector.ByteStringReflection;
import com.google.testing.junit.testparameterinjector.TestParameterValue;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

final class ParameterValueParsing {
    private static final ImmutableMap<String, Duration> ABBREVIATION_TO_DURATION = new ImmutableMap.Builder().put((Object)"d", (Object)Duration.ofDays(1L)).put((Object)"h", (Object)Duration.ofHours(1L)).put((Object)"m", (Object)Duration.ofMinutes(1L)).put((Object)"min", (Object)Duration.ofMinutes(1L)).put((Object)"s", (Object)Duration.ofSeconds(1L)).put((Object)"ms", (Object)Duration.ofMillis(1L)).put((Object)"us", (Object)Duration.ofNanos(1000L)).put((Object)"ns", (Object)Duration.ofNanos(1L)).buildOrThrow();
    private static final Pattern UNIT_PATTERN = Pattern.compile("(?x) ([0-9]+)? (\\.[0-9]*)? (d|h|min|ms?|s|us|ns)");
    private static final CharMatcher ASCII_DIGIT = CharMatcher.inRange((char)'0', (char)'9');

    static <E extends Enum<E>> Enum<?> parseEnum(String str, Class<?> enumType) {
        try {
            return Enum.valueOf(enumType, str);
        }
        catch (IllegalArgumentException e) {
            Optional<Enum<?>> enumValue = ParameterValueParsing.maybeGetStaticConstant(enumType, str);
            if (enumValue.isPresent()) {
                return (Enum)enumValue.get();
            }
            throw e;
        }
    }

    private static Optional<Enum<?>> maybeGetStaticConstant(Class<?> enumType, String fieldName) {
        Verify.verify((boolean)enumType.isEnum(), (String)"Given type %s is not a enum.", (Object)enumType.getSimpleName());
        try {
            Field field = enumType.getField(fieldName);
            Object valueCandidate = field.get(null);
            Preconditions.checkArgument((boolean)enumType.isInstance(valueCandidate), (String)"The field %s.%s exists, but is not of expected type %s.", (Object)enumType.getSimpleName(), (Object)fieldName, (Object)enumType.getSimpleName());
            return Optional.of((Object)((Enum)valueCandidate));
        }
        catch (ReflectiveOperationException | SecurityException e) {
            return Optional.absent();
        }
    }

    static boolean isValidYamlString(String yamlString) {
        try {
            new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions())).load(yamlString);
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    static Object parseYamlStringToJavaType(String yamlString, Class<?> javaType) {
        return ParameterValueParsing.parseYamlObjectToJavaType(ParameterValueParsing.parseYamlStringToObject(yamlString), TypeToken.of(javaType));
    }

    static Object parseYamlStringToObject(String yamlString) {
        return new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions())).load(yamlString);
    }

    private static UnsignedLong parseYamlSignedLongToUnsignedLong(long number) {
        Preconditions.checkState((number >= 0L ? 1 : 0) != 0, (String)"%s should be greater than or equal to zero", (long)number);
        return UnsignedLong.fromLongBits((long)number);
    }

    static Object parseYamlObjectToJavaType(Object parsedYaml, TypeToken<?> javaType) {
        if (parsedYaml == null) {
            return null;
        }
        YamlValueTransformer yamlValueTransformer = new YamlValueTransformer(parsedYaml, javaType.getRawType());
        yamlValueTransformer.ifJavaType(String.class).supportParsedType(String.class, self -> self).supportParsedType(Boolean.class, Object::toString).supportParsedType(Integer.class, Object::toString).supportParsedType(Long.class, Object::toString).supportParsedType(Double.class, Object::toString);
        yamlValueTransformer.ifJavaType(Boolean.class).supportParsedType(Boolean.class, self -> self);
        yamlValueTransformer.ifJavaType(Integer.class).supportParsedType(Integer.class, self -> self);
        yamlValueTransformer.ifJavaType(Long.class).supportParsedType(Long.class, self -> self).supportParsedType(Integer.class, Integer::longValue);
        yamlValueTransformer.ifJavaType(UnsignedLong.class).supportParsedType(Long.class, self -> ParameterValueParsing.parseYamlSignedLongToUnsignedLong(self)).supportParsedType(Integer.class, self -> ParameterValueParsing.parseYamlSignedLongToUnsignedLong(self.longValue())).supportParsedType(BigInteger.class, UnsignedLong::valueOf);
        yamlValueTransformer.ifJavaType(BigInteger.class).supportParsedType(Long.class, self -> BigInteger.valueOf(self)).supportParsedType(Integer.class, self -> BigInteger.valueOf(self.longValue())).supportParsedType(BigInteger.class, self -> self);
        yamlValueTransformer.ifJavaType(Float.class).supportParsedType(Float.class, self -> self).supportParsedType(Double.class, Double::floatValue).supportParsedType(Integer.class, Integer::floatValue).supportParsedType(String.class, Float::valueOf);
        yamlValueTransformer.ifJavaType(Double.class).supportParsedType(Double.class, self -> self).supportParsedType(Integer.class, Integer::doubleValue).supportParsedType(Long.class, Long::doubleValue).supportParsedType(String.class, Double::valueOf);
        yamlValueTransformer.ifJavaType(Enum.class).supportParsedType(Boolean.class, bool -> ParameterValueParsing.parseEnumIfUnambiguousYamlBoolean(bool, javaType.getRawType())).supportParsedType(String.class, str -> ParameterValueParsing.parseEnum(str, javaType.getRawType()));
        yamlValueTransformer.ifJavaType(byte[].class).supportParsedType(byte[].class, self -> self).supportParsedType(String.class, s -> s.getBytes(Charset.forName("UTF-8")));
        if (ByteStringReflection.MAYBE_BYTE_STRING_CLASS.isPresent()) {
            yamlValueTransformer.ifJavaType((Class)ByteStringReflection.MAYBE_BYTE_STRING_CLASS.get()).supportParsedType(String.class, ByteStringReflection::copyFromUtf8).supportParsedType(byte[].class, ByteStringReflection::copyFrom);
        }
        yamlValueTransformer.ifJavaType(Duration.class).supportParsedType(String.class, ParameterValueParsing::parseDuration).supportParsedType(Integer.class, i -> ParameterValueParsing.parseDuration(String.valueOf(i)));
        yamlValueTransformer.ifJavaType(List.class).supportParsedType(List.class, list -> Lists.transform((List)list, e -> ParameterValueParsing.parseYamlObjectToJavaType(e, ParameterValueParsing.getGenericParameterType(javaType, 0))));
        yamlValueTransformer.ifJavaType(Map.class).supportParsedType(Map.class, map -> ParameterValueParsing.parseYamlMapToJavaMap(map, javaType));
        return yamlValueTransformer.transformedJavaValue();
    }

    private static Enum<?> parseEnumIfUnambiguousYamlBoolean(boolean yamlValue, Class<?> enumType) {
        ImmutableSet negativeYamlStrings = ImmutableSet.of((Object)"false", (Object)"False", (Object)"FALSE", (Object)"n", (Object)"N", (Object)"no", (Object[])new String[]{"No", "NO", "off", "Off", "OFF"});
        ImmutableSet positiveYamlStrings = ImmutableSet.of((Object)"on", (Object)"On", (Object)"ON", (Object)"true", (Object)"True", (Object)"TRUE", (Object[])new String[]{"y", "Y", "yes", "Yes", "YES"});
        ImmutableSet yamlStringCandidates = yamlValue ? positiveYamlStrings : negativeYamlStrings;
        HashSet<Enum> matches = new HashSet<Enum>();
        for (Object enumValueObject : enumType.getEnumConstants()) {
            Enum enumValue = (Enum)enumValueObject;
            if (!yamlStringCandidates.contains(enumValue.name())) continue;
            matches.add(enumValue);
        }
        Preconditions.checkArgument((!matches.isEmpty() ? 1 : 0) != 0, (String)"Cannot cast a boolean (%s) to an enum of type %s.", (Object)yamlValue, (Object)enumType.getSimpleName());
        Preconditions.checkArgument((matches.size() == 1 ? 1 : 0) != 0, (String)"Cannot cast a boolean (%s) to an enum of type %s. It is likely that the YAML parser is 'wrongly' parsing one of these values as boolean: %s. You can solve this by putting quotes around the YAML value, forcing the YAML parser to parse a String, which can then be converted to the enum.", (Object)yamlValue, (Object)enumType.getSimpleName(), matches);
        return (Enum)Iterables.getOnlyElement(matches);
    }

    private static Map<?, ?> parseYamlMapToJavaMap(Map<?, ?> map, TypeToken<?> javaType) {
        LinkedHashMap<Object, Object> returnedMap = new LinkedHashMap<Object, Object>();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            returnedMap.put(ParameterValueParsing.parseYamlObjectToJavaType(entry.getKey(), ParameterValueParsing.getGenericParameterType(javaType, 0)), ParameterValueParsing.parseYamlObjectToJavaType(entry.getValue(), ParameterValueParsing.getGenericParameterType(javaType, 1)));
        }
        return returnedMap;
    }

    private static TypeToken<?> getGenericParameterType(TypeToken<?> typeToken, int parameterIndex) {
        Preconditions.checkArgument((boolean)(typeToken.getType() instanceof ParameterizedType), (String)"Could not parse the generic parameter of type %s", typeToken);
        ParameterizedType parameterizedType = (ParameterizedType)typeToken.getType();
        return TypeToken.of((Type)parameterizedType.getActualTypeArguments()[parameterIndex]);
    }

    static String formatTestNameString(Optional<String> parameterName, @Nullable Object value) {
        Optional<String> customName;
        Object unwrappedValue;
        if (value instanceof TestParameterValue) {
            TestParameterValue tpValue = (TestParameterValue)value;
            unwrappedValue = tpValue.getWrappedValue();
            customName = tpValue.getCustomName();
        } else {
            unwrappedValue = value;
            customName = Optional.absent();
        }
        String result = (String)customName.or(() -> ParameterValueParsing.valueAsString(unwrappedValue));
        if (parameterName.isPresent() && !customName.isPresent() && (unwrappedValue == null || Primitives.unwrap(unwrappedValue.getClass()).isPrimitive() || unwrappedValue.equals("null") || unwrappedValue instanceof CharSequence && CharMatcher.anyOf((CharSequence)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ").matchesNoneOf((CharSequence)unwrappedValue))) {
            result = String.format("%s=%s", parameterName.get(), ParameterValueParsing.valueAsString(unwrappedValue));
        }
        return result.trim().replaceAll("\\s+", " ");
    }

    private static String valueAsString(Object value) {
        if (value != null && value.getClass().isArray()) {
            StringBuilder resultBuider = new StringBuilder();
            resultBuider.append("[");
            for (int i = 0; i < Array.getLength(value); ++i) {
                if (i > 0) {
                    resultBuider.append(", ");
                }
                resultBuider.append(Array.get(value, i));
            }
            resultBuider.append("]");
            return resultBuider.toString();
        }
        if (ByteStringReflection.isInstanceOfByteString(value)) {
            return Arrays.toString(ByteStringReflection.byteStringToByteArray(value));
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        return String.valueOf(value);
    }

    private static Duration parseDuration(String value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"input value cannot be null");
        Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0, (Object)"input value cannot be empty");
        Preconditions.checkArgument((!value.equals("-") ? 1 : 0) != 0, (Object)"input value cannot be '-'");
        Preconditions.checkArgument((!value.equals("+") ? 1 : 0) != 0, (Object)"input value cannot be '+'");
        value = CharMatcher.whitespace().trimFrom((CharSequence)value);
        if (Objects.equals(value, "0")) {
            return Duration.ZERO;
        }
        Duration duration = Duration.ZERO;
        boolean negative = value.startsWith("-");
        boolean explicitlyPositive = value.startsWith("+");
        int index = negative || explicitlyPositive ? 1 : 0;
        Matcher matcher = UNIT_PATTERN.matcher(value);
        while (matcher.find(index) && matcher.start() == index) {
            Preconditions.checkArgument((boolean)ASCII_DIGIT.matchesAnyOf((CharSequence)matcher.group(0)));
            try {
                String unit = matcher.group(3);
                long whole = Long.parseLong((String)MoreObjects.firstNonNull((Object)matcher.group(1), (Object)"0"));
                Duration singleUnit = (Duration)ABBREVIATION_TO_DURATION.get((Object)unit);
                Preconditions.checkArgument((singleUnit != null ? 1 : 0) != 0, (String)"invalid unit (%s)", (Object)unit);
                duration = duration.plus(singleUnit.multipliedBy(whole));
                long nanosPerUnit = singleUnit.toNanos();
                double frac = Double.parseDouble("0" + (String)MoreObjects.firstNonNull((Object)matcher.group(2), (Object)""));
                duration = duration.plus(Duration.ofNanos((long)((double)nanosPerUnit * frac)));
            }
            catch (ArithmeticException e) {
                throw new IllegalArgumentException(e);
            }
            index = matcher.end();
        }
        if (index < value.length()) {
            throw new IllegalArgumentException("Could not parse entire duration: " + value);
        }
        if (negative) {
            duration = duration.negated();
        }
        return duration;
    }

    private ParameterValueParsing() {
    }

    private static final class YamlValueTransformer {
        private final Object parsedYaml;
        private final Class<?> javaType;
        @Nullable
        private Object transformedJavaValue;

        YamlValueTransformer(Object parsedYaml, Class<?> javaType) {
            this.parsedYaml = parsedYaml;
            this.javaType = javaType;
        }

        <JavaT> SupportedJavaType<JavaT> ifJavaType(Predicate<Class<?>> supportedJavaType) {
            return new SupportedJavaType(supportedJavaType);
        }

        <JavaT> SupportedJavaType<JavaT> ifJavaType(Class<JavaT> supportedJavaType) {
            return new SupportedJavaType(Primitives.wrap(supportedJavaType)::isAssignableFrom);
        }

        Object transformedJavaValue() {
            Preconditions.checkArgument((this.transformedJavaValue != null ? 1 : 0) != 0, (String)"Could not map YAML value %s (class = %s) to java class %s", (Object)this.parsedYaml, this.parsedYaml.getClass(), this.javaType);
            return this.transformedJavaValue;
        }

        final class SupportedJavaType<JavaT> {
            private final Predicate<Class<?>> supportedJavaType;

            private SupportedJavaType(Predicate<Class<?>> supportedJavaType) {
                this.supportedJavaType = supportedJavaType;
            }

            @CanIgnoreReturnValue
            <ParsedYamlT> SupportedJavaType<JavaT> supportParsedType(Class<ParsedYamlT> parsedYamlType, Function<ParsedYamlT, JavaT> transformation) {
                if (this.supportedJavaType.test(Primitives.wrap((Class)YamlValueTransformer.this.javaType)) && Primitives.wrap(parsedYamlType).isInstance(YamlValueTransformer.this.parsedYaml)) {
                    Preconditions.checkState((YamlValueTransformer.this.transformedJavaValue == null ? 1 : 0) != 0, (Object)"This case is already handled. This is a bug in testparameterinjector.TestParametersMethodProcessor.");
                    try {
                        YamlValueTransformer.this.transformedJavaValue = Preconditions.checkNotNull((Object)transformation.apply(YamlValueTransformer.this.parsedYaml));
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(String.format("Could not map YAML value %s (class = %s) to java class %s", YamlValueTransformer.this.parsedYaml, YamlValueTransformer.this.parsedYaml.getClass(), YamlValueTransformer.this.javaType), e);
                    }
                }
                return this;
            }
        }
    }
}

