/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.testparameterinjector;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Range;
import com.google.testing.junit.testparameterinjector.AutoValue_TestInfo;
import com.google.testing.junit.testparameterinjector.AutoValue_TestInfo_TestInfoParameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

@AutoValue
abstract class TestInfo {
    static final int MAX_TEST_NAME_LENGTH = 200;

    TestInfo() {
    }

    public abstract Method getMethod();

    public abstract Class<?> getTestClass();

    public final String getName() {
        if (this.getParameters().isEmpty()) {
            return this.getMethod().getName();
        }
        return String.format("%s[%s]", this.getMethod().getName(), FluentIterable.from(this.getParameters()).transform(TestInfoParameter::getValueInTestName).join(Joiner.on((String)",")));
    }

    abstract ImmutableList<TestInfoParameter> getParameters();

    public abstract ImmutableList<Annotation> getAnnotations();

    @Nullable
    public final <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        for (Annotation annotation : this.getAnnotations()) {
            if (!annotationClass.isInstance(annotation)) continue;
            return (T)((Annotation)annotationClass.cast(annotation));
        }
        return null;
    }

    final TestInfo withExtraParameters(List<TestInfoParameter> parameters) {
        return new AutoValue_TestInfo(this.getMethod(), this.getTestClass(), (ImmutableList<TestInfoParameter>)ImmutableList.builder().addAll(this.getParameters()).addAll(parameters).build(), this.getAnnotations());
    }

    final TestInfo withExtraAnnotation(Annotation annotation) {
        ImmutableList newAnnotations = ImmutableList.builder().addAll(this.getAnnotations()).add((Object)annotation).build();
        return new AutoValue_TestInfo(this.getMethod(), this.getTestClass(), this.getParameters(), (ImmutableList<Annotation>)newAnnotations);
    }

    private TestInfo withUpdatedParameterNames(Java8BiFunction<TestInfoParameter, Integer, String> parameterWithIndexToNewName) {
        return new AutoValue_TestInfo(this.getMethod(), this.getTestClass(), (ImmutableList<TestInfoParameter>)FluentIterable.from((Iterable)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.getParameters().size())), (DiscreteDomain)DiscreteDomain.integers())).transform(parameterIndex -> {
            TestInfoParameter parameter = (TestInfoParameter)this.getParameters().get(parameterIndex.intValue());
            return parameter.withValueInTestName((String)parameterWithIndexToNewName.apply(parameter, (Integer)parameterIndex));
        }).toList(), this.getAnnotations());
    }

    public static TestInfo legacyCreate(Method method, Class<?> testClass, String name, List<Annotation> annotations) {
        return new AutoValue_TestInfo(method, testClass, (ImmutableList<TestInfoParameter>)ImmutableList.of(), (ImmutableList<Annotation>)ImmutableList.copyOf(annotations));
    }

    static TestInfo createWithoutParameters(Method method, Class<?> testClass, List<Annotation> annotations) {
        return new AutoValue_TestInfo(method, testClass, (ImmutableList<TestInfoParameter>)ImmutableList.of(), (ImmutableList<Annotation>)ImmutableList.copyOf(annotations));
    }

    static ImmutableList<TestInfo> shortenNamesIfNecessary(List<TestInfo> testInfos) {
        if (FluentIterable.from(testInfos).anyMatch(info -> info.getName().length() > 200)) {
            int numberOfParameters = testInfos.get(0).getParameters().size();
            if (numberOfParameters == 0) {
                return ImmutableList.copyOf(testInfos);
            }
            ImmutableSet parameterIndicesThatNeedUpdate = FluentIterable.from((Iterable)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(numberOfParameters)), (DiscreteDomain)DiscreteDomain.integers())).filter(parameterIndex -> FluentIterable.from((Iterable)testInfos).anyMatch(info -> ((TestInfoParameter)info.getParameters().get(parameterIndex.intValue())).getValueInTestName().length() > TestInfo.getMaxCharactersPerParameter(info, numberOfParameters))).toSet();
            return FluentIterable.from(testInfos).transform(arg_0 -> TestInfo.lambda$shortenNamesIfNecessary$3((Set)parameterIndicesThatNeedUpdate, numberOfParameters, arg_0)).toList();
        }
        return ImmutableList.copyOf(testInfos);
    }

    private static int getMaxCharactersPerParameter(TestInfo testInfo, int numberOfParameters) {
        int maxLengthOfAllParameters = 200 - testInfo.getMethod().getName().length() - 2;
        return maxLengthOfAllParameters / numberOfParameters - 4;
    }

    static ImmutableList<TestInfo> deduplicateTestNames(List<TestInfo> testInfos) {
        long uniqueTestNameCount = FluentIterable.from(testInfos).transform(TestInfo::getName).toSet().size();
        if ((long)testInfos.size() == uniqueTestNameCount) {
            return ImmutableList.copyOf(testInfos);
        }
        return TestInfo.deduplicateWithNumberPrefixes(TestInfo.maybeAddTypesIfDuplicate(testInfos));
    }

    private static String getShortenedName(TestInfoParameter parameter, int maxCharactersPerParameter) {
        if (maxCharactersPerParameter < 4) {
            return String.valueOf(parameter.getIndexInValueSource() + 1);
        }
        String shortenedName = parameter.getValueInTestName().length() > maxCharactersPerParameter ? parameter.getValueInTestName().substring(0, maxCharactersPerParameter - 3) + "..." : parameter.getValueInTestName();
        return String.format("%s.%s", parameter.getIndexInValueSource() + 1, shortenedName);
    }

    private static ImmutableList<TestInfo> maybeAddTypesIfDuplicate(List<TestInfo> testInfos) {
        ListMultimap testNameToInfo = MultimapBuilder.linkedHashKeys().arrayListValues().build();
        for (TestInfo testInfo : testInfos) {
            testNameToInfo.put((Object)testInfo.getName(), (Object)testInfo);
        }
        return FluentIterable.from((Iterable)testNameToInfo.keySet()).transformAndConcat(arg_0 -> TestInfo.lambda$maybeAddTypesIfDuplicate$0((Multimap)testNameToInfo, arg_0)).toList();
    }

    private static String getTypeSuffix(@Nullable Object value) {
        if (value == null) {
            return " (null reference)";
        }
        return String.format(" (%s)", value.getClass().getSimpleName());
    }

    private static ImmutableList<TestInfo> deduplicateWithNumberPrefixes(ImmutableList<TestInfo> testInfos) {
        long uniqueTestNameCount = FluentIterable.from(testInfos).transform(TestInfo::getName).toSet().size();
        if ((long)testInfos.size() == uniqueTestNameCount) {
            return ImmutableList.copyOf(testInfos);
        }
        return FluentIterable.from(testInfos).transform(testInfo -> testInfo.withUpdatedParameterNames((parameter, parameterIndex) -> String.format("%s.%s", parameter.getIndexInValueSource() + 1, parameter.getValueInTestName()))).toList();
    }

    private static /* synthetic */ Iterable lambda$maybeAddTypesIfDuplicate$0(Multimap testNameToInfo, String testName) {
        Collection matchedInfos = testNameToInfo.get((Object)testName);
        if (matchedInfos.size() == 1) {
            return matchedInfos;
        }
        int numParameters = ((TestInfo)matchedInfos.iterator().next()).getParameters().size();
        ImmutableSet indicesThatShouldGetSuffix = FluentIterable.from((Iterable)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(numParameters)), (DiscreteDomain)DiscreteDomain.integers())).filter(parameterIndex -> FluentIterable.from((Iterable)matchedInfos).transform(info -> TestInfo.getTypeSuffix(((TestInfoParameter)info.getParameters().get(parameterIndex.intValue())).getValue())).toSet().size() > 1).toSet();
        return FluentIterable.from((Iterable)matchedInfos).transform(arg_0 -> TestInfo.lambda$maybeAddTypesIfDuplicate$3((Set)indicesThatShouldGetSuffix, arg_0));
    }

    private static /* synthetic */ TestInfo lambda$maybeAddTypesIfDuplicate$3(Set indicesThatShouldGetSuffix, TestInfo testInfo) {
        return testInfo.withUpdatedParameterNames((parameter, parameterIndex) -> indicesThatShouldGetSuffix.contains(parameterIndex) ? parameter.getValueInTestName() + TestInfo.getTypeSuffix(parameter.getValue()) : parameter.getValueInTestName());
    }

    private static /* synthetic */ TestInfo lambda$shortenNamesIfNecessary$3(Set parameterIndicesThatNeedUpdate, int numberOfParameters, TestInfo info) {
        return info.withUpdatedParameterNames((parameter, parameterIndex) -> parameterIndicesThatNeedUpdate.contains(parameterIndex) ? TestInfo.getShortenedName(parameter, TestInfo.getMaxCharactersPerParameter(info, numberOfParameters)) : ((TestInfoParameter)info.getParameters().get(parameterIndex.intValue())).getValueInTestName());
    }

    static interface Java8BiFunction<I, J, K> {
        public K apply(I var1, J var2);
    }

    @AutoValue
    static abstract class TestInfoParameter {
        TestInfoParameter() {
        }

        abstract String getValueInTestName();

        @Nullable
        abstract Object getValue();

        abstract int getIndexInValueSource();

        final TestInfoParameter withValueInTestName(String newValueInTestName) {
            return TestInfoParameter.create(newValueInTestName, this.getValue(), this.getIndexInValueSource());
        }

        static TestInfoParameter create(String valueInTestName, @Nullable Object value, int indexInValueSource) {
            Preconditions.checkArgument((indexInValueSource >= 0 ? 1 : 0) != 0);
            return new AutoValue_TestInfo_TestInfoParameter((String)Preconditions.checkNotNull((Object)valueInTestName), value, indexInValueSource);
        }
    }
}

