/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.testparameterinjector;

import com.google.auto.value.AutoValue;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.testing.junit.testparameterinjector.AutoAnnotation_TestParameterAnnotationMethodProcessor_TestIndexHolderFactory_create;
import com.google.testing.junit.testparameterinjector.AutoValue_TestParameterAnnotationMethodProcessor_AnnotationTypeOrigin;
import com.google.testing.junit.testparameterinjector.AutoValue_TestParameterAnnotationMethodProcessor_AnnotationWithMetadata;
import com.google.testing.junit.testparameterinjector.AutoValue_TestParameterAnnotationMethodProcessor_TestParameterValueHolder;
import com.google.testing.junit.testparameterinjector.ExecutableValidationResult;
import com.google.testing.junit.testparameterinjector.GenericParameterContext;
import com.google.testing.junit.testparameterinjector.ParameterValueParsing;
import com.google.testing.junit.testparameterinjector.TestInfo;
import com.google.testing.junit.testparameterinjector.TestMethodProcessor;
import com.google.testing.junit.testparameterinjector.TestParameter;
import com.google.testing.junit.testparameterinjector.TestParameterAnnotation;
import com.google.testing.junit.testparameterinjector.TestParameterInjectorUtils;
import com.google.testing.junit.testparameterinjector.TestParameterValidator;
import com.google.testing.junit.testparameterinjector.TestParameterValue;
import com.google.testing.junit.testparameterinjector.TestParameterValueProvider;
import com.google.testing.junit.testparameterinjector.TestParameterValues;
import com.google.testing.junit.testparameterinjector.TestParameters;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

final class TestParameterAnnotationMethodProcessor
implements TestMethodProcessor {
    private final boolean onlyForFieldsAndParameters;
    private final LoadingCache<Class<?>, ImmutableList<AnnotationTypeOrigin>> annotationTypeOriginsCache = CacheBuilder.newBuilder().maximumSize(1000L).build(CacheLoader.from(this::calculateAnnotationTypeOrigins));
    private final Cache<Method, List<List<TestParameterValueHolder>>> parameterValuesCache = CacheBuilder.newBuilder().maximumSize(1000L).build();
    private static final Class<? extends TestParameterValidator> TEST_PARAMETER_VALIDATOR = TestParameterAnnotation.DefaultValidator.class;
    private static final Class<? extends TestParameterValueProvider> TEST_PARAMETER_VALUE_PROVIDER = TestParameter.InternalImplementationOfThisParameter.class;

    public static TestParameterValues getTestParameterValues(TestInfo testInfo) {
        TestIndexHolder testIndexHolder = testInfo.getAnnotation(TestIndexHolder.class);
        if (testIndexHolder == null) {
            return annotationType -> Optional.absent();
        }
        return annotationType -> FluentIterable.from(new TestParameterAnnotationMethodProcessor(false).getParameterValuesForTest(testIndexHolder, testInfo.getTestClass())).filter(testParameterValue -> testParameterValue.annotationTypeOrigin().annotationType().equals(annotationType)).transform(TestParameterValueHolder::unwrappedValue).first();
    }

    public static Optional<Object> getTestParameterValue(TestInfo testInfo, Class<? extends Annotation> annotationType) {
        return TestParameterAnnotationMethodProcessor.getTestParameterValues(testInfo).getValue(annotationType);
    }

    private static ImmutableList<TestParameterValue> getParametersAnnotationValues(AnnotationWithMetadata annotationWithMetadata) {
        Annotation annotation = annotationWithMetadata.annotation();
        TestParameterAnnotation testParameter = annotation.annotationType().getAnnotation(TestParameterAnnotation.class);
        Class<? extends TestParameterValueProvider> valueProvider = annotation.annotationType() == TestParameter.class ? TEST_PARAMETER_VALUE_PROVIDER : testParameter.valueProvider();
        try {
            return FluentIterable.from(valueProvider.getConstructor(new Class[0]).newInstance(new Object[0]).provideValues(annotation, annotationWithMetadata.paramClass(), annotationWithMetadata.context())).transform(value -> value instanceof TestParameterValue ? (TestParameterValue)value : TestParameterValue.wrap(value)).toList();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unexpected exception while invoking value provider " + valueProvider, e);
        }
    }

    private TestParameterAnnotationMethodProcessor(boolean onlyForFieldsAndParameters) {
        this.onlyForFieldsAndParameters = onlyForFieldsAndParameters;
    }

    static TestMethodProcessor forAllAnnotationPlacements() {
        return new TestParameterAnnotationMethodProcessor(false);
    }

    static TestMethodProcessor onlyForFieldsAndParameters() {
        return new TestParameterAnnotationMethodProcessor(true);
    }

    private ImmutableList<AnnotationTypeOrigin> calculateAnnotationTypeOrigins(Class<?> testClass) {
        List<AnnotationTypeOrigin> fieldAnnotations = this.extractTestParameterAnnotations((List<Annotation>)FluentIterable.from(TestParameterAnnotationMethodProcessor.listWithParents(testClass)).transformAndConcat(c -> Arrays.asList(c.getDeclaredFields())).transformAndConcat(field -> Arrays.asList(field.getAnnotations())).toList(), Origin.FIELD);
        List<AnnotationTypeOrigin> methodAnnotations = this.extractTestParameterAnnotations((List<Annotation>)FluentIterable.from((Object[])testClass.getMethods()).transformAndConcat(method -> Arrays.asList(method.getAnnotations())).toList(), Origin.METHOD);
        List<AnnotationTypeOrigin> parameterAnnotations = this.extractTestParameterAnnotations((List<Annotation>)FluentIterable.from(TestParameterAnnotationMethodProcessor.listWithParents(testClass)).transformAndConcat(c -> Arrays.asList(c.getDeclaredMethods())).transformAndConcat(method -> Arrays.asList(method.getParameterAnnotations())).transformAndConcat(Arrays::asList).toList(), Origin.METHOD_PARAMETER);
        List<AnnotationTypeOrigin> classAnnotations = this.extractTestParameterAnnotations(Arrays.asList(testClass.getAnnotations()), Origin.CLASS);
        List<AnnotationTypeOrigin> constructorAnnotations = this.extractTestParameterAnnotations((List<Annotation>)FluentIterable.from((Object[])testClass.getDeclaredConstructors()).transformAndConcat(constructor -> Arrays.asList(constructor.getAnnotations())).toList(), Origin.CONSTRUCTOR);
        List<AnnotationTypeOrigin> constructorParameterAnnotations = this.extractTestParameterAnnotations((List<Annotation>)FluentIterable.from((Object[])testClass.getDeclaredConstructors()).transformAndConcat(constructor -> FluentIterable.from(Arrays.asList(constructor.getParameterAnnotations())).transformAndConcat(Arrays::asList)).toList(), Origin.CONSTRUCTOR_PARAMETER);
        this.checkDuplicatedClassAndFieldAnnotations(constructorAnnotations, classAnnotations, fieldAnnotations);
        this.checkDuplicatedFieldsAnnotations(methodAnnotations, fieldAnnotations);
        Preconditions.checkState((FluentIterable.from(constructorAnnotations).toSet().size() == constructorAnnotations.size() ? 1 : 0) != 0, (Object)"Annotations should not be duplicated on the constructor.");
        Preconditions.checkState((FluentIterable.from(classAnnotations).toSet().size() == classAnnotations.size() ? 1 : 0) != 0, (Object)"Annotations should not be duplicated on the class.");
        if (this.onlyForFieldsAndParameters) {
            Preconditions.checkState((boolean)methodAnnotations.isEmpty(), (String)"This test runner (constructed by the testparameterinjector package) was configured to disallow method-level annotations that could be field/parameter annotations, but found %s", methodAnnotations);
            Preconditions.checkState((boolean)classAnnotations.isEmpty(), (String)"This test runner (constructed by the testparameterinjector package) was configured to disallow class-level annotations that could be field/parameter annotations, but found %s", classAnnotations);
            Preconditions.checkState((boolean)constructorAnnotations.isEmpty(), (String)"This test runner (constructed by the testparameterinjector package) was configured to disallow constructor-level annotations that could be field/parameter annotations, but found %s", constructorAnnotations);
        }
        return FluentIterable.from(classAnnotations).append(fieldAnnotations).append(constructorAnnotations).append(constructorParameterAnnotations).append(methodAnnotations).append(parameterAnnotations).toSet().asList();
    }

    private ImmutableList<AnnotationTypeOrigin> getAnnotationTypeOrigins(Class<?> testClass, Origin firstOrigin, Origin ... otherOrigins) {
        ImmutableSet originsToFilterBy = ImmutableSet.builder().add((Object)firstOrigin).add((Object[])otherOrigins).build();
        try {
            return FluentIterable.from((Iterable)((Iterable)this.annotationTypeOriginsCache.getUnchecked(testClass))).filter(arg_0 -> TestParameterAnnotationMethodProcessor.lambda$getAnnotationTypeOrigins$0((Set)originsToFilterBy, arg_0)).toList();
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), IllegalStateException.class);
            throw e;
        }
    }

    private void checkDuplicatedFieldsAnnotations(List<AnnotationTypeOrigin> methodAnnotations, List<AnnotationTypeOrigin> fieldAnnotations) {
        if (FluentIterable.from(fieldAnnotations).toSet().size() != fieldAnnotations.size()) {
            ArrayList methodOrFieldAnnotations = new ArrayList(FluentIterable.from(methodAnnotations).append(new HashSet<AnnotationTypeOrigin>(fieldAnnotations)).transform(AnnotationTypeOrigin::annotationType).toList());
            Preconditions.checkState((FluentIterable.from(methodOrFieldAnnotations).toSet().size() == methodOrFieldAnnotations.size() ? 1 : 0) != 0, (Object)"Annotations should not be duplicated on a method and field if they are present on multiple fields");
        }
    }

    private void checkDuplicatedClassAndFieldAnnotations(List<AnnotationTypeOrigin> constructorAnnotations, List<AnnotationTypeOrigin> classAnnotations, List<AnnotationTypeOrigin> fieldAnnotations) {
        ImmutableSet classAnnotationTypes = FluentIterable.from(classAnnotations).transform(AnnotationTypeOrigin::annotationType).toSet();
        ImmutableSet uniqueFieldAnnotations = FluentIterable.from(fieldAnnotations).transform(AnnotationTypeOrigin::annotationType).toSet();
        ImmutableSet uniqueConstructorAnnotations = FluentIterable.from(constructorAnnotations).transform(AnnotationTypeOrigin::annotationType).toSet();
        Preconditions.checkState((boolean)Collections.disjoint(classAnnotationTypes, uniqueFieldAnnotations), (Object)"Annotations should not be duplicated on a class and field");
        Preconditions.checkState((boolean)Collections.disjoint(classAnnotationTypes, uniqueConstructorAnnotations), (Object)"Annotations should not be duplicated on a class and constructor");
        Preconditions.checkState((boolean)Collections.disjoint(uniqueConstructorAnnotations, uniqueFieldAnnotations), (Object)"Annotations should not be duplicated on a field and constructor");
    }

    private List<AnnotationTypeOrigin> extractTestParameterAnnotations(List<Annotation> annotations, Origin origin) {
        return new ArrayList<AnnotationTypeOrigin>((Collection<AnnotationTypeOrigin>)FluentIterable.from(annotations).transform(Annotation::annotationType).filter(annotationType -> annotationType.isAnnotationPresent(TestParameterAnnotation.class)).transform(annotationType -> AnnotationTypeOrigin.create(annotationType, origin)).toList());
    }

    @Override
    public ExecutableValidationResult validateConstructor(Constructor<?> constructor) {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        if (parameterTypes.length == 0) {
            return ExecutableValidationResult.notValidated();
        }
        Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
        Class<?> testClass = constructor.getDeclaringClass();
        return ExecutableValidationResult.validated(this.validateMethodOrConstructorParameters(this.removeOverrides((List<AnnotationTypeOrigin>)this.getAnnotationTypeOrigins(testClass, Origin.CLASS, Origin.CONSTRUCTOR, Origin.CONSTRUCTOR_PARAMETER), testClass), testClass, constructor, parameterTypes, parameterAnnotations));
    }

    @Override
    public ExecutableValidationResult validateTestMethod(Method testMethod, Class<?> testClass) {
        Class<?>[] methodParameterTypes = testMethod.getParameterTypes();
        if (methodParameterTypes.length == 0) {
            return ExecutableValidationResult.notValidated();
        }
        return ExecutableValidationResult.validated(this.validateMethodOrConstructorParameters((List<AnnotationTypeOrigin>)this.getAnnotationTypeOrigins(testClass, Origin.CLASS, Origin.METHOD, Origin.METHOD_PARAMETER), testClass, testMethod, methodParameterTypes, testMethod.getParameterAnnotations()));
    }

    private List<Throwable> validateMethodOrConstructorParameters(List<AnnotationTypeOrigin> annotationTypeOrigins, Class<?> testClass, AnnotatedElement methodOrConstructor, Class<?>[] parameterTypes, Annotation[][] parametersAnnotations) {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        for (int parameterIndex = 0; parameterIndex < parameterTypes.length; ++parameterIndex) {
            Class<?> parameterType = parameterTypes[parameterIndex];
            Annotation[] parameterAnnotations = parametersAnnotations[parameterIndex];
            boolean matchingTestParameterAnnotationFound = false;
            for (AnnotationTypeOrigin testParameterAnnotationType : annotationTypeOrigins) {
                for (Annotation parameterAnnotation : parameterAnnotations) {
                    if (!parameterAnnotation.annotationType().equals(testParameterAnnotationType.annotationType())) continue;
                    Class<?> valueMethodReturnType = TestParameterAnnotationMethodProcessor.getValueMethodReturnType(testParameterAnnotationType.annotationType(), Optional.of(parameterType));
                    if (!parameterType.isAssignableFrom(valueMethodReturnType)) {
                        errors.add(new IllegalStateException(String.format("Parameter of type %s annotated with %s does not match expected type %s in method/constructor %s", parameterType.getName(), testParameterAnnotationType.annotationType().getName(), valueMethodReturnType.getName(), methodOrConstructor)));
                        continue;
                    }
                    matchingTestParameterAnnotationFound = true;
                }
            }
            if (!matchingTestParameterAnnotationFound) {
                ImmutableList<? extends Class<? extends Annotation>> testParameterAnnotationTypes = this.getTestParameterAnnotations((List<AnnotationTypeOrigin>)TestParameterAnnotationMethodProcessor.filterAnnotationTypeOriginsByOrigin(annotationTypeOrigins, Origin.CLASS, Origin.CONSTRUCTOR, Origin.METHOD), testClass, methodOrConstructor);
                for (Class testParameterAnnotationType : testParameterAnnotationTypes) {
                    if (!parameterType.isAssignableFrom(TestParameterAnnotationMethodProcessor.getValueMethodReturnType(testParameterAnnotationType, Optional.absent()))) continue;
                    if (matchingTestParameterAnnotationFound) {
                        errors.add(new IllegalStateException(String.format("Ambiguous method/constructor parameter type, matching multiple annotations for parameter of type %s in method %s", parameterType.getName(), methodOrConstructor)));
                    }
                    matchingTestParameterAnnotationFound = true;
                }
            }
            if (matchingTestParameterAnnotationFound) continue;
            errors.add(new IllegalStateException(String.format("No matching test parameter annotation found for parameter of type %s in method/constructor %s", parameterType.getName(), methodOrConstructor)));
        }
        return errors;
    }

    @Override
    public Optional<List<Object>> maybeGetConstructorParameters(Constructor<?> constructor, TestInfo testInfo) {
        if (testInfo.getAnnotation(TestIndexHolder.class) == null || constructor.isAnnotationPresent(TestParameters.class)) {
            return Optional.absent();
        }
        TestIndexHolder testIndexHolder = testInfo.getAnnotation(TestIndexHolder.class);
        List<TestParameterValueHolder> testParameterValues = this.getParameterValuesForTest(testIndexHolder, testInfo.getTestClass());
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
        ArrayList<Object> parameterValues = new ArrayList<Object>(parameterTypes.length);
        ArrayList<Class<? extends Annotation>> processedAnnotationTypes = new ArrayList<Class<? extends Annotation>>();
        ImmutableList<TestParameterValueHolder> parameterValuesForConstructor = TestParameterAnnotationMethodProcessor.filterByOrigin(testParameterValues, Origin.CLASS, Origin.CONSTRUCTOR, Origin.CONSTRUCTOR_PARAMETER);
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterValues.add(this.getParameterValue((List<TestParameterValueHolder>)parameterValuesForConstructor, parameterTypes[i], parameterAnnotations[i], (List<Class<? extends Annotation>>)processedAnnotationTypes));
        }
        return Optional.of(parameterValues);
    }

    @Override
    public Optional<List<Object>> maybeGetTestMethodParameters(TestInfo testInfo) {
        Method testMethod = testInfo.getMethod();
        if (testInfo.getAnnotation(TestIndexHolder.class) == null || testMethod.isAnnotationPresent(TestParameters.class)) {
            return Optional.absent();
        }
        TestIndexHolder testIndexHolder = testInfo.getAnnotation(TestIndexHolder.class);
        Preconditions.checkState((testIndexHolder != null ? 1 : 0) != 0);
        ImmutableList<TestParameterValueHolder> testParameterValues = TestParameterAnnotationMethodProcessor.filterByOrigin(this.getParameterValuesForTest(testIndexHolder, testInfo.getTestClass()), Origin.CLASS, Origin.METHOD, Origin.METHOD_PARAMETER);
        Class<?>[] parameterTypes = testMethod.getParameterTypes();
        Annotation[][] parametersAnnotations = testMethod.getParameterAnnotations();
        ArrayList<Object> parameterValues = new ArrayList<Object>(parameterTypes.length);
        ArrayList<Class<? extends Annotation>> processedAnnotationTypes = new ArrayList<Class<? extends Annotation>>();
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterValues.add(this.getParameterValue((List<TestParameterValueHolder>)testParameterValues, parameterTypes[i], parametersAnnotations[i], (List<Class<? extends Annotation>>)processedAnnotationTypes));
        }
        return Optional.of(parameterValues);
    }

    @Override
    public List<TestInfo> calculateTestInfos(TestInfo originalTest) {
        List<List<TestParameterValueHolder>> parameterValuesForMethod = this.getParameterValuesForMethod(originalTest.getMethod(), originalTest.getTestClass());
        if (parameterValuesForMethod.equals(ImmutableList.of((Object)ImmutableList.of()))) {
            return ImmutableList.of((Object)originalTest);
        }
        ImmutableList.Builder testInfos = ImmutableList.builder();
        for (int parametersIndex = 0; parametersIndex < parameterValuesForMethod.size(); ++parametersIndex) {
            List<TestParameterValueHolder> testParameterValues = parameterValuesForMethod.get(parametersIndex);
            testInfos.add((Object)originalTest.withExtraParameters((List<TestInfo.TestInfoParameter>)FluentIterable.from(testParameterValues).transform(param -> TestInfo.TestInfoParameter.create(param.toTestNameString(), param.unwrappedValue(), param.valueIndex())).toList()).withExtraAnnotation(TestIndexHolderFactory.create(this.strictIndexOf((List)this.getMethodsIncludingParentsSorted(originalTest.getTestClass()), (Object)originalTest.getMethod()), parametersIndex, originalTest.getTestClass().getName())));
        }
        return testInfos.build();
    }

    private List<List<TestParameterValueHolder>> getParameterValuesForMethod(Method method, Class<?> testClass) {
        try {
            return (List)this.parameterValuesCache.get((Object)method, () -> {
                ImmutableList<List<TestParameterValueHolder>> testParameterValuesList = this.getAnnotationValuesForUsedAnnotationTypes(method, testClass);
                return FluentIterable.from((Iterable)Lists.cartesianProduct(testParameterValuesList)).filter(testParameterValues -> FluentIterable.from((Iterable)testParameterValues).filter(testParameterValue -> TestParameterAnnotationMethodProcessor.callShouldSkip(testParameterValue.annotationTypeOrigin().annotationType(), testParameterValues)).isEmpty()).toList();
            });
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e);
        }
    }

    private List<TestParameterValueHolder> getParameterValuesForTest(TestIndexHolder testIndexHolder, Class<?> testClass) {
        Verify.verify((boolean)testIndexHolder.testClassName().equals(testClass.getName()), (String)"The class for which the given annotation was created (%s) is not the same as the test class that this runner is handling (%s)", (Object)testIndexHolder.testClassName(), (Object)testClass.getName());
        Method testMethod = (Method)this.getMethodsIncludingParentsSorted(testClass).get(testIndexHolder.methodIndex());
        return this.getParameterValuesForMethod(testMethod, testClass).get(testIndexHolder.parametersIndex());
    }

    private ImmutableList<List<TestParameterValueHolder>> getAnnotationValuesForUsedAnnotationTypes(Method method, Class<?> testClass) {
        ImmutableList annotationTypes = FluentIterable.from(this.getAnnotationTypeOrigins(testClass, Origin.CLASS, new Origin[0])).append(this.getAnnotationTypeOrigins(testClass, Origin.FIELD, new Origin[0])).append(this.getAnnotationTypeOrigins(testClass, Origin.CONSTRUCTOR, new Origin[0])).append(this.getAnnotationTypeOrigins(testClass, Origin.CONSTRUCTOR_PARAMETER, new Origin[0])).append(this.getAnnotationTypeOrigins(testClass, Origin.METHOD, new Origin[0])).append((Iterable)ImmutableList.sortedCopyOf(this.annotationComparator(method.getParameterAnnotations()), this.getAnnotationTypeOrigins(testClass, Origin.METHOD_PARAMETER, new Origin[0]))).toList();
        return FluentIterable.from(this.removeOverrides((List<AnnotationTypeOrigin>)annotationTypes, testClass, method)).transform(annotationTypeOrigin -> this.getAnnotationFromParametersOrTestOrClass((AnnotationTypeOrigin)annotationTypeOrigin, method, testClass)).filter(l -> !l.isEmpty()).transformAndConcat(i -> i).toList();
    }

    private Comparator<AnnotationTypeOrigin> annotationComparator(Annotation[][] parameterAnnotations) {
        ImmutableList annotationOrdering = FluentIterable.from((Object[])parameterAnnotations).transformAndConcat(Arrays::asList).transform(Annotation::annotationType).transform(Class::getName).toList();
        return (annotationTypeOrigin, t1) -> Integer.compare(annotationOrdering.indexOf((Object)annotationTypeOrigin.annotationType().getName()), annotationOrdering.indexOf((Object)t1.annotationType().getName()));
    }

    private List<AnnotationTypeOrigin> removeOverrides(List<AnnotationTypeOrigin> annotationTypeOrigins, Class<?> testClass, Method method) {
        return this.removeOverrides(new ArrayList<AnnotationTypeOrigin>((Collection<AnnotationTypeOrigin>)FluentIterable.from(annotationTypeOrigins).filter(annotationTypeOrigin -> {
            switch (annotationTypeOrigin.origin().ordinal()) {
                case 0: 
                case 1: {
                    return this.getAnnotationListWithType(method.getAnnotations(), annotationTypeOrigin.annotationType()).isEmpty();
                }
            }
            return true;
        }).toList()), testClass);
    }

    private List<AnnotationTypeOrigin> removeOverrides(List<AnnotationTypeOrigin> annotationTypeOrigins, Class<?> testClass) {
        return new ArrayList<AnnotationTypeOrigin>((Collection<AnnotationTypeOrigin>)FluentIterable.from(annotationTypeOrigins).filter(annotationTypeOrigin -> {
            switch (annotationTypeOrigin.origin().ordinal()) {
                case 0: 
                case 1: {
                    return this.getAnnotationListWithType(TestParameterInjectorUtils.getOnlyConstructor(testClass).getAnnotations(), annotationTypeOrigin.annotationType()).isEmpty();
                }
            }
            return true;
        }).toList());
    }

    private ImmutableList<List<TestParameterValueHolder>> getAnnotationFromParametersOrTestOrClass(AnnotationTypeOrigin annotationTypeOrigin, Method method, Class<?> testClass) {
        Annotation annotation;
        Origin origin = annotationTypeOrigin.origin();
        Class<? extends Annotation> annotationType = annotationTypeOrigin.annotationType();
        if (origin == Origin.CONSTRUCTOR_PARAMETER) {
            Constructor<?> constructor = TestParameterInjectorUtils.getOnlyConstructor(testClass);
            ImmutableList<AnnotationWithMetadata> annotations = TestParameterAnnotationMethodProcessor.getAnnotationWithMetadataListWithType(constructor, annotationType, testClass);
            if (!annotations.isEmpty()) {
                return TestParameterAnnotationMethodProcessor.toTestParameterValueList(annotations, origin);
            }
        } else if (origin == Origin.CONSTRUCTOR) {
            Annotation annotation2 = TestParameterInjectorUtils.getOnlyConstructor(testClass).getAnnotation(annotationType);
            if (annotation2 != null) {
                return ImmutableList.of(TestParameterValueHolder.create(AnnotationWithMetadata.withoutMetadata(annotation2, GenericParameterContext.createWithoutParameterAnnotations(testClass)), origin));
            }
        } else if (origin == Origin.METHOD_PARAMETER) {
            ImmutableList<AnnotationWithMetadata> annotations = TestParameterAnnotationMethodProcessor.getAnnotationWithMetadataListWithType(method, annotationType, testClass);
            if (!annotations.isEmpty()) {
                return TestParameterAnnotationMethodProcessor.toTestParameterValueList(annotations, origin);
            }
        } else if (origin == Origin.METHOD) {
            if (method.isAnnotationPresent(annotationType)) {
                return ImmutableList.of(TestParameterValueHolder.create(AnnotationWithMetadata.withoutMetadata(method.getAnnotation(annotationType), GenericParameterContext.createWithoutParameterAnnotations(testClass)), origin));
            }
        } else if (origin == Origin.FIELD) {
            List<AnnotationWithMetadata> annotations = new ArrayList<AnnotationWithMetadata>((Collection<AnnotationWithMetadata>)FluentIterable.from(TestParameterAnnotationMethodProcessor.listWithParents(testClass)).transformAndConcat(c -> Arrays.asList(c.getDeclaredFields())).transformAndConcat(field -> FluentIterable.from(this.getAnnotationListWithType(field.getAnnotations(), annotationType)).transform(annotation -> AnnotationWithMetadata.withMetadata(annotation, field.getType(), field.getName(), GenericParameterContext.create(field, testClass)))).toList());
            if (TestParameterAnnotationMethodProcessor.isKotlinClass(testClass)) {
                annotations = TestParameterAnnotationMethodProcessor.applyKotlinDuplicateAnnotationWorkaround(annotations, annotationType, testClass);
            }
            if (!annotations.isEmpty()) {
                return TestParameterAnnotationMethodProcessor.toTestParameterValueList(annotations, origin);
            }
        } else if (origin == Origin.CLASS && (annotation = testClass.getAnnotation(annotationType)) != null) {
            return ImmutableList.of(TestParameterValueHolder.create(AnnotationWithMetadata.withoutMetadata(annotation, GenericParameterContext.createWithoutParameterAnnotations(testClass)), origin));
        }
        return ImmutableList.of();
    }

    private static List<AnnotationWithMetadata> applyKotlinDuplicateAnnotationWorkaround(List<AnnotationWithMetadata> fieldAnnotations, Class<? extends Annotation> annotationType, Class<?> testClass) {
        ImmutableList<AnnotationWithMetadata> constructorAnnotations = TestParameterAnnotationMethodProcessor.getAnnotationWithMetadataListWithType(TestParameterInjectorUtils.getOnlyConstructor(testClass), annotationType, testClass);
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (AnnotationWithMetadata fieldAnnotation : fieldAnnotations) {
            ImmutableList matchingConstructorAnnotations = FluentIterable.from(constructorAnnotations).filter(constructorAnnotation -> fieldAnnotation.annotation().equals(constructorAnnotation.annotation()) && fieldAnnotation.paramClass().equals(constructorAnnotation.paramClass())).toList();
            if (matchingConstructorAnnotations.isEmpty()) {
                resultBuilder.add((Object)fieldAnnotation);
                continue;
            }
            if (((AnnotationWithMetadata)matchingConstructorAnnotations.get(0)).paramName().isPresent()) {
                if (!FluentIterable.from((Iterable)matchingConstructorAnnotations).filter(constructorAnnotation -> fieldAnnotation.paramName().equals(constructorAnnotation.paramName())).isEmpty()) continue;
                resultBuilder.add((Object)fieldAnnotation);
                continue;
            }
            throw new RuntimeException(String.format("%s: Found a Kotlin field (%s) and constructor parameter with the same type. This may be an artefact of the Kotlin-Java translation of a field+parameter in the primary constructor. However, TestParameterInjector needs to be built with access to parameter names to be able to confirm.\n\nTo fix this error, either:\n  - Use `@param:TestParameter` instead of `@TestParameter` on the primary constructor parameter.\n  - Build this test with the `-parameters` compiler option. In  Maven, you do this by adding <javaParameters>true</javaParameters> to the kotlin-maven-plugin's configuration.", testClass.getSimpleName(), fieldAnnotation.paramName().get()));
        }
        return resultBuilder.build();
    }

    private static ImmutableList<List<TestParameterValueHolder>> toTestParameterValueList(List<AnnotationWithMetadata> annotationWithMetadatas, Origin origin) {
        return FluentIterable.from(annotationWithMetadatas).transform(annotationWithMetadata -> new ArrayList<TestParameterValueHolder>((Collection<TestParameterValueHolder>)TestParameterValueHolder.create(annotationWithMetadata, origin))).toList();
    }

    private static ImmutableList<AnnotationWithMetadata> getAnnotationWithMetadataListWithType(Method callable, Class<? extends Annotation> annotationType, Class<?> testClass) {
        try {
            return TestParameterAnnotationMethodProcessor.getAnnotationWithMetadataListWithType(callable.getParameters(), annotationType, testClass);
        }
        catch (NoSuchMethodError ignored) {
            return TestParameterAnnotationMethodProcessor.getAnnotationWithMetadataListWithType(callable.getParameterTypes(), callable.getParameterAnnotations(), annotationType, testClass);
        }
    }

    private static ImmutableList<AnnotationWithMetadata> getAnnotationWithMetadataListWithType(Constructor<?> callable, Class<? extends Annotation> annotationType, Class<?> testClass) {
        try {
            return TestParameterAnnotationMethodProcessor.getAnnotationWithMetadataListWithType(callable.getParameters(), annotationType, testClass);
        }
        catch (NoSuchMethodError ignored) {
            return TestParameterAnnotationMethodProcessor.getAnnotationWithMetadataListWithType(callable.getParameterTypes(), callable.getParameterAnnotations(), annotationType, testClass);
        }
    }

    private static ImmutableList<AnnotationWithMetadata> getAnnotationWithMetadataListWithType(Parameter[] parameters, Class<? extends Annotation> annotationType, Class<?> testClass) {
        return FluentIterable.from((Object[])parameters).transform(parameter -> {
            Object annotation = parameter.getAnnotation(annotationType);
            return annotation == null ? null : (parameter.isNamePresent() ? AnnotationWithMetadata.withMetadata(annotation, parameter.getType(), parameter.getName(), GenericParameterContext.create(parameter, testClass)) : AnnotationWithMetadata.withMetadata(annotation, parameter.getType(), GenericParameterContext.create(parameter, testClass)));
        }).filter(Objects::nonNull).toList();
    }

    private static ImmutableList<AnnotationWithMetadata> getAnnotationWithMetadataListWithType(Class<?>[] parameterTypes, Annotation[][] annotations, Class<? extends Annotation> annotationType, Class<?> testClass) {
        Preconditions.checkArgument((parameterTypes.length == annotations.length ? 1 : 0) != 0);
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (int i = 0; i < annotations.length; ++i) {
            for (Annotation annotation : annotations[i]) {
                if (!annotation.annotationType().equals(annotationType)) continue;
                resultBuilder.add((Object)AnnotationWithMetadata.withMetadata(annotation, parameterTypes[i], GenericParameterContext.createWithRepeatableAnnotationsFallback(annotations[i], testClass)));
            }
        }
        return resultBuilder.build();
    }

    private ImmutableList<Annotation> getAnnotationListWithType(Annotation[] annotations, Class<? extends Annotation> annotationType) {
        return FluentIterable.from((Object[])annotations).filter(annotation -> annotation.annotationType().equals(annotationType)).toList();
    }

    @Override
    public void postProcessTestInstance(Object testInstance, TestInfo testInfo) {
        TestIndexHolder testIndexHolder = testInfo.getAnnotation(TestIndexHolder.class);
        try {
            if (testIndexHolder != null) {
                List<TestParameterValueHolder> testParameterValues = this.getParameterValuesForTest(testIndexHolder, testInfo.getTestClass());
                ImmutableList<TestParameterValueHolder> testParameterValuesForFieldInjection = TestParameterAnnotationMethodProcessor.filterByOrigin(testParameterValues, Origin.CLASS, Origin.FIELD, Origin.METHOD);
                ArrayList<TestParameterValueHolder> remainingTestParameterValuesForFieldInjection = new ArrayList<TestParameterValueHolder>((Collection<TestParameterValueHolder>)testParameterValuesForFieldInjection);
                block2: for (Field declaredField : FluentIterable.from(TestParameterAnnotationMethodProcessor.listWithParents(testInstance.getClass())).transformAndConcat(c -> Arrays.asList(c.getDeclaredFields())).toList()) {
                    for (TestParameterValueHolder testParameterValue : remainingTestParameterValuesForFieldInjection) {
                        if (!declaredField.isAnnotationPresent(testParameterValue.annotationTypeOrigin().annotationType()) || testParameterValue.paramName().isPresent() && !declaredField.getName().equals(testParameterValue.paramName().get())) continue;
                        declaredField.setAccessible(true);
                        declaredField.set(testInstance, testParameterValue.unwrappedValue());
                        remainingTestParameterValuesForFieldInjection.remove(testParameterValue);
                        continue block2;
                    }
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static ImmutableList<TestParameterValueHolder> filterByOrigin(List<TestParameterValueHolder> testParameterValues, Origin ... origins) {
        ImmutableSet originsToFilterBy = ImmutableSet.copyOf((Object[])origins);
        return FluentIterable.from(testParameterValues).filter(arg_0 -> TestParameterAnnotationMethodProcessor.lambda$filterByOrigin$0((Set)originsToFilterBy, arg_0)).toList();
    }

    private static ImmutableList<AnnotationTypeOrigin> filterAnnotationTypeOriginsByOrigin(List<AnnotationTypeOrigin> annotationTypeOrigins, Origin ... origins) {
        List<Origin> originList = Arrays.asList(origins);
        return FluentIterable.from(annotationTypeOrigins).filter(annotationTypeOrigin -> originList.contains((Object)annotationTypeOrigin.origin())).toList();
    }

    private Object getParameterValue(List<TestParameterValueHolder> testParameterValues, Class<?> methodParameterType, Annotation[] parameterAnnotations, List<Class<? extends Annotation>> processedAnnotationTypes) {
        ArrayList<Class<? extends Annotation>> iteratedAnnotationTypes = new ArrayList<Class<? extends Annotation>>();
        for (TestParameterValueHolder testParameterValue : testParameterValues) {
            for (Annotation parameterAnnotation : parameterAnnotations) {
                Class<? extends Annotation> annotationType = testParameterValue.annotationTypeOrigin().annotationType();
                if (!parameterAnnotation.annotationType().equals(annotationType)) continue;
                if (Collections.frequency(processedAnnotationTypes, annotationType) == Collections.frequency(iteratedAnnotationTypes, annotationType)) {
                    processedAnnotationTypes.add(annotationType);
                    return testParameterValue.unwrappedValue();
                }
                iteratedAnnotationTypes.add(annotationType);
            }
        }
        for (TestParameterValueHolder testParameterValue : testParameterValues) {
            if (!methodParameterType.isAssignableFrom(TestParameterAnnotationMethodProcessor.getValueMethodReturnType(testParameterValue.annotationTypeOrigin().annotationType(), Optional.absent()))) continue;
            return testParameterValue.unwrappedValue();
        }
        throw new IllegalStateException("The method parameter should have matched a TestParameterAnnotation");
    }

    private static boolean callShouldSkip(Class<? extends Annotation> annotationType, List<TestParameterValueHolder> testParameterValues) {
        TestParameterAnnotation annotation = annotationType.getAnnotation(TestParameterAnnotation.class);
        Class<? extends TestParameterValidator> validator = annotationType == TestParameter.class ? TEST_PARAMETER_VALIDATOR : annotation.validator();
        try {
            return validator.getConstructor(new Class[0]).newInstance(new Object[0]).shouldSkip(new ValidatorContext(testParameterValues));
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception while invoking validator " + validator, e);
        }
    }

    private static Class<?> getValueMethodReturnType(Class<? extends Annotation> annotationType, Optional<Class<?>> paramClass) {
        TestParameterAnnotation testParameter = annotationType.getAnnotation(TestParameterAnnotation.class);
        Class<? extends TestParameterValueProvider> valueProvider = annotationType == TestParameter.class ? TEST_PARAMETER_VALUE_PROVIDER : testParameter.valueProvider();
        try {
            return valueProvider.getConstructor(new Class[0]).newInstance(new Object[0]).getValueType(annotationType, paramClass);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception while invoking value provider " + valueProvider, e);
        }
    }

    private ImmutableList<? extends Class<? extends Annotation>> getTestParameterAnnotations(List<AnnotationTypeOrigin> annotationTypeOrigins, Class<?> testClass, AnnotatedElement methodOrConstructor) {
        return FluentIterable.from(annotationTypeOrigins).transform(AnnotationTypeOrigin::annotationType).filter(annotationType -> testClass.isAnnotationPresent((Class<Annotation>)annotationType) || methodOrConstructor.isAnnotationPresent((Class<? extends Annotation>)annotationType)).toList();
    }

    private <T> int strictIndexOf(List<T> haystack, T needle) {
        int index = haystack.indexOf(needle);
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (String)"Could not find '%s' in %s", needle, haystack);
        return index;
    }

    private ImmutableList<Method> getMethodsIncludingParentsSorted(Class<?> clazz) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        while (clazz != null) {
            resultBuilder.add((Object[])clazz.getDeclaredMethods());
            clazz = clazz.getSuperclass();
        }
        return ImmutableList.sortedCopyOf((Comparator)Ordering.natural().onResultOf(Method::getName), (Iterable)resultBuilder.build());
    }

    private static ImmutableList<Class<?>> listWithParents(Class<?> clazz) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            resultBuilder.add(currentClass);
        }
        return resultBuilder.build();
    }

    private static boolean isAndroid() {
        return System.getProperty("java.runtime.name", "").contains("Android");
    }

    private static boolean isKotlinClass(Class<?> clazz) {
        return FluentIterable.from((Object[])clazz.getDeclaredAnnotations()).anyMatch(annotation -> annotation.annotationType().getName().equals("kotlin.Metadata"));
    }

    private static /* synthetic */ boolean lambda$filterByOrigin$0(Set originsToFilterBy, TestParameterValueHolder testParameterValue) {
        return originsToFilterBy.contains((Object)testParameterValue.annotationTypeOrigin().origin());
    }

    private static /* synthetic */ boolean lambda$getAnnotationTypeOrigins$0(Set originsToFilterBy, AnnotationTypeOrigin annotationTypeOrigin) {
        return originsToFilterBy.contains((Object)annotationTypeOrigin.origin());
    }

    static {
        if (!TestParameterAnnotationMethodProcessor.isAndroid()) {
            TestParameterAnnotation annotation = TestParameter.class.getAnnotation(TestParameterAnnotation.class);
            if (!annotation.validator().equals(TEST_PARAMETER_VALIDATOR)) {
                throw new AssertionError((Object)String.format("The value of validator() in the @TestParameterAnnotation annotation in TestParameter.java has changed to %s. Update the constant in TestParameterAnnotationMethodProcessor, which currently has value %s, to match", annotation.validator().getName(), TEST_PARAMETER_VALIDATOR.getName()));
            }
            if (!annotation.valueProvider().equals(TEST_PARAMETER_VALUE_PROVIDER)) {
                throw new AssertionError((Object)String.format("The value of valueProvider() in the @TestParameterAnnotation annotation in TestParameter.java has changed to %s. Update the constant in TestParameterAnnotationMethodProcessor, which currently has value %s, to match", annotation.valueProvider().getName(), TEST_PARAMETER_VALUE_PROVIDER.getName()));
            }
        }
    }

    @AutoValue
    static abstract class AnnotationWithMetadata
    implements Serializable {
        AnnotationWithMetadata() {
        }

        abstract Annotation annotation();

        abstract Optional<Class<?>> paramClass();

        abstract Optional<String> paramName();

        abstract GenericParameterContext context();

        public static AnnotationWithMetadata withMetadata(Annotation annotation, Class<?> paramClass, String paramName, GenericParameterContext context) {
            return new AutoValue_TestParameterAnnotationMethodProcessor_AnnotationWithMetadata(annotation, Optional.of(paramClass), (Optional<String>)Optional.of((Object)paramName), context);
        }

        public static AnnotationWithMetadata withMetadata(Annotation annotation, Class<?> paramClass, GenericParameterContext context) {
            return new AutoValue_TestParameterAnnotationMethodProcessor_AnnotationWithMetadata(annotation, Optional.of(paramClass), (Optional<String>)Optional.absent(), context);
        }

        public static AnnotationWithMetadata withoutMetadata(Annotation annotation, GenericParameterContext context) {
            return new AutoValue_TestParameterAnnotationMethodProcessor_AnnotationWithMetadata(annotation, Optional.absent(), (Optional<String>)Optional.absent(), context);
        }

        public final boolean equals(Object other) {
            throw new UnsupportedOperationException("Equality is not supported");
        }

        public final int hashCode() {
            throw new UnsupportedOperationException("hashCode() is not supported");
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface TestIndexHolder {
        public int methodIndex();

        public int parametersIndex();

        public String testClassName();
    }

    static enum Origin {
        CLASS,
        FIELD,
        METHOD,
        METHOD_PARAMETER,
        CONSTRUCTOR,
        CONSTRUCTOR_PARAMETER;

    }

    @AutoValue
    static abstract class AnnotationTypeOrigin
    implements Serializable {
        private static final long serialVersionUID = 4909750539931241385L;

        AnnotationTypeOrigin() {
        }

        abstract Class<? extends Annotation> annotationType();

        abstract Origin origin();

        public static AnnotationTypeOrigin create(Class<? extends Annotation> annotationType, Origin origin) {
            return new AutoValue_TestParameterAnnotationMethodProcessor_AnnotationTypeOrigin(annotationType, origin);
        }

        public final String toString() {
            return this.annotationType().getSimpleName() + ":" + (Object)((Object)this.origin());
        }
    }

    static class TestIndexHolderFactory {
        static TestIndexHolder create(int methodIndex, int parametersIndex, String testClassName) {
            return new AutoAnnotation_TestParameterAnnotationMethodProcessor_TestIndexHolderFactory_create(methodIndex, parametersIndex, testClassName);
        }

        private TestIndexHolderFactory() {
        }
    }

    @AutoValue
    static abstract class TestParameterValueHolder
    implements Serializable {
        private static final long serialVersionUID = -6491624726743872379L;

        TestParameterValueHolder() {
        }

        abstract AnnotationTypeOrigin annotationTypeOrigin();

        abstract TestParameterValue wrappedValue();

        abstract int valueIndex();

        abstract List<Object> specifiedValues();

        abstract Optional<String> paramName();

        @Nullable
        Object unwrappedValue() {
            return this.wrappedValue().getWrappedValue();
        }

        String toTestNameString() {
            return ParameterValueParsing.formatTestNameString(this.paramName(), this.wrappedValue());
        }

        public static ImmutableList<TestParameterValueHolder> create(AnnotationWithMetadata annotationWithMetadata, Origin origin) {
            ImmutableList specifiedValues = TestParameterAnnotationMethodProcessor.getParametersAnnotationValues(annotationWithMetadata);
            Preconditions.checkState((!specifiedValues.isEmpty() ? 1 : 0) != 0, (Object)"The number of parameter values should not be 0, otherwise the parameter would cause the test to be skipped.");
            return FluentIterable.from((Iterable)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(specifiedValues.size())), (DiscreteDomain)DiscreteDomain.integers())).transform(arg_0 -> TestParameterValueHolder.lambda$create$0(annotationWithMetadata, origin, (List)specifiedValues, arg_0)).toList();
        }

        private static /* synthetic */ TestParameterValueHolder lambda$create$0(AnnotationWithMetadata annotationWithMetadata, Origin origin, List specifiedValues, Integer valueIndex) {
            return new AutoValue_TestParameterAnnotationMethodProcessor_TestParameterValueHolder(AnnotationTypeOrigin.create(annotationWithMetadata.annotation().annotationType(), origin), (TestParameterValue)specifiedValues.get(valueIndex), valueIndex, Lists.newArrayList((Iterable)FluentIterable.from((Iterable)specifiedValues).transform(TestParameterValue::getWrappedValue)), annotationWithMetadata.paramName());
        }
    }

    private static class ValidatorContext
    implements TestParameterValidator.Context {
        private final List<TestParameterValueHolder> testParameterValues;
        private final Set<Object> valueList;

        public ValidatorContext(List<TestParameterValueHolder> testParameterValues) {
            this.testParameterValues = testParameterValues;
            this.valueList = FluentIterable.from(testParameterValues).transform(TestParameterValueHolder::unwrappedValue).filter(Objects::nonNull).toSet();
        }

        @Override
        public boolean has(Class<? extends Annotation> testParameter, Object value) {
            return (Boolean)this.getValue(testParameter).transform(value::equals).or((Object)false);
        }

        @Override
        public <T extends Enum<T>, U extends Enum<U>> boolean has(T value1, U value2) {
            return this.valueList.contains(value1) && this.valueList.contains(value2);
        }

        @Override
        public Optional<Object> getValue(Class<? extends Annotation> testParameter) {
            return this.getParameter(testParameter).transform(TestParameterValueHolder::unwrappedValue);
        }

        @Override
        public List<Object> getSpecifiedValues(Class<? extends Annotation> testParameter) {
            return (List)this.getParameter(testParameter).transform(TestParameterValueHolder::specifiedValues).or((Object)ImmutableList.of());
        }

        private Optional<TestParameterValueHolder> getParameter(Class<? extends Annotation> testParameter) {
            return FluentIterable.from(this.testParameterValues).firstMatch(value -> value.annotationTypeOrigin().annotationType().equals(testParameter));
        }
    }
}

