/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.testparameterinjector;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.testing.junit.testparameterinjector.AutoAnnotation_TestParameterAnnotationMethodProcessor_TestIndexHolderFactory_create;
import com.google.testing.junit.testparameterinjector.AutoValue_TestParameterAnnotationMethodProcessor_AnnotationTypeOrigin;
import com.google.testing.junit.testparameterinjector.AutoValue_TestParameterAnnotationMethodProcessor_AnnotationWithMetadata;
import com.google.testing.junit.testparameterinjector.AutoValue_TestParameterAnnotationMethodProcessor_TestParameterValue;
import com.google.testing.junit.testparameterinjector.TestInfo;
import com.google.testing.junit.testparameterinjector.TestMethodProcessor;
import com.google.testing.junit.testparameterinjector.TestParameterAnnotation;
import com.google.testing.junit.testparameterinjector.TestParameterProcessor;
import com.google.testing.junit.testparameterinjector.TestParameterValidator;
import com.google.testing.junit.testparameterinjector.TestParameterValueProvider;
import com.google.testing.junit.testparameterinjector.TestParameterValues;
import com.google.testing.junit.testparameterinjector.TestParameters;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

class TestParameterAnnotationMethodProcessor
implements TestMethodProcessor {
    private final TestClass testClass;
    private final boolean onlyForFieldsAndParameters;
    private volatile ImmutableList<AnnotationTypeOrigin> cachedAnnotationTypeOrigins;
    private final Cache<Method, List<List<TestParameterValue>>> parameterValuesCache = CacheBuilder.newBuilder().maximumSize(1000L).build();

    public static TestParameterValues getTestParameterValues(TestInfo testInfo) {
        TestIndexHolder testIndexHolder = testInfo.getAnnotation(TestIndexHolder.class);
        if (testIndexHolder == null) {
            return annotationType -> com.google.common.base.Optional.absent();
        }
        return annotationType -> com.google.common.base.Optional.fromNullable(new TestParameterAnnotationMethodProcessor(new TestClass(testInfo.getMethod().getDeclaringClass()), false).getParameterValuesForTest(testIndexHolder).stream().filter(TestParameterAnnotationMethodProcessor.matches(annotationType)).map(TestParameterValue::value).findFirst().orElse(null));
    }

    public static com.google.common.base.Optional<Object> getTestParameterValue(TestInfo testInfo, Class<? extends Annotation> annotationType) {
        return TestParameterAnnotationMethodProcessor.getTestParameterValues(testInfo).getValue(annotationType);
    }

    private static List<Object> getParametersAnnotationValues(AnnotationWithMetadata annotationWithMetadata) {
        Annotation annotation = annotationWithMetadata.annotation();
        TestParameterAnnotation testParameter = annotation.annotationType().getAnnotation(TestParameterAnnotation.class);
        Class<? extends TestParameterValueProvider> valueProvider = testParameter.valueProvider();
        try {
            return valueProvider.getConstructor(new Class[0]).newInstance(new Object[0]).provideValues(annotation, Optional.ofNullable((Class)annotationWithMetadata.paramClass().orNull()));
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception while invoking value provider " + valueProvider, e);
        }
    }

    private static Predicate<TestParameterValue> matches(Class<? extends Annotation> annotationType) {
        return testParameterValue -> testParameterValue.annotationTypeOrigin().annotationType().equals(annotationType);
    }

    private TestParameterAnnotationMethodProcessor(TestClass testClass, boolean onlyForFieldsAndParameters) {
        this.testClass = testClass;
        this.onlyForFieldsAndParameters = onlyForFieldsAndParameters;
    }

    static TestMethodProcessor forAllAnnotationPlacements(TestClass testClass) {
        return new TestParameterAnnotationMethodProcessor(testClass, false);
    }

    static TestMethodProcessor onlyForFieldsAndParameters(TestClass testClass) {
        return new TestParameterAnnotationMethodProcessor(testClass, true);
    }

    private ImmutableList<AnnotationTypeOrigin> getAnnotationTypeOrigins(Origin firstOrigin, Origin ... otherOrigins) {
        if (this.cachedAnnotationTypeOrigins == null) {
            List<AnnotationTypeOrigin> fieldAnnotations = this.extractTestParameterAnnotations(TestParameterAnnotationMethodProcessor.streamWithParents(this.testClass.getJavaClass()).flatMap(c -> Arrays.stream(c.getDeclaredFields())).flatMap(field -> Arrays.stream(field.getAnnotations())), Origin.FIELD);
            List<AnnotationTypeOrigin> methodAnnotations = this.extractTestParameterAnnotations(Arrays.stream(this.testClass.getJavaClass().getMethods()).flatMap(method -> Arrays.stream(method.getAnnotations())), Origin.METHOD);
            List<AnnotationTypeOrigin> parameterAnnotations = this.extractTestParameterAnnotations(Arrays.stream(this.testClass.getJavaClass().getMethods()).flatMap(method -> Arrays.stream(method.getParameterAnnotations()).flatMap(Stream::of)), Origin.METHOD_PARAMETER);
            List<AnnotationTypeOrigin> classAnnotations = this.extractTestParameterAnnotations(Arrays.stream(this.testClass.getJavaClass().getAnnotations()), Origin.CLASS);
            List<AnnotationTypeOrigin> constructorAnnotations = this.extractTestParameterAnnotations(Arrays.stream(this.testClass.getJavaClass().getConstructors()).flatMap(constructor -> Arrays.stream(constructor.getAnnotations())), Origin.CONSTRUCTOR);
            List<AnnotationTypeOrigin> constructorParameterAnnotations = this.extractTestParameterAnnotations(Arrays.stream(this.testClass.getJavaClass().getConstructors()).flatMap(constructor -> Arrays.stream(constructor.getParameterAnnotations()).flatMap(Stream::of)), Origin.CONSTRUCTOR_PARAMETER);
            this.checkDuplicatedClassAndFieldAnnotations(constructorAnnotations, classAnnotations, fieldAnnotations);
            this.checkDuplicatedFieldsAnnotations(methodAnnotations, fieldAnnotations);
            Preconditions.checkState((constructorAnnotations.stream().distinct().count() == (long)constructorAnnotations.size() ? 1 : 0) != 0, (Object)"Annotations should not be duplicated on the constructor.");
            Preconditions.checkState((classAnnotations.stream().distinct().count() == (long)classAnnotations.size() ? 1 : 0) != 0, (Object)"Annotations should not be duplicated on the class.");
            if (this.onlyForFieldsAndParameters) {
                Preconditions.checkState((boolean)methodAnnotations.isEmpty(), (String)"This test runner (constructed by the testparameterinjector package) was configured to disallow method-level annotations that could be field/parameter annotations, but found %s", methodAnnotations);
                Preconditions.checkState((boolean)classAnnotations.isEmpty(), (String)"This test runner (constructed by the testparameterinjector package) was configured to disallow class-level annotations that could be field/parameter annotations, but found %s", classAnnotations);
                Preconditions.checkState((boolean)constructorAnnotations.isEmpty(), (String)"This test runner (constructed by the testparameterinjector package) was configured to disallow constructor-level annotations that could be field/parameter annotations, but found %s", constructorAnnotations);
            }
            this.cachedAnnotationTypeOrigins = Stream.of(classAnnotations.stream(), fieldAnnotations.stream(), constructorAnnotations.stream(), constructorParameterAnnotations.stream(), methodAnnotations.stream(), parameterAnnotations.stream()).flatMap(x -> x).distinct().collect(TestParameterAnnotationMethodProcessor.toImmutableList());
        }
        ImmutableSet originsToFilterBy = ImmutableSet.builder().add((Object)firstOrigin).add((Object[])otherOrigins).build();
        return this.cachedAnnotationTypeOrigins.stream().filter(arg_0 -> TestParameterAnnotationMethodProcessor.lambda$getAnnotationTypeOrigins$10((Set)originsToFilterBy, arg_0)).collect(TestParameterAnnotationMethodProcessor.toImmutableList());
    }

    private void checkDuplicatedFieldsAnnotations(List<AnnotationTypeOrigin> methodAnnotations, List<AnnotationTypeOrigin> fieldAnnotations) {
        if (fieldAnnotations.stream().distinct().count() != (long)fieldAnnotations.size()) {
            List methodOrFieldAnnotations = Stream.concat(methodAnnotations.stream(), fieldAnnotations.stream().distinct()).map(AnnotationTypeOrigin::annotationType).collect(Collectors.toCollection(ArrayList::new));
            Preconditions.checkState((methodOrFieldAnnotations.stream().distinct().count() == (long)methodOrFieldAnnotations.size() ? 1 : 0) != 0, (Object)"Annotations should not be duplicated on a method and field if they are present on multiple fields");
        }
    }

    private void checkDuplicatedClassAndFieldAnnotations(List<AnnotationTypeOrigin> constructorAnnotations, List<AnnotationTypeOrigin> classAnnotations, List<AnnotationTypeOrigin> fieldAnnotations) {
        ImmutableSet classAnnotationTypes = classAnnotations.stream().map(AnnotationTypeOrigin::annotationType).collect(TestParameterAnnotationMethodProcessor.toImmutableSet());
        ImmutableSet uniqueFieldAnnotations = fieldAnnotations.stream().map(AnnotationTypeOrigin::annotationType).collect(TestParameterAnnotationMethodProcessor.toImmutableSet());
        ImmutableSet uniqueConstructorAnnotations = constructorAnnotations.stream().map(AnnotationTypeOrigin::annotationType).collect(TestParameterAnnotationMethodProcessor.toImmutableSet());
        Preconditions.checkState((boolean)Collections.disjoint(classAnnotationTypes, uniqueFieldAnnotations), (Object)"Annotations should not be duplicated on a class and field");
        Preconditions.checkState((boolean)Collections.disjoint(classAnnotationTypes, uniqueConstructorAnnotations), (Object)"Annotations should not be duplicated on a class and constructor");
        Preconditions.checkState((boolean)Collections.disjoint(uniqueConstructorAnnotations, uniqueFieldAnnotations), (Object)"Annotations should not be duplicated on a field and constructor");
    }

    private List<AnnotationTypeOrigin> extractTestParameterAnnotations(Stream<Annotation> annotations, Origin origin) {
        return annotations.map(Annotation::annotationType).filter(annotationType -> annotationType.isAnnotationPresent(TestParameterAnnotation.class)).map(annotationType -> AnnotationTypeOrigin.create(annotationType, origin)).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public TestMethodProcessor.ValidationResult validateConstructor(TestClass testClass, List<Throwable> errorsReturned) {
        if (testClass.getJavaClass().getConstructors().length != 1) {
            errorsReturned.add(new IllegalStateException("Test class should have exactly one public constructor"));
            return TestMethodProcessor.ValidationResult.HANDLED;
        }
        Constructor constructor = testClass.getOnlyConstructor();
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        if (parameterTypes.length == 0) {
            return TestMethodProcessor.ValidationResult.NOT_HANDLED;
        }
        Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
        this.validateMethodOrConstructorParameters(this.removeOverrides((List<AnnotationTypeOrigin>)this.getAnnotationTypeOrigins(Origin.CLASS, Origin.CONSTRUCTOR, Origin.CONSTRUCTOR_PARAMETER), testClass.getJavaClass()), testClass, errorsReturned, constructor, parameterTypes, parameterAnnotations);
        return TestMethodProcessor.ValidationResult.HANDLED;
    }

    @Override
    public TestMethodProcessor.ValidationResult validateTestMethod(TestClass testClass, FrameworkMethod testMethod, List<Throwable> errorsReturned) {
        Class<?>[] methodParameterTypes = testMethod.getMethod().getParameterTypes();
        if (methodParameterTypes.length == 0) {
            return TestMethodProcessor.ValidationResult.NOT_HANDLED;
        }
        Method method = testMethod.getMethod();
        testMethod.validatePublicVoid(false, errorsReturned);
        Annotation[][] parametersAnnotations = method.getParameterAnnotations();
        this.validateMethodOrConstructorParameters((List<AnnotationTypeOrigin>)this.getAnnotationTypeOrigins(Origin.CLASS, Origin.METHOD, Origin.METHOD_PARAMETER), testClass, errorsReturned, method, methodParameterTypes, parametersAnnotations);
        return TestMethodProcessor.ValidationResult.HANDLED;
    }

    private void validateMethodOrConstructorParameters(List<AnnotationTypeOrigin> annotationTypeOrigins, TestClass testClass, List<Throwable> errors, AnnotatedElement methodOrConstructor, Class<?>[] parameterTypes, Annotation[][] parametersAnnotations) {
        for (int parameterIndex = 0; parameterIndex < parameterTypes.length; ++parameterIndex) {
            Class<?> parameterType = parameterTypes[parameterIndex];
            Annotation[] parameterAnnotations = parametersAnnotations[parameterIndex];
            boolean matchingTestParameterAnnotationFound = false;
            for (AnnotationTypeOrigin testParameterAnnotationType : annotationTypeOrigins) {
                for (Annotation parameterAnnotation : parameterAnnotations) {
                    if (!parameterAnnotation.annotationType().equals(testParameterAnnotationType.annotationType())) continue;
                    Class<?> valueMethodReturnType = TestParameterAnnotationMethodProcessor.getValueMethodReturnType(testParameterAnnotationType.annotationType(), com.google.common.base.Optional.of(parameterType));
                    if (!parameterType.isAssignableFrom(valueMethodReturnType)) {
                        errors.add(new IllegalStateException(String.format("Parameter of type %s annotated with %s does not match expected type %s in method/constructor %s", parameterType.getName(), testParameterAnnotationType.annotationType().getName(), valueMethodReturnType.getName(), methodOrConstructor)));
                        continue;
                    }
                    matchingTestParameterAnnotationFound = true;
                }
            }
            if (!matchingTestParameterAnnotationFound) {
                ImmutableList<Class<? extends Annotation>> testParameterAnnotationTypes = this.getTestParameterAnnotations((List<AnnotationTypeOrigin>)TestParameterAnnotationMethodProcessor.filterAnnotationTypeOriginsByOrigin(annotationTypeOrigins, Origin.CLASS, Origin.CONSTRUCTOR, Origin.METHOD), testClass.getJavaClass(), methodOrConstructor);
                for (Class testParameterAnnotationType : testParameterAnnotationTypes) {
                    if (!parameterType.isAssignableFrom(TestParameterAnnotationMethodProcessor.getValueMethodReturnType(testParameterAnnotationType, com.google.common.base.Optional.absent()))) continue;
                    if (matchingTestParameterAnnotationFound) {
                        errors.add(new IllegalStateException(String.format("Ambiguous method/constructor parameter type, matching multiple annotations for parameter of type %s in method %s", parameterType.getName(), methodOrConstructor)));
                    }
                    matchingTestParameterAnnotationFound = true;
                }
            }
            if (matchingTestParameterAnnotationFound) continue;
            errors.add(new IllegalStateException(String.format("No matching test parameter annotation found for parameter of type %s in method/constructor %s", parameterType.getName(), methodOrConstructor)));
        }
    }

    @Override
    public com.google.common.base.Optional<Statement> createStatement(TestClass testClass, FrameworkMethod frameworkMethod, Object testObject, com.google.common.base.Optional<Statement> statement) {
        if (frameworkMethod.getAnnotation(TestIndexHolder.class) == null || frameworkMethod.getAnnotation(TestParameters.class) != null) {
            return statement;
        }
        return com.google.common.base.Optional.of((Object)((Object)new InvokeParameterizedMethod(frameworkMethod, testObject)));
    }

    @Override
    public List<TestInfo> processTest(Class<?> testClass, TestInfo originalTest) {
        List<List<TestParameterValue>> parameterValuesForMethod = this.getParameterValuesForMethod(originalTest.getMethod());
        if (parameterValuesForMethod.equals(ImmutableList.of((Object)ImmutableList.of()))) {
            return ImmutableList.of((Object)originalTest);
        }
        ImmutableList.Builder testInfos = ImmutableList.builder();
        for (int parametersIndex = 0; parametersIndex < parameterValuesForMethod.size(); ++parametersIndex) {
            List<TestParameterValue> testParameterValues = parameterValuesForMethod.get(parametersIndex);
            String testNameSuffix = TestParameterAnnotationMethodProcessor.getTestNameSuffix(testParameterValues);
            testInfos.add((Object)TestInfo.create(originalTest.getMethod(), TestParameterAnnotationMethodProcessor.appendParametersToTestName(originalTest.getName(), testNameSuffix), (List<Annotation>)ImmutableList.builder().addAll(originalTest.getAnnotations()).add((Object)TestIndexHolderFactory.create(ImmutableList.copyOf((Object[])testClass.getMethods()).indexOf((Object)originalTest.getMethod()), parametersIndex, testClass.getName())).build()));
        }
        return TestInfo.shortenNamesIfNecessary((List<TestInfo>)testInfos.build(), testInfo -> TestParameterAnnotationMethodProcessor.appendParametersToTestName(originalTest.getName(), String.valueOf(testInfo.getAnnotation(TestIndexHolder.class).parametersIndex() + 1)));
    }

    private static String getTestNameSuffix(List<TestParameterValue> testParameterValues) {
        return testParameterValues.stream().map(value -> {
            Class<? extends Annotation> annotationType = value.annotationTypeOrigin().annotationType();
            String namePattern = annotationType.getAnnotation(TestParameterAnnotation.class).name();
            if (value.paramName().isPresent() && value.paramClass().isPresent() && namePattern.equals("{0}") && Primitives.unwrap((Class)((Class)value.paramClass().get())).isPrimitive()) {
                return String.format("%s=%s", value.paramName().get(), value.value());
            }
            return MessageFormat.format(namePattern, value.value());
        }).map(string -> string.trim().replaceAll("\\s+", " ")).collect(Collectors.joining(","));
    }

    private static String appendParametersToTestName(String originalTestName, String testNameSuffix) {
        if (originalTestName.endsWith("]")) {
            return String.format("%s,%s]", originalTestName.substring(0, originalTestName.length() - 1), testNameSuffix);
        }
        return String.format("%s[%s]", originalTestName, testNameSuffix);
    }

    private List<List<TestParameterValue>> getParameterValuesForMethod(Method method) {
        try {
            return (List)this.parameterValuesCache.get((Object)method, () -> {
                ImmutableList<List<TestParameterValue>> testParameterValuesList = this.getAnnotationValuesForUsedAnnotationTypes(this.testClass.getJavaClass(), method);
                return (List)Lists.cartesianProduct(testParameterValuesList).stream().filter(testParameterValues -> testParameterValues.stream().noneMatch(testParameterValue -> TestParameterAnnotationMethodProcessor.callShouldSkip(testParameterValue.annotationTypeOrigin().annotationType(), testParameterValues))).collect(TestParameterAnnotationMethodProcessor.toImmutableList());
            });
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e);
        }
    }

    private List<TestParameterValue> getParameterValuesForTest(TestIndexHolder testIndexHolder) {
        Verify.verify((boolean)testIndexHolder.testClassName().equals(this.testClass.getName()), (String)"The class for which the given annotation was created (%s) is not the same as the test class that this runner is handling (%s)", (Object)testIndexHolder.testClassName(), (Object)this.testClass.getName());
        Method testMethod = this.testClass.getJavaClass().getMethods()[testIndexHolder.methodIndex()];
        return this.getParameterValuesForMethod(testMethod).get(testIndexHolder.parametersIndex());
    }

    private ImmutableList<List<TestParameterValue>> getAnnotationValuesForUsedAnnotationTypes(Class<?> testClass, Method method) {
        ImmutableList annotationTypes = Stream.of(this.getAnnotationTypeOrigins(Origin.CLASS, new Origin[0]).stream(), this.getAnnotationTypeOrigins(Origin.FIELD, new Origin[0]).stream(), this.getAnnotationTypeOrigins(Origin.CONSTRUCTOR, new Origin[0]).stream(), this.getAnnotationTypeOrigins(Origin.CONSTRUCTOR_PARAMETER, new Origin[0]).stream(), this.getAnnotationTypeOrigins(Origin.METHOD, new Origin[0]).stream(), this.getAnnotationTypeOrigins(Origin.METHOD_PARAMETER, new Origin[0]).stream().sorted(this.annotationComparator(method.getParameterAnnotations()))).flatMap(x -> x).collect(TestParameterAnnotationMethodProcessor.toImmutableList());
        return this.removeOverrides((List<AnnotationTypeOrigin>)annotationTypes, testClass, method).stream().map(annotationTypeOrigin -> this.getAnnotationFromParametersOrTestOrClass((AnnotationTypeOrigin)annotationTypeOrigin, method, testClass)).filter(l -> !l.isEmpty()).flatMap(Collection::stream).collect(TestParameterAnnotationMethodProcessor.toImmutableList());
    }

    private Comparator<AnnotationTypeOrigin> annotationComparator(Annotation[][] parameterAnnotations) {
        ImmutableList annotationOrdering = Arrays.stream(parameterAnnotations).flatMap(Arrays::stream).map(Annotation::annotationType).map(Class::getName).collect(TestParameterAnnotationMethodProcessor.toImmutableList());
        return Comparator.comparingInt(o -> annotationOrdering.indexOf((Object)o.annotationType().getName()));
    }

    private List<AnnotationTypeOrigin> removeOverrides(List<AnnotationTypeOrigin> annotationTypeOrigins, Class<?> testClass, Method method) {
        return this.removeOverrides(annotationTypeOrigins.stream().filter(annotationTypeOrigin -> {
            switch (annotationTypeOrigin.origin()) {
                case FIELD: 
                case CLASS: {
                    return this.getAnnotationListWithType(method.getAnnotations(), annotationTypeOrigin.annotationType()).isEmpty();
                }
            }
            return true;
        }).collect(Collectors.toCollection(ArrayList::new)), testClass);
    }

    private List<AnnotationTypeOrigin> removeOverrides(List<AnnotationTypeOrigin> annotationTypeOrigins, Class<?> testClass) {
        return annotationTypeOrigins.stream().filter(annotationTypeOrigin -> {
            switch (annotationTypeOrigin.origin()) {
                case FIELD: 
                case CLASS: {
                    return this.getAnnotationListWithType(TestParameterAnnotationMethodProcessor.getOnlyConstructor(testClass).getAnnotations(), annotationTypeOrigin.annotationType()).isEmpty() && this.getAnnotationListWithType(TestParameterAnnotationMethodProcessor.getOnlyConstructor(testClass).getParameterAnnotations(), annotationTypeOrigin.annotationType()).isEmpty();
                }
            }
            return true;
        }).collect(Collectors.toCollection(ArrayList::new));
    }

    private ImmutableList<List<TestParameterValue>> getAnnotationFromParametersOrTestOrClass(AnnotationTypeOrigin annotationTypeOrigin, Method method, Class<?> testClass) {
        Annotation annotation;
        Origin origin = annotationTypeOrigin.origin();
        Class<? extends Annotation> annotationType = annotationTypeOrigin.annotationType();
        if (origin == Origin.CONSTRUCTOR_PARAMETER) {
            Constructor<?> constructor = TestParameterAnnotationMethodProcessor.getOnlyConstructor(testClass);
            ImmutableList<AnnotationWithMetadata> annotations = TestParameterAnnotationMethodProcessor.getAnnotationWithMetadataListWithType(constructor, annotationType);
            if (!annotations.isEmpty()) {
                return TestParameterAnnotationMethodProcessor.toTestParameterValueList(annotations, origin);
            }
        } else if (origin == Origin.CONSTRUCTOR) {
            Annotation annotation2 = TestParameterAnnotationMethodProcessor.getOnlyConstructor(testClass).getAnnotation(annotationType);
            if (annotation2 != null) {
                return ImmutableList.of(TestParameterValue.create(AnnotationWithMetadata.withoutMetadata(annotation2), origin));
            }
        } else if (origin == Origin.METHOD_PARAMETER) {
            ImmutableList<AnnotationWithMetadata> annotations = TestParameterAnnotationMethodProcessor.getAnnotationWithMetadataListWithType(method, annotationType);
            if (!annotations.isEmpty()) {
                return TestParameterAnnotationMethodProcessor.toTestParameterValueList(annotations, origin);
            }
        } else if (origin == Origin.METHOD) {
            if (method.isAnnotationPresent(annotationType)) {
                return ImmutableList.of(TestParameterValue.create(AnnotationWithMetadata.withoutMetadata(method.getAnnotation(annotationType)), origin));
            }
        } else if (origin == Origin.FIELD) {
            List annotations = TestParameterAnnotationMethodProcessor.streamWithParents(testClass).flatMap(c -> Arrays.stream(c.getDeclaredFields())).flatMap(field -> this.getAnnotationListWithType(field.getAnnotations(), annotationType).stream().map(annotation -> AnnotationWithMetadata.withMetadata(annotation, field.getType(), field.getName()))).collect(Collectors.toCollection(ArrayList::new));
            if (!annotations.isEmpty()) {
                return TestParameterAnnotationMethodProcessor.toTestParameterValueList(annotations, origin);
            }
        } else if (origin == Origin.CLASS && (annotation = testClass.getAnnotation(annotationType)) != null) {
            return ImmutableList.of(TestParameterValue.create(AnnotationWithMetadata.withoutMetadata(annotation), origin));
        }
        return ImmutableList.of();
    }

    private static ImmutableList<List<TestParameterValue>> toTestParameterValueList(List<AnnotationWithMetadata> annotationWithMetadatas, Origin origin) {
        return annotationWithMetadatas.stream().map(annotationWithMetadata -> TestParameterValue.create(annotationWithMetadata, origin)).collect(TestParameterAnnotationMethodProcessor.toImmutableList());
    }

    private static ImmutableList<AnnotationWithMetadata> getAnnotationWithMetadataListWithType(Method callable, Class<? extends Annotation> annotationType) {
        try {
            return TestParameterAnnotationMethodProcessor.getAnnotationWithMetadataListWithType(callable.getParameters(), annotationType);
        }
        catch (NoSuchMethodError ignored) {
            return TestParameterAnnotationMethodProcessor.getAnnotationWithMetadataListWithType(callable.getParameterTypes(), callable.getParameterAnnotations(), annotationType);
        }
    }

    private static ImmutableList<AnnotationWithMetadata> getAnnotationWithMetadataListWithType(Constructor<?> callable, Class<? extends Annotation> annotationType) {
        try {
            return TestParameterAnnotationMethodProcessor.getAnnotationWithMetadataListWithType(callable.getParameters(), annotationType);
        }
        catch (NoSuchMethodError ignored) {
            return TestParameterAnnotationMethodProcessor.getAnnotationWithMetadataListWithType(callable.getParameterTypes(), callable.getParameterAnnotations(), annotationType);
        }
    }

    private static ImmutableList<AnnotationWithMetadata> getAnnotationWithMetadataListWithType(Parameter[] parameters, Class<? extends Annotation> annotationType) {
        return Arrays.stream(parameters).map(parameter -> {
            Object annotation = parameter.getAnnotation(annotationType);
            return annotation == null ? null : (parameter.isNamePresent() ? AnnotationWithMetadata.withMetadata(annotation, parameter.getType(), parameter.getName()) : AnnotationWithMetadata.withMetadata(annotation, parameter.getType()));
        }).filter(Objects::nonNull).collect(TestParameterAnnotationMethodProcessor.toImmutableList());
    }

    private static ImmutableList<AnnotationWithMetadata> getAnnotationWithMetadataListWithType(Class<?>[] parameterTypes, Annotation[][] annotations, Class<? extends Annotation> annotationType) {
        Preconditions.checkArgument((parameterTypes.length == annotations.length ? 1 : 0) != 0);
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (int i = 0; i < annotations.length; ++i) {
            for (Annotation annotation : annotations[i]) {
                if (!annotation.annotationType().equals(annotationType)) continue;
                resultBuilder.add((Object)AnnotationWithMetadata.withMetadata(annotation, parameterTypes[i]));
            }
        }
        return resultBuilder.build();
    }

    private ImmutableList<Annotation> getAnnotationListWithType(Annotation[][] parameterAnnotations, Class<? extends Annotation> annotationType) {
        return Arrays.stream(parameterAnnotations).flatMap(Stream::of).filter(annotation -> annotation.annotationType().equals(annotationType)).collect(TestParameterAnnotationMethodProcessor.toImmutableList());
    }

    private ImmutableList<Annotation> getAnnotationListWithType(Annotation[] annotations, Class<? extends Annotation> annotationType) {
        return Arrays.stream(annotations).filter(annotation -> annotation.annotationType().equals(annotationType)).collect(TestParameterAnnotationMethodProcessor.toImmutableList());
    }

    private static Constructor<?> getOnlyConstructor(Class<?> testClass) {
        Constructor<?>[] constructors = testClass.getConstructors();
        Preconditions.checkState((constructors.length == 1 ? 1 : 0) != 0, (String)"a single public constructor is required for class %s", testClass);
        return constructors[0];
    }

    @Override
    public com.google.common.base.Optional<Object> createTest(TestClass testClass, FrameworkMethod method, com.google.common.base.Optional<Object> test) {
        TestIndexHolder testIndexHolder = (TestIndexHolder)method.getAnnotation(TestIndexHolder.class);
        if (testIndexHolder == null) {
            return test;
        }
        try {
            Object testObject;
            List<TestParameterValue> testParameterValues = this.getParameterValuesForTest(testIndexHolder);
            if (test.isPresent()) {
                testObject = test.get();
            } else {
                Constructor constructor = testClass.getOnlyConstructor();
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length == 0) {
                    testObject = constructor.newInstance(new Object[0]);
                } else {
                    Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
                    Object[] arguments = new Object[parameterTypes.length];
                    ArrayList<Class<? extends Annotation>> processedAnnotationTypes = new ArrayList<Class<? extends Annotation>>();
                    ImmutableList<TestParameterValue> parameterValuesForConstructor = TestParameterAnnotationMethodProcessor.filterByOrigin(testParameterValues, Origin.CLASS, Origin.CONSTRUCTOR, Origin.CONSTRUCTOR_PARAMETER);
                    for (int i = 0; i < arguments.length; ++i) {
                        arguments[i] = this.getParameterValue((List<TestParameterValue>)parameterValuesForConstructor, parameterTypes[i], parameterAnnotations[i], (List<Class<? extends Annotation>>)processedAnnotationTypes);
                    }
                    testObject = constructor.newInstance(arguments);
                }
            }
            ImmutableList<TestParameterValue> testParameterValuesForFieldInjection = TestParameterAnnotationMethodProcessor.filterByOrigin(testParameterValues, Origin.CLASS, Origin.FIELD, Origin.METHOD);
            ArrayList<TestParameterValue> remainingTestParameterValuesForFieldInjection = new ArrayList<TestParameterValue>((Collection<TestParameterValue>)testParameterValuesForFieldInjection);
            block3: for (Field declaredField : TestParameterAnnotationMethodProcessor.streamWithParents(testObject.getClass()).flatMap(c -> Arrays.stream(c.getDeclaredFields())).collect(TestParameterAnnotationMethodProcessor.toImmutableList())) {
                for (TestParameterValue testParameterValue : remainingTestParameterValuesForFieldInjection) {
                    if (!declaredField.isAnnotationPresent(testParameterValue.annotationTypeOrigin().annotationType())) continue;
                    declaredField.setAccessible(true);
                    declaredField.set(testObject, testParameterValue.value());
                    remainingTestParameterValuesForFieldInjection.remove(testParameterValue);
                    continue block3;
                }
            }
            return com.google.common.base.Optional.of((Object)testObject);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static ImmutableList<TestParameterValue> filterByOrigin(List<TestParameterValue> testParameterValues, Origin ... origins) {
        ImmutableSet originsToFilterBy = ImmutableSet.copyOf((Object[])origins);
        return testParameterValues.stream().filter(arg_0 -> TestParameterAnnotationMethodProcessor.lambda$filterByOrigin$33((Set)originsToFilterBy, arg_0)).collect(TestParameterAnnotationMethodProcessor.toImmutableList());
    }

    private static ImmutableList<AnnotationTypeOrigin> filterAnnotationTypeOriginsByOrigin(List<AnnotationTypeOrigin> annotationTypeOrigins, Origin ... origins) {
        List<Origin> originList = Arrays.asList(origins);
        return annotationTypeOrigins.stream().filter(annotationTypeOrigin -> originList.contains((Object)annotationTypeOrigin.origin())).collect(TestParameterAnnotationMethodProcessor.toImmutableList());
    }

    @Override
    public Statement processStatement(final Statement originalStatement, Description finalTestDescription) {
        TestIndexHolder testIndexHolder = (TestIndexHolder)finalTestDescription.getAnnotation(TestIndexHolder.class);
        if (testIndexHolder == null) {
            return originalStatement;
        }
        final List<TestParameterValue> testParameterValues = this.getParameterValuesForTest(testIndexHolder);
        return new Statement(){

            public void evaluate() throws Throwable {
                for (TestParameterValue testParameterValue : testParameterValues) {
                    TestParameterAnnotationMethodProcessor.callBefore(testParameterValue.annotationTypeOrigin().annotationType(), testParameterValue.value());
                }
                try {
                    originalStatement.evaluate();
                }
                finally {
                    for (TestParameterValue testParameterValue : Lists.reverse((List)testParameterValues)) {
                        TestParameterAnnotationMethodProcessor.callAfter(testParameterValue.annotationTypeOrigin().annotationType(), testParameterValue.value());
                    }
                }
            }
        };
    }

    private Object getParameterValue(List<TestParameterValue> testParameterValues, Class<?> methodParameterType, Annotation[] parameterAnnotations, List<Class<? extends Annotation>> processedAnnotationTypes) {
        ArrayList<Class<? extends Annotation>> iteratedAnnotationTypes = new ArrayList<Class<? extends Annotation>>();
        for (TestParameterValue testParameterValue : testParameterValues) {
            for (Annotation parameterAnnotation : parameterAnnotations) {
                Class<? extends Annotation> annotationType = testParameterValue.annotationTypeOrigin().annotationType();
                if (!parameterAnnotation.annotationType().equals(annotationType)) continue;
                if (Collections.frequency(processedAnnotationTypes, annotationType) == Collections.frequency(iteratedAnnotationTypes, annotationType)) {
                    processedAnnotationTypes.add(annotationType);
                    return testParameterValue.value();
                }
                iteratedAnnotationTypes.add(annotationType);
            }
        }
        for (TestParameterValue testParameterValue : testParameterValues) {
            if (!methodParameterType.isAssignableFrom(TestParameterAnnotationMethodProcessor.getValueMethodReturnType(testParameterValue.annotationTypeOrigin().annotationType(), com.google.common.base.Optional.absent()))) continue;
            return testParameterValue.value();
        }
        throw new IllegalStateException("The method parameter should have matched a TestParameterAnnotation");
    }

    private static void callBefore(Class<? extends Annotation> annotationType, Object annotationValue) {
        TestParameterAnnotation annotation = annotationType.getAnnotation(TestParameterAnnotation.class);
        Class<? extends TestParameterProcessor> processor = annotation.processor();
        try {
            processor.getConstructor(new Class[0]).newInstance(new Object[0]).before(annotationValue);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception while invoking processor " + processor, e);
        }
    }

    private static void callAfter(Class<? extends Annotation> annotationType, Object annotationValue) {
        TestParameterAnnotation annotation = annotationType.getAnnotation(TestParameterAnnotation.class);
        Class<? extends TestParameterProcessor> processor = annotation.processor();
        try {
            processor.getConstructor(new Class[0]).newInstance(new Object[0]).after(annotationValue);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception while invoking processor " + processor, e);
        }
    }

    private static boolean callShouldSkip(Class<? extends Annotation> annotationType, List<TestParameterValue> testParameterValues) {
        TestParameterAnnotation annotation = annotationType.getAnnotation(TestParameterAnnotation.class);
        Class<? extends TestParameterValidator> validator = annotation.validator();
        try {
            return validator.getConstructor(new Class[0]).newInstance(new Object[0]).shouldSkip(new ValidatorContext(testParameterValues));
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception while invoking validator " + validator, e);
        }
    }

    private static Class<?> getValueMethodReturnType(Class<? extends Annotation> annotationType, com.google.common.base.Optional<Class<?>> paramClass) {
        TestParameterAnnotation testParameter = annotationType.getAnnotation(TestParameterAnnotation.class);
        Class<? extends TestParameterValueProvider> valueProvider = testParameter.valueProvider();
        try {
            return valueProvider.getConstructor(new Class[0]).newInstance(new Object[0]).getValueType(annotationType, Optional.ofNullable((Class)paramClass.orNull()));
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception while invoking value provider " + valueProvider, e);
        }
    }

    private ImmutableList<Class<? extends Annotation>> getTestParameterAnnotations(List<AnnotationTypeOrigin> annotationTypeOrigins, Class<?> testClass, AnnotatedElement methodOrConstructor) {
        return annotationTypeOrigins.stream().map(AnnotationTypeOrigin::annotationType).filter(annotationType -> testClass.isAnnotationPresent((Class<Annotation>)annotationType) || methodOrConstructor.isAnnotationPresent((Class<? extends Annotation>)annotationType)).collect(TestParameterAnnotationMethodProcessor.toImmutableList());
    }

    private static Stream<Class<?>> streamWithParents(Class<?> clazz) {
        Stream.Builder<Class<?>> resultBuilder = Stream.builder();
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            resultBuilder.add(currentClass);
        }
        return resultBuilder.build();
    }

    private static <E> Collector<E, ?, ImmutableList<E>> toImmutableList() {
        return Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf);
    }

    private static <E> Collector<E, ?, ImmutableSet<E>> toImmutableSet() {
        return Collectors.collectingAndThen(Collectors.toList(), ImmutableSet::copyOf);
    }

    private static /* synthetic */ boolean lambda$filterByOrigin$33(Set originsToFilterBy, TestParameterValue testParameterValue) {
        return originsToFilterBy.contains((Object)testParameterValue.annotationTypeOrigin().origin());
    }

    private static /* synthetic */ boolean lambda$getAnnotationTypeOrigins$10(Set originsToFilterBy, AnnotationTypeOrigin annotationTypeOrigin) {
        return originsToFilterBy.contains((Object)annotationTypeOrigin.origin());
    }

    static enum Origin {
        CLASS,
        FIELD,
        METHOD,
        METHOD_PARAMETER,
        CONSTRUCTOR,
        CONSTRUCTOR_PARAMETER;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface TestIndexHolder {
        public int methodIndex();

        public int parametersIndex();

        public String testClassName();
    }

    @AutoValue
    static abstract class AnnotationWithMetadata
    implements Serializable {
        AnnotationWithMetadata() {
        }

        abstract Annotation annotation();

        abstract com.google.common.base.Optional<Class<?>> paramClass();

        abstract com.google.common.base.Optional<String> paramName();

        public static AnnotationWithMetadata withMetadata(Annotation annotation, Class<?> paramClass, String paramName) {
            return new AutoValue_TestParameterAnnotationMethodProcessor_AnnotationWithMetadata(annotation, com.google.common.base.Optional.of(paramClass), (com.google.common.base.Optional<String>)com.google.common.base.Optional.of((Object)paramName));
        }

        public static AnnotationWithMetadata withMetadata(Annotation annotation, Class<?> paramClass) {
            return new AutoValue_TestParameterAnnotationMethodProcessor_AnnotationWithMetadata(annotation, com.google.common.base.Optional.of(paramClass), (com.google.common.base.Optional<String>)com.google.common.base.Optional.absent());
        }

        public static AnnotationWithMetadata withoutMetadata(Annotation annotation) {
            return new AutoValue_TestParameterAnnotationMethodProcessor_AnnotationWithMetadata(annotation, com.google.common.base.Optional.absent(), (com.google.common.base.Optional<String>)com.google.common.base.Optional.absent());
        }
    }

    @AutoValue
    static abstract class AnnotationTypeOrigin
    implements Serializable {
        private static final long serialVersionUID = 4909750539931241385L;

        AnnotationTypeOrigin() {
        }

        abstract Class<? extends Annotation> annotationType();

        abstract Origin origin();

        public static AnnotationTypeOrigin create(Class<? extends Annotation> annotationType, Origin origin) {
            return new AutoValue_TestParameterAnnotationMethodProcessor_AnnotationTypeOrigin(annotationType, origin);
        }

        public final String toString() {
            return this.annotationType().getSimpleName() + ":" + (Object)((Object)this.origin());
        }
    }

    private class InvokeParameterizedMethod
    extends Statement {
        private final FrameworkMethod frameworkMethod;
        private final Object testObject;
        private final List<TestParameterValue> testParameterValues;

        public InvokeParameterizedMethod(FrameworkMethod frameworkMethod, Object testObject) {
            this.frameworkMethod = frameworkMethod;
            this.testObject = testObject;
            TestIndexHolder testIndexHolder = (TestIndexHolder)frameworkMethod.getAnnotation(TestIndexHolder.class);
            Preconditions.checkState((testIndexHolder != null ? 1 : 0) != 0);
            this.testParameterValues = TestParameterAnnotationMethodProcessor.filterByOrigin(TestParameterAnnotationMethodProcessor.this.getParameterValuesForTest(testIndexHolder), new Origin[]{Origin.CLASS, Origin.METHOD, Origin.METHOD_PARAMETER});
        }

        public void evaluate() throws Throwable {
            Class<?>[] parameterTypes = this.frameworkMethod.getMethod().getParameterTypes();
            Annotation[][] parametersAnnotations = this.frameworkMethod.getMethod().getParameterAnnotations();
            Object[] parameterValues = new Object[parameterTypes.length];
            ArrayList processedAnnotationTypes = new ArrayList();
            for (int i = 0; i < parameterTypes.length; ++i) {
                parameterValues[i] = TestParameterAnnotationMethodProcessor.this.getParameterValue(this.testParameterValues, parameterTypes[i], parametersAnnotations[i], processedAnnotationTypes);
            }
            this.frameworkMethod.invokeExplosively(this.testObject, parameterValues);
        }
    }

    static class TestIndexHolderFactory {
        static TestIndexHolder create(int methodIndex, int parametersIndex, String testClassName) {
            return new AutoAnnotation_TestParameterAnnotationMethodProcessor_TestIndexHolderFactory_create(methodIndex, parametersIndex, testClassName);
        }

        private TestIndexHolderFactory() {
        }
    }

    @AutoValue
    static abstract class TestParameterValue
    implements Serializable {
        private static final long serialVersionUID = -6491624726743872379L;

        TestParameterValue() {
        }

        abstract AnnotationTypeOrigin annotationTypeOrigin();

        @Nullable
        abstract Object value();

        abstract List<Object> specifiedValues();

        abstract com.google.common.base.Optional<Class<?>> paramClass();

        abstract com.google.common.base.Optional<String> paramName();

        public static ImmutableList<TestParameterValue> create(AnnotationWithMetadata annotationWithMetadata, Origin origin) {
            List specifiedValues = TestParameterAnnotationMethodProcessor.getParametersAnnotationValues(annotationWithMetadata);
            Preconditions.checkState((!specifiedValues.isEmpty() ? 1 : 0) != 0, (Object)"The number of parameter values should not be 0, otherwise the parameter would cause the test to be skipped.");
            return (ImmutableList)specifiedValues.stream().map(value -> new AutoValue_TestParameterAnnotationMethodProcessor_TestParameterValue(AnnotationTypeOrigin.create(annotationWithMetadata.annotation().annotationType(), origin), value, new ArrayList<Object>(specifiedValues), annotationWithMetadata.paramClass(), annotationWithMetadata.paramName())).collect(TestParameterAnnotationMethodProcessor.toImmutableList());
        }
    }

    private static class ValidatorContext
    implements TestParameterValidator.Context {
        private final List<TestParameterValue> testParameterValues;
        private final Set<Object> valueList;

        public ValidatorContext(List<TestParameterValue> testParameterValues) {
            this.testParameterValues = testParameterValues;
            this.valueList = testParameterValues.stream().map(TestParameterValue::value).collect(Collectors.toSet());
        }

        @Override
        public boolean has(Class<? extends Annotation> testParameter, Object value) {
            return (Boolean)this.getValue(testParameter).transform(value::equals).or((Object)false);
        }

        @Override
        public <T extends Enum<T>, U extends Enum<U>> boolean has(T value1, U value2) {
            return this.valueList.contains(value1) && this.valueList.contains(value2);
        }

        @Override
        public com.google.common.base.Optional<Object> getValue(Class<? extends Annotation> testParameter) {
            return this.getParameter(testParameter).transform(TestParameterValue::value);
        }

        @Override
        public List<Object> getSpecifiedValues(Class<? extends Annotation> testParameter) {
            return (List)this.getParameter(testParameter).transform(TestParameterValue::specifiedValues).or((Object)ImmutableList.of());
        }

        private com.google.common.base.Optional<TestParameterValue> getParameter(Class<? extends Annotation> testParameter) {
            return com.google.common.base.Optional.fromNullable((Object)this.testParameterValues.stream().filter(value -> value.annotationTypeOrigin().annotationType().equals(testParameter)).findAny().orElse(null));
        }
    }
}

