/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.auto.value.AutoValue;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Correspondence;
import com.google.common.truth.extensions.proto.AutoValue_FluentEqualityConfig;
import com.google.common.truth.extensions.proto.FieldDescriptorOrUnknown;
import com.google.common.truth.extensions.proto.FieldDescriptorValidator;
import com.google.common.truth.extensions.proto.FieldScope;
import com.google.common.truth.extensions.proto.FieldScopeLogic;
import com.google.common.truth.extensions.proto.FieldScopeLogicContainer;
import com.google.common.truth.extensions.proto.FieldScopeLogicMap;
import com.google.common.truth.extensions.proto.FieldScopeUtil;
import com.google.common.truth.extensions.proto.FieldScopes;
import com.google.common.truth.extensions.proto.ProtoTruth;
import com.google.common.truth.extensions.proto.ProtoTruthMessageDifferencer;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@AutoValue
abstract class FluentEqualityConfig
implements FieldScopeLogicContainer<FluentEqualityConfig> {
    private static final FluentEqualityConfig DEFAULT_INSTANCE = new AutoValue_FluentEqualityConfig.Builder().setIgnoreFieldAbsenceScope(FieldScopeLogic.none()).setIgnoreRepeatedFieldOrderScope(FieldScopeLogic.none()).setIgnoreExtraRepeatedFieldElementsScope(FieldScopeLogic.none()).setDoubleCorrespondenceMap(FieldScopeLogicMap.empty()).setFloatCorrespondenceMap(FieldScopeLogicMap.empty()).setCompareExpectedFieldsOnly(false).setCompareFieldsScope(FieldScopeLogic.all()).setReportMismatchesOnly(false).setUsingCorrespondenceStringFunction((Function<? super Optional<Descriptors.Descriptor>, String>)Functions.constant((Object)"")).build();
    private final LoadingCache<Descriptors.Descriptor, ProtoTruthMessageDifferencer> messageDifferencers = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Descriptors.Descriptor, ProtoTruthMessageDifferencer>(){

        public ProtoTruthMessageDifferencer load(Descriptors.Descriptor descriptor) {
            return ProtoTruthMessageDifferencer.create(FluentEqualityConfig.this, descriptor);
        }
    });

    FluentEqualityConfig() {
    }

    static FluentEqualityConfig defaultInstance() {
        return DEFAULT_INSTANCE;
    }

    abstract FieldScopeLogic ignoreFieldAbsenceScope();

    abstract FieldScopeLogic ignoreRepeatedFieldOrderScope();

    abstract FieldScopeLogic ignoreExtraRepeatedFieldElementsScope();

    abstract FieldScopeLogicMap<Correspondence<Number, Number>> doubleCorrespondenceMap();

    abstract FieldScopeLogicMap<Correspondence<Number, Number>> floatCorrespondenceMap();

    abstract boolean compareExpectedFieldsOnly();

    abstract Optional<ImmutableList<Message>> expectedMessages();

    abstract FieldScopeLogic compareFieldsScope();

    abstract boolean reportMismatchesOnly();

    abstract Function<? super Optional<Descriptors.Descriptor>, String> usingCorrespondenceStringFunction();

    final String usingCorrespondenceString(Optional<Descriptors.Descriptor> descriptor) {
        return (String)this.usingCorrespondenceStringFunction().apply(descriptor);
    }

    final FluentEqualityConfig ignoringFieldAbsence() {
        return this.toBuilder().setIgnoreFieldAbsenceScope(FieldScopeLogic.all()).addUsingCorrespondenceString(".ignoringFieldAbsence()").build();
    }

    final FluentEqualityConfig ignoringFieldAbsenceOfFields(Iterable<Integer> fieldNumbers) {
        return this.toBuilder().setIgnoreFieldAbsenceScope(this.ignoreFieldAbsenceScope().allowingFieldsNonRecursive(fieldNumbers)).addUsingCorrespondenceFieldNumbersString(".ignoringFieldAbsenceOf(%s)", fieldNumbers).build();
    }

    final FluentEqualityConfig ignoringFieldAbsenceOfFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.toBuilder().setIgnoreFieldAbsenceScope(this.ignoreFieldAbsenceScope().allowingFieldDescriptorsNonRecursive(fieldDescriptors)).addUsingCorrespondenceFieldDescriptorsString(".ignoringFieldAbsenceOf(%s)", fieldDescriptors).build();
    }

    final FluentEqualityConfig ignoringRepeatedFieldOrder() {
        return this.toBuilder().setIgnoreRepeatedFieldOrderScope(FieldScopeLogic.all()).addUsingCorrespondenceString(".ignoringRepeatedFieldOrder()").build();
    }

    final FluentEqualityConfig ignoringRepeatedFieldOrderOfFields(Iterable<Integer> fieldNumbers) {
        return this.toBuilder().setIgnoreRepeatedFieldOrderScope(this.ignoreRepeatedFieldOrderScope().allowingFieldsNonRecursive(fieldNumbers)).addUsingCorrespondenceFieldNumbersString(".ignoringRepeatedFieldOrderOf(%s)", fieldNumbers).build();
    }

    final FluentEqualityConfig ignoringRepeatedFieldOrderOfFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.toBuilder().setIgnoreRepeatedFieldOrderScope(this.ignoreRepeatedFieldOrderScope().allowingFieldDescriptorsNonRecursive(fieldDescriptors)).addUsingCorrespondenceFieldDescriptorsString(".ignoringRepeatedFieldOrderOf(%s)", fieldDescriptors).build();
    }

    final FluentEqualityConfig ignoringExtraRepeatedFieldElements() {
        return this.toBuilder().setIgnoreExtraRepeatedFieldElementsScope(FieldScopeLogic.all()).addUsingCorrespondenceString(".ignoringExtraRepeatedFieldElements()").build();
    }

    final FluentEqualityConfig ignoringExtraRepeatedFieldElementsOfFields(Iterable<Integer> fieldNumbers) {
        return this.toBuilder().setIgnoreExtraRepeatedFieldElementsScope(this.ignoreExtraRepeatedFieldElementsScope().allowingFieldsNonRecursive(fieldNumbers)).addUsingCorrespondenceFieldNumbersString(".ignoringExtraRepeatedFieldElements(%s)", fieldNumbers).build();
    }

    final FluentEqualityConfig ignoringExtraRepeatedFieldElementsOfFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.toBuilder().setIgnoreExtraRepeatedFieldElementsScope(this.ignoreExtraRepeatedFieldElementsScope().allowingFieldDescriptorsNonRecursive(fieldDescriptors)).addUsingCorrespondenceFieldDescriptorsString(".ignoringExtraRepeatedFieldElements(%s)", fieldDescriptors).build();
    }

    final FluentEqualityConfig usingDoubleTolerance(double tolerance) {
        return this.toBuilder().setDoubleCorrespondenceMap(FieldScopeLogicMap.defaultValue(Correspondence.tolerance((double)tolerance))).addUsingCorrespondenceString(".usingDoubleTolerance(" + tolerance + ")").build();
    }

    final FluentEqualityConfig usingDoubleToleranceForFields(double tolerance, Iterable<Integer> fieldNumbers) {
        return this.toBuilder().setDoubleCorrespondenceMap(this.doubleCorrespondenceMap().with(FieldScopeLogic.none().allowingFieldsNonRecursive(fieldNumbers), (Correspondence<Number, Number>)Correspondence.tolerance((double)tolerance))).addUsingCorrespondenceFieldNumbersString(".usingDoubleTolerance(" + tolerance + ", %s)", fieldNumbers).build();
    }

    final FluentEqualityConfig usingDoubleToleranceForFieldDescriptors(double tolerance, Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.toBuilder().setDoubleCorrespondenceMap(this.doubleCorrespondenceMap().with(FieldScopeLogic.none().allowingFieldDescriptorsNonRecursive(fieldDescriptors), (Correspondence<Number, Number>)Correspondence.tolerance((double)tolerance))).addUsingCorrespondenceFieldDescriptorsString(".usingDoubleTolerance(" + tolerance + ", %s)", fieldDescriptors).build();
    }

    final FluentEqualityConfig usingFloatTolerance(float tolerance) {
        return this.toBuilder().setFloatCorrespondenceMap(FieldScopeLogicMap.defaultValue(Correspondence.tolerance((double)tolerance))).addUsingCorrespondenceString(".usingFloatTolerance(" + tolerance + ")").build();
    }

    final FluentEqualityConfig usingFloatToleranceForFields(float tolerance, Iterable<Integer> fieldNumbers) {
        return this.toBuilder().setFloatCorrespondenceMap(this.floatCorrespondenceMap().with(FieldScopeLogic.none().allowingFieldsNonRecursive(fieldNumbers), (Correspondence<Number, Number>)Correspondence.tolerance((double)tolerance))).addUsingCorrespondenceFieldNumbersString(".usingFloatTolerance(" + tolerance + ", %s)", fieldNumbers).build();
    }

    final FluentEqualityConfig usingFloatToleranceForFieldDescriptors(float tolerance, Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.toBuilder().setFloatCorrespondenceMap(this.floatCorrespondenceMap().with(FieldScopeLogic.none().allowingFieldDescriptorsNonRecursive(fieldDescriptors), (Correspondence<Number, Number>)Correspondence.tolerance((double)tolerance))).addUsingCorrespondenceFieldDescriptorsString(".usingFloatTolerance(" + tolerance + ", %s)", fieldDescriptors).build();
    }

    final FluentEqualityConfig comparingExpectedFieldsOnly() {
        return this.toBuilder().setCompareExpectedFieldsOnly(true).addUsingCorrespondenceString(".comparingExpectedFieldsOnly()").build();
    }

    final FluentEqualityConfig withExpectedMessages(Iterable<? extends Message> messages) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (Message message : messages) {
            if (message == null) continue;
            listBuilder.add((Object)message);
        }
        Builder builder = this.toBuilder().setExpectedMessages((ImmutableList<Message>)listBuilder.build());
        if (this.compareExpectedFieldsOnly()) {
            builder.setCompareFieldsScope(FieldScopeLogic.and(this.compareFieldsScope(), FieldScopes.fromSetFields(messages).logic()));
        }
        return builder.build();
    }

    final FluentEqualityConfig withPartialScope(FieldScope partialScope) {
        return this.toBuilder().setCompareFieldsScope(FieldScopeLogic.and(this.compareFieldsScope(), partialScope.logic())).addUsingCorrespondenceFieldScopeString(".withPartialScope(%s)", partialScope).build();
    }

    final FluentEqualityConfig ignoringFields(Iterable<Integer> fieldNumbers) {
        return this.toBuilder().setCompareFieldsScope(this.compareFieldsScope().ignoringFields(fieldNumbers)).addUsingCorrespondenceFieldNumbersString(".ignoringFields(%s)", fieldNumbers).build();
    }

    final FluentEqualityConfig ignoringFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.toBuilder().setCompareFieldsScope(this.compareFieldsScope().ignoringFieldDescriptors(fieldDescriptors)).addUsingCorrespondenceFieldDescriptorsString(".ignoringFieldDescriptors(%s)", fieldDescriptors).build();
    }

    final FluentEqualityConfig ignoringFieldScope(FieldScope fieldScope) {
        return this.toBuilder().setCompareFieldsScope(FieldScopeLogic.and(this.compareFieldsScope(), FieldScopeLogic.not(fieldScope.logic()))).addUsingCorrespondenceFieldScopeString(".ignoringFieldScope(%s)", fieldScope).build();
    }

    final FluentEqualityConfig reportingMismatchesOnly() {
        return this.toBuilder().setReportMismatchesOnly(true).addUsingCorrespondenceString(".reportingMismatchesOnly()").build();
    }

    @Override
    public final FluentEqualityConfig subScope(Descriptors.Descriptor rootDescriptor, FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
        return this.toBuilder().setIgnoreFieldAbsenceScope(this.ignoreFieldAbsenceScope().subScope(rootDescriptor, fieldDescriptorOrUnknown)).setIgnoreRepeatedFieldOrderScope(this.ignoreRepeatedFieldOrderScope().subScope(rootDescriptor, fieldDescriptorOrUnknown)).setIgnoreExtraRepeatedFieldElementsScope(this.ignoreExtraRepeatedFieldElementsScope().subScope(rootDescriptor, fieldDescriptorOrUnknown)).setDoubleCorrespondenceMap((FieldScopeLogicMap<Correspondence<Number, Number>>)this.doubleCorrespondenceMap().subScope(rootDescriptor, fieldDescriptorOrUnknown)).setFloatCorrespondenceMap((FieldScopeLogicMap<Correspondence<Number, Number>>)this.floatCorrespondenceMap().subScope(rootDescriptor, fieldDescriptorOrUnknown)).setCompareFieldsScope(this.compareFieldsScope().subScope(rootDescriptor, fieldDescriptorOrUnknown)).build();
    }

    @Override
    public final void validate(Descriptors.Descriptor rootDescriptor, FieldDescriptorValidator fieldDescriptorValidator) {
        Verify.verify((fieldDescriptorValidator == FieldDescriptorValidator.ALLOW_ALL ? 1 : 0) != 0);
        this.ignoreFieldAbsenceScope().validate(rootDescriptor, FieldDescriptorValidator.IS_FIELD_WITH_ABSENCE);
        this.ignoreRepeatedFieldOrderScope().validate(rootDescriptor, FieldDescriptorValidator.IS_FIELD_WITH_ORDER);
        this.ignoreExtraRepeatedFieldElementsScope().validate(rootDescriptor, FieldDescriptorValidator.IS_FIELD_WITH_EXTRA_ELEMENTS);
        this.doubleCorrespondenceMap().validate(rootDescriptor, FieldDescriptorValidator.IS_DOUBLE_FIELD);
        this.floatCorrespondenceMap().validate(rootDescriptor, FieldDescriptorValidator.IS_FLOAT_FIELD);
        this.compareFieldsScope().validate(rootDescriptor, FieldDescriptorValidator.ALLOW_ALL);
    }

    final ProtoTruthMessageDifferencer toMessageDifferencer(Descriptors.Descriptor descriptor) {
        Preconditions.checkState((boolean)this.expectedMessages().isPresent(), (Object)"expectedMessages() not set");
        return (ProtoTruthMessageDifferencer)this.messageDifferencers.getUnchecked((Object)descriptor);
    }

    final <M extends Message> Correspondence<M, M> toCorrespondence(Optional<Descriptors.Descriptor> optDescriptor) {
        Preconditions.checkState((boolean)this.expectedMessages().isPresent(), (Object)"expectedMessages() not set");
        return Correspondence.from((Correspondence.BinaryPredicate)new Correspondence.BinaryPredicate<M, M>(){

            public boolean apply(@NullableDecl M actual, @NullableDecl M expected) {
                return ProtoTruth.assertThat(actual).usingConfig(FluentEqualityConfig.this).testIsEqualTo(expected);
            }
        }, (String)("is equivalent according to assertThat(proto)" + this.usingCorrespondenceString(optDescriptor) + ".isEqualTo(target) to")).formattingDiffsUsing(new Correspondence.DiffFormatter<M, M>(){

            public String formatDiff(@NullableDecl M actual, @NullableDecl M expected) {
                return FluentEqualityConfig.this.formatDiff(actual, expected);
            }
        });
    }

    private <M extends Message> String formatDiff(@NullableDecl M actual, @NullableDecl M expected) {
        if (actual == null || expected == null) {
            return "";
        }
        return this.toMessageDifferencer(actual.getDescriptorForType()).diffMessages(actual, expected).printToString(this.reportMismatchesOnly());
    }

    abstract Builder toBuilder();

    @CanIgnoreReturnValue
    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setIgnoreFieldAbsenceScope(FieldScopeLogic var1);

        abstract Builder setIgnoreRepeatedFieldOrderScope(FieldScopeLogic var1);

        abstract Builder setIgnoreExtraRepeatedFieldElementsScope(FieldScopeLogic var1);

        abstract Builder setDoubleCorrespondenceMap(FieldScopeLogicMap<Correspondence<Number, Number>> var1);

        abstract Builder setFloatCorrespondenceMap(FieldScopeLogicMap<Correspondence<Number, Number>> var1);

        abstract Builder setCompareExpectedFieldsOnly(boolean var1);

        abstract Builder setExpectedMessages(ImmutableList<Message> var1);

        abstract Builder setCompareFieldsScope(FieldScopeLogic var1);

        abstract Builder setReportMismatchesOnly(boolean var1);

        @CheckReturnValue
        abstract Function<? super Optional<Descriptors.Descriptor>, String> usingCorrespondenceStringFunction();

        abstract Builder setUsingCorrespondenceStringFunction(Function<? super Optional<Descriptors.Descriptor>, String> var1);

        abstract FluentEqualityConfig build();

        final Builder addUsingCorrespondenceString(String string) {
            return this.setUsingCorrespondenceStringFunction(FieldScopeUtil.concat(this.usingCorrespondenceStringFunction(), (Function<? super Optional<Descriptors.Descriptor>, String>)Functions.constant((Object)string)));
        }

        final Builder addUsingCorrespondenceFieldNumbersString(String fmt, Iterable<Integer> fieldNumbers) {
            return this.setUsingCorrespondenceStringFunction(FieldScopeUtil.concat(this.usingCorrespondenceStringFunction(), FieldScopeUtil.fieldNumbersFunction(fmt, fieldNumbers)));
        }

        final Builder addUsingCorrespondenceFieldDescriptorsString(String fmt, Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.setUsingCorrespondenceStringFunction(FieldScopeUtil.concat(this.usingCorrespondenceStringFunction(), (Function<? super Optional<Descriptors.Descriptor>, String>)Functions.constant((Object)String.format(fmt, FieldScopeUtil.join(fieldDescriptors)))));
        }

        final Builder addUsingCorrespondenceFieldScopeString(String fmt, FieldScope fieldScope) {
            return this.setUsingCorrespondenceStringFunction(FieldScopeUtil.concat(this.usingCorrespondenceStringFunction(), FieldScopeUtil.fieldScopeFunction(fmt, fieldScope)));
        }
    }
}

