/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.Ordered;
import com.google.common.truth.extensions.proto.FieldScope;
import com.google.common.truth.extensions.proto.FieldScopeUtil;
import com.google.common.truth.extensions.proto.FluentEqualityConfig;
import com.google.common.truth.extensions.proto.IterableOfProtosFluentAssertion;
import com.google.common.truth.extensions.proto.IterableOfProtosUsingCorrespondence;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.Arrays;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class IterableOfProtosSubject<S extends IterableOfProtosSubject<S, M, C>, M extends Message, C extends Iterable<M>>
extends IterableSubject {
    private final FailureMetadata metadata;
    private final C actual;
    private final FluentEqualityConfig config;

    protected IterableOfProtosSubject(FailureMetadata failureMetadata, @NullableDecl C messages) {
        this(failureMetadata, FluentEqualityConfig.defaultInstance(), messages);
    }

    IterableOfProtosSubject(FailureMetadata failureMetadata, FluentEqualityConfig config, @NullableDecl C messages) {
        super(failureMetadata, messages);
        this.metadata = failureMetadata;
        this.actual = messages;
        this.config = config;
    }

    public IterableOfProtosUsingCorrespondence<M> displayingDiffsPairedBy(Function<? super M, ?> keyFunction) {
        return this.usingCorrespondence().displayingDiffsPairedBy(keyFunction);
    }

    IterableOfProtosFluentAssertion<M> usingConfig(FluentEqualityConfig newConfig) {
        IterableOfMessagesSubject newSubject = new IterableOfMessagesSubject(this.metadata, newConfig, (Iterable)this.actual);
        if (this.internalCustomName() != null) {
            newSubject.named(this.internalCustomName(), new Object[0]);
        }
        return new IterableOfProtosFluentAssertionImpl(newSubject);
    }

    public IterableOfProtosFluentAssertion<M> ignoringFieldAbsence() {
        return this.usingConfig(this.config.ignoringFieldAbsence());
    }

    public IterableOfProtosFluentAssertion<M> ignoringFieldAbsenceOfFields(int firstFieldNumber, int ... rest) {
        return this.usingConfig(this.config.ignoringFieldAbsenceOfFields(FieldScopeUtil.asList(firstFieldNumber, rest)));
    }

    public IterableOfProtosFluentAssertion<M> ignoringFieldAbsenceOfFields(Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.ignoringFieldAbsenceOfFields(fieldNumbers));
    }

    public IterableOfProtosFluentAssertion<M> ignoringFieldAbsenceOfFieldDescriptors(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.usingConfig(this.config.ignoringFieldAbsenceOfFieldDescriptors(Lists.asList((Object)firstFieldDescriptor, (Object[])rest)));
    }

    public IterableOfProtosFluentAssertion<M> ignoringFieldAbsenceOfFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.ignoringFieldAbsenceOfFieldDescriptors(fieldDescriptors));
    }

    public IterableOfProtosFluentAssertion<M> ignoringRepeatedFieldOrder() {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrder());
    }

    public IterableOfProtosFluentAssertion<M> ignoringRepeatedFieldOrderOfFields(int firstFieldNumber, int ... rest) {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrderOfFields(FieldScopeUtil.asList(firstFieldNumber, rest)));
    }

    public IterableOfProtosFluentAssertion<M> ignoringRepeatedFieldOrderOfFields(Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrderOfFields(fieldNumbers));
    }

    public IterableOfProtosFluentAssertion<M> ignoringRepeatedFieldOrderOfFieldDescriptors(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrderOfFieldDescriptors(Lists.asList((Object)firstFieldDescriptor, (Object[])rest)));
    }

    public IterableOfProtosFluentAssertion<M> ignoringRepeatedFieldOrderOfFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrderOfFieldDescriptors(fieldDescriptors));
    }

    public IterableOfProtosFluentAssertion<M> ignoringExtraRepeatedFieldElements() {
        return this.usingConfig(this.config.ignoringExtraRepeatedFieldElements());
    }

    public IterableOfProtosFluentAssertion<M> ignoringExtraRepeatedFieldElementsOfFields(int firstFieldNumber, int ... rest) {
        return this.usingConfig(this.config.ignoringExtraRepeatedFieldElementsOfFields(FieldScopeUtil.asList(firstFieldNumber, rest)));
    }

    public IterableOfProtosFluentAssertion<M> ignoringExtraRepeatedFieldElementsOfFields(Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.ignoringExtraRepeatedFieldElementsOfFields(fieldNumbers));
    }

    public IterableOfProtosFluentAssertion<M> ignoringExtraRepeatedFieldElementsOfFieldDescriptors(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.usingConfig(this.config.ignoringExtraRepeatedFieldElementsOfFieldDescriptors(Lists.asList((Object)firstFieldDescriptor, (Object[])rest)));
    }

    public IterableOfProtosFluentAssertion<M> ignoringExtraRepeatedFieldElementsOfFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.ignoringExtraRepeatedFieldElementsOfFieldDescriptors(fieldDescriptors));
    }

    public IterableOfProtosFluentAssertion<M> usingDoubleTolerance(double tolerance) {
        return this.usingConfig(this.config.usingDoubleTolerance(tolerance));
    }

    public IterableOfProtosFluentAssertion<M> usingDoubleToleranceForFields(double tolerance, int firstFieldNumber, int ... rest) {
        return this.usingConfig(this.config.usingDoubleToleranceForFields(tolerance, FieldScopeUtil.asList(firstFieldNumber, rest)));
    }

    public IterableOfProtosFluentAssertion<M> usingDoubleToleranceForFields(double tolerance, Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.usingDoubleToleranceForFields(tolerance, fieldNumbers));
    }

    public IterableOfProtosFluentAssertion<M> usingDoubleToleranceForFieldDescriptors(double tolerance, Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.usingConfig(this.config.usingDoubleToleranceForFieldDescriptors(tolerance, Lists.asList((Object)firstFieldDescriptor, (Object[])rest)));
    }

    public IterableOfProtosFluentAssertion<M> usingDoubleToleranceForFieldDescriptors(double tolerance, Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.usingDoubleToleranceForFieldDescriptors(tolerance, fieldDescriptors));
    }

    public IterableOfProtosFluentAssertion<M> usingFloatTolerance(float tolerance) {
        return this.usingConfig(this.config.usingFloatTolerance(tolerance));
    }

    public IterableOfProtosFluentAssertion<M> usingFloatToleranceForFields(float tolerance, int firstFieldNumber, int ... rest) {
        return this.usingConfig(this.config.usingFloatToleranceForFields(tolerance, FieldScopeUtil.asList(firstFieldNumber, rest)));
    }

    public IterableOfProtosFluentAssertion<M> usingFloatToleranceForFields(float tolerance, Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.usingFloatToleranceForFields(tolerance, fieldNumbers));
    }

    public IterableOfProtosFluentAssertion<M> usingFloatToleranceForFieldDescriptors(float tolerance, Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.usingConfig(this.config.usingFloatToleranceForFieldDescriptors(tolerance, Lists.asList((Object)firstFieldDescriptor, (Object[])rest)));
    }

    public IterableOfProtosFluentAssertion<M> usingFloatToleranceForFieldDescriptors(float tolerance, Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.usingFloatToleranceForFieldDescriptors(tolerance, fieldDescriptors));
    }

    public IterableOfProtosFluentAssertion<M> comparingExpectedFieldsOnly() {
        return this.usingConfig(this.config.comparingExpectedFieldsOnly());
    }

    public IterableOfProtosFluentAssertion<M> withPartialScope(FieldScope fieldScope) {
        return this.usingConfig(this.config.withPartialScope((FieldScope)Preconditions.checkNotNull((Object)fieldScope, (Object)"fieldScope")));
    }

    public IterableOfProtosFluentAssertion<M> ignoringFields(int firstFieldNumber, int ... rest) {
        return this.ignoringFields(FieldScopeUtil.asList(firstFieldNumber, rest));
    }

    public IterableOfProtosFluentAssertion<M> ignoringFields(Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.ignoringFields(fieldNumbers));
    }

    public IterableOfProtosFluentAssertion<M> ignoringFieldDescriptors(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.ignoringFieldDescriptors(Lists.asList((Object)firstFieldDescriptor, (Object[])rest));
    }

    public IterableOfProtosFluentAssertion<M> ignoringFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.ignoringFieldDescriptors(fieldDescriptors));
    }

    public IterableOfProtosFluentAssertion<M> ignoringFieldScope(FieldScope fieldScope) {
        return this.usingConfig(this.config.ignoringFieldScope((FieldScope)Preconditions.checkNotNull((Object)fieldScope, (Object)"fieldScope")));
    }

    public IterableOfProtosFluentAssertion<M> reportingMismatchesOnly() {
        return this.usingConfig(this.config.reportingMismatchesOnly());
    }

    @Deprecated
    public final void isInStrictOrder() {
        throw new ClassCastException("Protos do not implement Comparable, so you must supply a Comparator.");
    }

    @Deprecated
    public final void isInOrder() {
        throw new ClassCastException("Protos do not implement Comparable, so you must supply a Comparator.");
    }

    private IterableOfProtosUsingCorrespondence<M> usingCorrespondence() {
        return new UsingCorrespondence(this, null);
    }

    private static final class IterableOfProtosFluentAssertionImpl<M extends Message>
    implements IterableOfProtosFluentAssertion<M> {
        private final IterableOfProtosSubject<?, M, ?> subject;

        IterableOfProtosFluentAssertionImpl(IterableOfProtosSubject<?, M, ?> subject) {
            this.subject = subject;
        }

        @Override
        public IterableOfProtosFluentAssertion<M> ignoringFieldAbsence() {
            return this.subject.ignoringFieldAbsence();
        }

        @Override
        public IterableOfProtosFluentAssertion<M> ignoringFieldAbsenceOfFields(int firstFieldNumber, int ... rest) {
            return this.subject.ignoringFieldAbsenceOfFields(firstFieldNumber, rest);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> ignoringFieldAbsenceOfFields(Iterable<Integer> fieldNumbers) {
            return this.subject.ignoringFieldAbsenceOfFields(fieldNumbers);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> ignoringFieldAbsenceOfFieldDescriptors(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.subject.ignoringFieldAbsenceOfFieldDescriptors(firstFieldDescriptor, rest);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> ignoringFieldAbsenceOfFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.subject.ignoringFieldAbsenceOfFieldDescriptors(fieldDescriptors);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> ignoringRepeatedFieldOrder() {
            return this.subject.ignoringRepeatedFieldOrder();
        }

        @Override
        public IterableOfProtosFluentAssertion<M> ignoringRepeatedFieldOrderOfFields(int firstFieldNumber, int ... rest) {
            return this.subject.ignoringRepeatedFieldOrderOfFields(firstFieldNumber, rest);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> ignoringRepeatedFieldOrderOfFields(Iterable<Integer> fieldNumbers) {
            return this.subject.ignoringRepeatedFieldOrderOfFields(fieldNumbers);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> ignoringRepeatedFieldOrderOfFieldDescriptors(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.subject.ignoringRepeatedFieldOrderOfFieldDescriptors(firstFieldDescriptor, rest);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> ignoringRepeatedFieldOrderOfFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.subject.ignoringRepeatedFieldOrderOfFieldDescriptors(fieldDescriptors);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> ignoringExtraRepeatedFieldElements() {
            return this.subject.ignoringExtraRepeatedFieldElements();
        }

        @Override
        public IterableOfProtosFluentAssertion<M> ignoringExtraRepeatedFieldElementsOfFields(int firstFieldNumber, int ... rest) {
            return this.subject.ignoringExtraRepeatedFieldElementsOfFields(firstFieldNumber, rest);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> ignoringExtraRepeatedFieldElementsOfFields(Iterable<Integer> fieldNumbers) {
            return this.subject.ignoringExtraRepeatedFieldElementsOfFields(fieldNumbers);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> ignoringExtraRepeatedFieldElementsOfFieldDescriptors(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.subject.ignoringExtraRepeatedFieldElementsOfFieldDescriptors(firstFieldDescriptor, rest);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> ignoringExtraRepeatedFieldElementsOfFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.subject.ignoringExtraRepeatedFieldElementsOfFieldDescriptors(fieldDescriptors);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> usingDoubleTolerance(double tolerance) {
            return this.subject.usingDoubleTolerance(tolerance);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> usingDoubleToleranceForFields(double tolerance, int firstFieldNumber, int ... rest) {
            return this.subject.usingDoubleToleranceForFields(tolerance, firstFieldNumber, rest);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> usingDoubleToleranceForFields(double tolerance, Iterable<Integer> fieldNumbers) {
            return this.subject.usingDoubleToleranceForFields(tolerance, fieldNumbers);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> usingDoubleToleranceForFieldDescriptors(double tolerance, Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.subject.usingDoubleToleranceForFieldDescriptors(tolerance, firstFieldDescriptor, rest);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> usingDoubleToleranceForFieldDescriptors(double tolerance, Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.subject.usingDoubleToleranceForFieldDescriptors(tolerance, fieldDescriptors);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> usingFloatTolerance(float tolerance) {
            return this.subject.usingFloatTolerance(tolerance);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> usingFloatToleranceForFields(float tolerance, int firstFieldNumber, int ... rest) {
            return this.subject.usingFloatToleranceForFields(tolerance, firstFieldNumber, rest);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> usingFloatToleranceForFields(float tolerance, Iterable<Integer> fieldNumbers) {
            return this.subject.usingFloatToleranceForFields(tolerance, fieldNumbers);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> usingFloatToleranceForFieldDescriptors(float tolerance, Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.subject.usingFloatToleranceForFieldDescriptors(tolerance, firstFieldDescriptor, rest);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> usingFloatToleranceForFieldDescriptors(float tolerance, Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.subject.usingFloatToleranceForFieldDescriptors(tolerance, fieldDescriptors);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> comparingExpectedFieldsOnly() {
            return this.subject.comparingExpectedFieldsOnly();
        }

        @Override
        public IterableOfProtosFluentAssertion<M> withPartialScope(FieldScope fieldScope) {
            return this.subject.withPartialScope(fieldScope);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> ignoringFields(int firstFieldNumber, int ... rest) {
            return this.subject.ignoringFields(firstFieldNumber, rest);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> ignoringFields(Iterable<Integer> fieldNumbers) {
            return this.subject.ignoringFields(fieldNumbers);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> ignoringFieldDescriptors(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.subject.ignoringFieldDescriptors(firstFieldDescriptor, rest);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> ignoringFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.subject.ignoringFieldDescriptors(fieldDescriptors);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> ignoringFieldScope(FieldScope fieldScope) {
            return this.subject.ignoringFieldScope(fieldScope);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> reportingMismatchesOnly() {
            return this.subject.reportingMismatchesOnly();
        }

        @Override
        public IterableOfProtosUsingCorrespondence<M> displayingDiffsPairedBy(Function<? super M, ?> keyFunction) {
            return this.usingCorrespondence().displayingDiffsPairedBy(keyFunction);
        }

        @Override
        public void contains(@NullableDecl M expected) {
            this.usingCorrespondence().contains(expected);
        }

        @Override
        public void doesNotContain(@NullableDecl M excluded) {
            this.usingCorrespondence().doesNotContain(excluded);
        }

        @Override
        public Ordered containsExactly(M ... expected) {
            return this.usingCorrespondence().containsExactly((Message[])expected);
        }

        @Override
        public Ordered containsExactlyElementsIn(Iterable<? extends M> expected) {
            return this.usingCorrespondence().containsExactlyElementsIn(expected);
        }

        @Override
        public Ordered containsExactlyElementsIn(M[] expected) {
            return this.usingCorrespondence().containsExactlyElementsIn((Message[])expected);
        }

        @Override
        public Ordered containsAtLeast(@NullableDecl M first, @NullableDecl M second, M ... rest) {
            return this.usingCorrespondence().containsAtLeast((Message)first, (Message)second, (Message[])rest);
        }

        @Override
        public Ordered containsAtLeastElementsIn(Iterable<? extends M> expected) {
            return this.usingCorrespondence().containsAtLeastElementsIn(expected);
        }

        @Override
        public Ordered containsAtLeastElementsIn(M[] expected) {
            return this.usingCorrespondence().containsAtLeastElementsIn((Message[])expected);
        }

        @Override
        public Ordered containsAllOf(@NullableDecl M first, @NullableDecl M second, M ... rest) {
            return this.containsAtLeast((Message)first, (Message)second, (Message[])rest);
        }

        @Override
        public Ordered containsAllIn(Iterable<? extends M> expected) {
            return this.containsAtLeastElementsIn(expected);
        }

        @Override
        public Ordered containsAllIn(M[] expected) {
            return this.containsAtLeastElementsIn((Message[])expected);
        }

        @Override
        public void containsAnyOf(@NullableDecl M first, @NullableDecl M second, M ... rest) {
            this.usingCorrespondence().containsAnyOf((Message)first, (Message)second, (Message[])rest);
        }

        @Override
        public void containsAnyIn(Iterable<? extends M> expected) {
            this.usingCorrespondence().containsAnyIn(expected);
        }

        @Override
        public void containsAnyIn(M[] expected) {
            this.usingCorrespondence().containsAnyIn((Message[])expected);
        }

        @Override
        public void containsNoneOf(@NullableDecl M firstExcluded, @NullableDecl M secondExcluded, M ... restOfExcluded) {
            this.usingCorrespondence().containsNoneOf((Message)firstExcluded, (Message)secondExcluded, (Message[])restOfExcluded);
        }

        @Override
        public void containsNoneIn(Iterable<? extends M> excluded) {
            this.usingCorrespondence().containsNoneIn(excluded);
        }

        @Override
        public void containsNoneIn(M[] excluded) {
            this.usingCorrespondence().containsNoneIn((Message[])excluded);
        }

        @Override
        @Deprecated
        public boolean equals(Object o) {
            return this.subject.equals(o);
        }

        @Override
        @Deprecated
        public int hashCode() {
            return this.subject.hashCode();
        }

        private final IterableOfProtosUsingCorrespondence<M> usingCorrespondence() {
            return ((IterableOfProtosSubject)this.subject).usingCorrespondence();
        }
    }

    private static class UsingCorrespondence<M extends Message>
    implements IterableOfProtosUsingCorrespondence<M> {
        private final IterableOfProtosSubject<?, M, ?> subject;
        @NullableDecl
        private final Function<? super M, ? extends Object> keyFunction;

        UsingCorrespondence(IterableOfProtosSubject<?, M, ?> subject, @NullableDecl Function<? super M, ? extends Object> keyFunction) {
            this.subject = (IterableOfProtosSubject)((Object)Preconditions.checkNotNull(subject));
            this.keyFunction = keyFunction;
        }

        private IterableSubject.UsingCorrespondence<M, M> delegate(Iterable<? extends M> messages) {
            IterableSubject.UsingCorrespondence usingCorrespondence = this.subject.comparingElementsUsing(((IterableOfProtosSubject)this.subject).config.withExpectedMessages(messages).toCorrespondence(FieldScopeUtil.getSingleDescriptor(((IterableOfProtosSubject)this.subject).actual)));
            if (this.keyFunction != null) {
                usingCorrespondence = usingCorrespondence.displayingDiffsPairedBy(this.keyFunction);
            }
            return usingCorrespondence;
        }

        @Override
        public IterableOfProtosUsingCorrespondence<M> displayingDiffsPairedBy(Function<? super M, ?> keyFunction) {
            return new UsingCorrespondence<M>(this.subject, (Function)Preconditions.checkNotNull(keyFunction));
        }

        @Override
        public void contains(@NullableDecl M expected) {
            this.delegate(Arrays.asList(expected)).contains(expected);
        }

        @Override
        public void doesNotContain(@NullableDecl M excluded) {
            this.delegate(Arrays.asList(excluded)).doesNotContain(excluded);
        }

        @Override
        @CanIgnoreReturnValue
        public Ordered containsExactly(M ... expected) {
            return this.delegate(Arrays.asList(expected)).containsExactly((Object[])expected);
        }

        @Override
        @CanIgnoreReturnValue
        public Ordered containsExactlyElementsIn(Iterable<? extends M> expected) {
            return this.delegate(expected).containsExactlyElementsIn(expected);
        }

        @Override
        @CanIgnoreReturnValue
        public Ordered containsExactlyElementsIn(M[] expected) {
            return this.delegate(Arrays.asList(expected)).containsExactlyElementsIn((Object[])expected);
        }

        @Override
        @CanIgnoreReturnValue
        public Ordered containsAtLeast(@NullableDecl M first, @NullableDecl M second, M ... rest) {
            return this.delegate(Lists.asList(first, second, (Object[])rest)).containsAtLeast(first, second, (Object[])rest);
        }

        @Override
        @CanIgnoreReturnValue
        public Ordered containsAtLeastElementsIn(Iterable<? extends M> expected) {
            return this.delegate(expected).containsAtLeastElementsIn(expected);
        }

        @Override
        @CanIgnoreReturnValue
        public Ordered containsAtLeastElementsIn(M[] expected) {
            return this.delegate(Arrays.asList(expected)).containsAtLeastElementsIn((Object[])expected);
        }

        @Override
        @CanIgnoreReturnValue
        public Ordered containsAllOf(@NullableDecl M first, @NullableDecl M second, M ... rest) {
            return this.containsAtLeast((Message)first, (Message)second, (Message[])rest);
        }

        @Override
        @CanIgnoreReturnValue
        public Ordered containsAllIn(Iterable<? extends M> expected) {
            return this.containsAtLeastElementsIn(expected);
        }

        @Override
        @CanIgnoreReturnValue
        public Ordered containsAllIn(M[] expected) {
            return this.containsAtLeastElementsIn((Message[])expected);
        }

        @Override
        public void containsAnyOf(@NullableDecl M first, @NullableDecl M second, M ... rest) {
            this.delegate(Lists.asList(first, second, (Object[])rest)).containsAnyOf(first, second, (Object[])rest);
        }

        @Override
        public void containsAnyIn(Iterable<? extends M> expected) {
            this.delegate(expected).containsAnyIn(expected);
        }

        @Override
        public void containsAnyIn(M[] expected) {
            this.delegate(Arrays.asList(expected)).containsAnyIn((Object[])expected);
        }

        @Override
        public void containsNoneOf(@NullableDecl M firstExcluded, @NullableDecl M secondExcluded, M ... restOfExcluded) {
            this.delegate(Lists.asList(firstExcluded, secondExcluded, (Object[])restOfExcluded)).containsNoneOf(firstExcluded, secondExcluded, (Object[])restOfExcluded);
        }

        @Override
        public void containsNoneIn(Iterable<? extends M> excluded) {
            this.delegate(excluded).containsNoneIn(excluded);
        }

        @Override
        public void containsNoneIn(M[] excluded) {
            this.delegate(Arrays.asList(excluded)).containsNoneIn((Object[])excluded);
        }
    }

    public static final class IterableOfMessagesSubject<M extends Message>
    extends IterableOfProtosSubject<IterableOfMessagesSubject<M>, M, Iterable<M>> {
        IterableOfMessagesSubject(FailureMetadata failureMetadata, @NullableDecl Iterable<M> messages) {
            super(failureMetadata, messages);
        }

        private IterableOfMessagesSubject(FailureMetadata failureMetadata, FluentEqualityConfig config, @NullableDecl Iterable<M> messages) {
            super(failureMetadata, config, messages);
        }
    }
}

