/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.extensions.proto.DiffResult;
import com.google.common.truth.extensions.proto.FieldScope;
import com.google.common.truth.extensions.proto.FieldScopeUtil;
import com.google.common.truth.extensions.proto.FluentEqualityConfig;
import com.google.common.truth.extensions.proto.LiteProtoSubject;
import com.google.common.truth.extensions.proto.ProtoFluentAssertion;
import com.google.common.truth.extensions.proto.ProtoTruthMessageDifferencer;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.Arrays;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class ProtoSubject<S extends ProtoSubject<S, M>, M extends Message>
extends LiteProtoSubject<S, M>
implements ProtoFluentAssertion {
    private final FailureMetadata metadata;
    private final M actual;
    private final FluentEqualityConfig config;

    protected ProtoSubject(FailureMetadata failureMetadata, @NullableDecl M message) {
        this(failureMetadata, FluentEqualityConfig.defaultInstance(), message);
    }

    ProtoSubject(FailureMetadata failureMetadata, FluentEqualityConfig config, @NullableDecl M message) {
        super(failureMetadata, message);
        this.metadata = failureMetadata;
        this.actual = message;
        this.config = config;
    }

    ProtoSubject<?, Message> usingConfig(FluentEqualityConfig newConfig) {
        MessageSubject newSubject = new MessageSubject(this.metadata, newConfig, (Message)this.actual);
        if (this.internalCustomName() != null) {
            newSubject.named(this.internalCustomName(), new Object[0]);
        }
        return newSubject;
    }

    @Override
    public ProtoFluentAssertion ignoringFieldAbsence() {
        return this.usingConfig(this.config.ignoringFieldAbsence());
    }

    @Override
    public ProtoFluentAssertion ignoringFieldAbsenceOfFields(int firstFieldNumber, int ... rest) {
        return this.usingConfig(this.config.ignoringFieldAbsenceOfFields(FieldScopeUtil.asList(firstFieldNumber, rest)));
    }

    @Override
    public ProtoFluentAssertion ignoringFieldAbsenceOfFields(Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.ignoringFieldAbsenceOfFields(fieldNumbers));
    }

    @Override
    public ProtoFluentAssertion ignoringFieldAbsenceOfFieldDescriptors(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.usingConfig(this.config.ignoringFieldAbsenceOfFieldDescriptors(Lists.asList((Object)firstFieldDescriptor, (Object[])rest)));
    }

    @Override
    public ProtoFluentAssertion ignoringFieldAbsenceOfFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.ignoringFieldAbsenceOfFieldDescriptors(fieldDescriptors));
    }

    @Override
    public ProtoFluentAssertion ignoringRepeatedFieldOrder() {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrder());
    }

    @Override
    public ProtoFluentAssertion ignoringRepeatedFieldOrderOfFields(int firstFieldNumber, int ... rest) {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrderOfFields(FieldScopeUtil.asList(firstFieldNumber, rest)));
    }

    @Override
    public ProtoFluentAssertion ignoringRepeatedFieldOrderOfFields(Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrderOfFields(fieldNumbers));
    }

    @Override
    public ProtoFluentAssertion ignoringRepeatedFieldOrderOfFieldDescriptors(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrderOfFieldDescriptors(Lists.asList((Object)firstFieldDescriptor, (Object[])rest)));
    }

    @Override
    public ProtoFluentAssertion ignoringRepeatedFieldOrderOfFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrderOfFieldDescriptors(fieldDescriptors));
    }

    @Override
    public ProtoFluentAssertion ignoringExtraRepeatedFieldElements() {
        return this.usingConfig(this.config.ignoringExtraRepeatedFieldElements());
    }

    @Override
    public ProtoFluentAssertion ignoringExtraRepeatedFieldElementsOfFields(int firstFieldNumber, int ... rest) {
        return this.usingConfig(this.config.ignoringExtraRepeatedFieldElementsOfFields(FieldScopeUtil.asList(firstFieldNumber, rest)));
    }

    @Override
    public ProtoFluentAssertion ignoringExtraRepeatedFieldElementsOfFields(Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.ignoringExtraRepeatedFieldElementsOfFields(fieldNumbers));
    }

    @Override
    public ProtoFluentAssertion ignoringExtraRepeatedFieldElementsOfFieldDescriptors(Descriptors.FieldDescriptor first, Descriptors.FieldDescriptor ... rest) {
        return this.usingConfig(this.config.ignoringExtraRepeatedFieldElementsOfFieldDescriptors(Lists.asList((Object)first, (Object[])rest)));
    }

    @Override
    public ProtoFluentAssertion ignoringExtraRepeatedFieldElementsOfFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.ignoringExtraRepeatedFieldElementsOfFieldDescriptors(fieldDescriptors));
    }

    @Override
    public ProtoFluentAssertion usingDoubleTolerance(double tolerance) {
        return this.usingConfig(this.config.usingDoubleTolerance(tolerance));
    }

    @Override
    public ProtoFluentAssertion usingDoubleToleranceForFields(double tolerance, int firstFieldNumber, int ... rest) {
        return this.usingConfig(this.config.usingDoubleToleranceForFields(tolerance, FieldScopeUtil.asList(firstFieldNumber, rest)));
    }

    @Override
    public ProtoFluentAssertion usingDoubleToleranceForFields(double tolerance, Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.usingDoubleToleranceForFields(tolerance, fieldNumbers));
    }

    @Override
    public ProtoFluentAssertion usingDoubleToleranceForFieldDescriptors(double tolerance, Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.usingConfig(this.config.usingDoubleToleranceForFieldDescriptors(tolerance, Lists.asList((Object)firstFieldDescriptor, (Object[])rest)));
    }

    @Override
    public ProtoFluentAssertion usingDoubleToleranceForFieldDescriptors(double tolerance, Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.usingDoubleToleranceForFieldDescriptors(tolerance, fieldDescriptors));
    }

    @Override
    public ProtoFluentAssertion usingFloatTolerance(float tolerance) {
        return this.usingConfig(this.config.usingFloatTolerance(tolerance));
    }

    @Override
    public ProtoFluentAssertion usingFloatToleranceForFields(float tolerance, int firstFieldNumber, int ... rest) {
        return this.usingConfig(this.config.usingFloatToleranceForFields(tolerance, FieldScopeUtil.asList(firstFieldNumber, rest)));
    }

    @Override
    public ProtoFluentAssertion usingFloatToleranceForFields(float tolerance, Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.usingFloatToleranceForFields(tolerance, fieldNumbers));
    }

    @Override
    public ProtoFluentAssertion usingFloatToleranceForFieldDescriptors(float tolerance, Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.usingConfig(this.config.usingFloatToleranceForFieldDescriptors(tolerance, Lists.asList((Object)firstFieldDescriptor, (Object[])rest)));
    }

    @Override
    public ProtoFluentAssertion usingFloatToleranceForFieldDescriptors(float tolerance, Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.usingFloatToleranceForFieldDescriptors(tolerance, fieldDescriptors));
    }

    @Override
    public ProtoFluentAssertion comparingExpectedFieldsOnly() {
        return this.usingConfig(this.config.comparingExpectedFieldsOnly());
    }

    @Override
    public ProtoFluentAssertion withPartialScope(FieldScope fieldScope) {
        return this.usingConfig(this.config.withPartialScope((FieldScope)Preconditions.checkNotNull((Object)fieldScope, (Object)"fieldScope")));
    }

    @Override
    public ProtoFluentAssertion ignoringFields(int firstFieldNumber, int ... rest) {
        return this.ignoringFields(FieldScopeUtil.asList(firstFieldNumber, rest));
    }

    @Override
    public ProtoFluentAssertion ignoringFields(Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.ignoringFields(fieldNumbers));
    }

    @Override
    public ProtoFluentAssertion ignoringFieldDescriptors(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.ignoringFieldDescriptors(Lists.asList((Object)firstFieldDescriptor, (Object[])rest));
    }

    @Override
    public ProtoFluentAssertion ignoringFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.ignoringFieldDescriptors(fieldDescriptors));
    }

    @Override
    public ProtoFluentAssertion ignoringFieldScope(FieldScope fieldScope) {
        return this.usingConfig(this.config.ignoringFieldScope((FieldScope)Preconditions.checkNotNull((Object)fieldScope, (Object)"fieldScope")));
    }

    @Override
    public ProtoFluentAssertion reportingMismatchesOnly() {
        return this.usingConfig(this.config.reportingMismatchesOnly());
    }

    private static boolean sameClassMessagesWithDifferentDescriptors(@NullableDecl Message actual, @NullableDecl Object expected) {
        if (actual == null || !(expected instanceof Message) || actual.getClass() != expected.getClass()) {
            return false;
        }
        return actual.getDescriptorForType() != ((Message)expected).getDescriptorForType();
    }

    private static boolean notMessagesWithSameDescriptor(@NullableDecl Message actual, @NullableDecl Object expected) {
        if (actual != null && expected instanceof Message) {
            return actual.getDescriptorForType() != ((Message)expected).getDescriptorForType();
        }
        return true;
    }

    @Override
    public void isEqualTo(@NullableDecl Object expected) {
        if (ProtoSubject.sameClassMessagesWithDifferentDescriptors(this.actual, expected)) {
            this.failWithoutActual(Fact.simpleFact((String)"Not true that messages compare equal; they have different descriptors."), new Fact[]{Fact.fact((String)"expected", (Object)expected), Fact.fact((String)"with descriptor", (Object)((Message)expected).getDescriptorForType()), Fact.fact((String)"but was", this.actual), Fact.fact((String)"with descriptor", (Object)this.actual.getDescriptorForType())});
        } else if (ProtoSubject.notMessagesWithSameDescriptor(this.actual, expected)) {
            super.isEqualTo(expected);
        } else {
            DiffResult diffResult = this.makeDifferencer((Message)expected).diffMessages((Message)this.actual, (Message)expected);
            if (!diffResult.isMatched()) {
                this.failWithoutActual(Fact.simpleFact((String)(this.failureMessage(true) + "\n" + diffResult.printToString(this.config.reportMismatchesOnly()))), new Fact[0]);
            }
        }
    }

    boolean testIsEqualTo(@NullableDecl Object expected) {
        if (ProtoSubject.notMessagesWithSameDescriptor(this.actual, expected)) {
            return Objects.equal(this.actual, (Object)expected);
        }
        return this.makeDifferencer((Message)expected).diffMessages((Message)this.actual, (Message)expected).isMatched();
    }

    @Override
    public void isNotEqualTo(@NullableDecl Object expected) {
        if (ProtoSubject.notMessagesWithSameDescriptor(this.actual, expected)) {
            super.isNotEqualTo(expected);
        } else {
            DiffResult diffResult = this.makeDifferencer((Message)expected).diffMessages((Message)this.actual, (Message)expected);
            if (diffResult.isMatched()) {
                this.failWithoutActual(Fact.simpleFact((String)(this.failureMessage(false) + "\n" + diffResult.printToString(this.config.reportMismatchesOnly()))), new Fact[0]);
            }
        }
    }

    public void hasAllRequiredFields() {
        if (!this.actual.isInitialized()) {
            this.failWithoutActual(Fact.simpleFact((String)Strings.lenientFormat((String)"Not true that %s has all required fields set. Missing: %s", (Object[])new Object[]{this.actualAsString(), this.actual.findInitializationErrors()})), new Fact[0]);
        }
    }

    private ProtoTruthMessageDifferencer makeDifferencer(Message expected) {
        return this.config.withExpectedMessages(Arrays.asList(expected)).toMessageDifferencer(this.actual.getDescriptorForType());
    }

    private String failureMessage(boolean expectedEqual) {
        StringBuilder rawMessage = new StringBuilder();
        rawMessage.append("Not true that ");
        if (this.internalCustomName() != null) {
            rawMessage.append(this.internalCustomName()).append(" compares ").append(expectedEqual ? "" : "not ").append("equal. ");
        } else {
            rawMessage.append("messages compare ").append(expectedEqual ? "" : "not ").append("equal. ");
        }
        return rawMessage.toString();
    }

    static final class MessageSubject
    extends ProtoSubject<MessageSubject, Message> {
        MessageSubject(FailureMetadata failureMetadata, @NullableDecl Message message) {
            super(failureMetadata, message);
        }

        private MessageSubject(FailureMetadata failureMetadata, FluentEqualityConfig config, @NullableDecl Message message) {
            super(failureMetadata, config, message);
        }
    }
}

