package com.google.common.truth.extensions.proto;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableListMultimap;
import com.google.protobuf.Message;

// Generated by com.google.auto.value.processor.AutoValueProcessor
abstract class $AutoValue_DiffResult extends DiffResult {

  private final Message actual;

  private final Message expected;

  private final ImmutableListMultimap<Integer, DiffResult.SingularField> singularFields;

  private final ImmutableListMultimap<Integer, DiffResult.RepeatedField> repeatedFields;

  private final Optional<DiffResult.UnknownFieldSetDiff> unknownFields;

  $AutoValue_DiffResult(
      Message actual,
      Message expected,
      ImmutableListMultimap<Integer, DiffResult.SingularField> singularFields,
      ImmutableListMultimap<Integer, DiffResult.RepeatedField> repeatedFields,
      Optional<DiffResult.UnknownFieldSetDiff> unknownFields) {
    if (actual == null) {
      throw new NullPointerException("Null actual");
    }
    this.actual = actual;
    if (expected == null) {
      throw new NullPointerException("Null expected");
    }
    this.expected = expected;
    if (singularFields == null) {
      throw new NullPointerException("Null singularFields");
    }
    this.singularFields = singularFields;
    if (repeatedFields == null) {
      throw new NullPointerException("Null repeatedFields");
    }
    this.repeatedFields = repeatedFields;
    if (unknownFields == null) {
      throw new NullPointerException("Null unknownFields");
    }
    this.unknownFields = unknownFields;
  }

  @Override
  Message actual() {
    return actual;
  }

  @Override
  Message expected() {
    return expected;
  }

  @Override
  ImmutableListMultimap<Integer, DiffResult.SingularField> singularFields() {
    return singularFields;
  }

  @Override
  ImmutableListMultimap<Integer, DiffResult.RepeatedField> repeatedFields() {
    return repeatedFields;
  }

  @Override
  Optional<DiffResult.UnknownFieldSetDiff> unknownFields() {
    return unknownFields;
  }

  @Override
  public String toString() {
    return "DiffResult{"
        + "actual=" + actual + ", "
        + "expected=" + expected + ", "
        + "singularFields=" + singularFields + ", "
        + "repeatedFields=" + repeatedFields + ", "
        + "unknownFields=" + unknownFields
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof DiffResult) {
      DiffResult that = (DiffResult) o;
      return this.actual.equals(that.actual())
          && this.expected.equals(that.expected())
          && this.singularFields.equals(that.singularFields())
          && this.repeatedFields.equals(that.repeatedFields())
          && this.unknownFields.equals(that.unknownFields());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= actual.hashCode();
    h$ *= 1000003;
    h$ ^= expected.hashCode();
    h$ *= 1000003;
    h$ ^= singularFields.hashCode();
    h$ *= 1000003;
    h$ ^= repeatedFields.hashCode();
    h$ *= 1000003;
    h$ ^= unknownFields.hashCode();
    return h$;
  }

  static class Builder extends DiffResult.Builder {
    private Message actual;
    private Message expected;
    private ImmutableListMultimap.Builder<Integer, DiffResult.SingularField> singularFieldsBuilder$;
    private ImmutableListMultimap<Integer, DiffResult.SingularField> singularFields;
    private ImmutableListMultimap.Builder<Integer, DiffResult.RepeatedField> repeatedFieldsBuilder$;
    private ImmutableListMultimap<Integer, DiffResult.RepeatedField> repeatedFields;
    private Optional<DiffResult.UnknownFieldSetDiff> unknownFields = Optional.absent();
    Builder() {
    }
    @Override
    DiffResult.Builder setActual(Message actual) {
      if (actual == null) {
        throw new NullPointerException("Null actual");
      }
      this.actual = actual;
      return this;
    }
    @Override
    DiffResult.Builder setExpected(Message expected) {
      if (expected == null) {
        throw new NullPointerException("Null expected");
      }
      this.expected = expected;
      return this;
    }
    @Override
    ImmutableListMultimap.Builder<Integer, DiffResult.SingularField> singularFieldsBuilder() {
      if (singularFieldsBuilder$ == null) {
        singularFieldsBuilder$ = new ImmutableListMultimap.Builder<Integer, DiffResult.SingularField>();
      }
      return singularFieldsBuilder$;
    }
    @Override
    ImmutableListMultimap.Builder<Integer, DiffResult.RepeatedField> repeatedFieldsBuilder() {
      if (repeatedFieldsBuilder$ == null) {
        repeatedFieldsBuilder$ = new ImmutableListMultimap.Builder<Integer, DiffResult.RepeatedField>();
      }
      return repeatedFieldsBuilder$;
    }
    @Override
    DiffResult.Builder setUnknownFields(DiffResult.UnknownFieldSetDiff unknownFields) {
      this.unknownFields = Optional.of(unknownFields);
      return this;
    }
    @Override
    DiffResult build() {
      if (singularFieldsBuilder$ != null) {
        this.singularFields = singularFieldsBuilder$.build();
      } else if (this.singularFields == null) {
        this.singularFields = ImmutableListMultimap.of();
      }
      if (repeatedFieldsBuilder$ != null) {
        this.repeatedFields = repeatedFieldsBuilder$.build();
      } else if (this.repeatedFields == null) {
        this.repeatedFields = ImmutableListMultimap.of();
      }
      String missing = "";
      if (this.actual == null) {
        missing += " actual";
      }
      if (this.expected == null) {
        missing += " expected";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_DiffResult(
          this.actual,
          this.expected,
          this.singularFields,
          this.repeatedFields,
          this.unknownFields);
    }
  }

}
