package com.google.common.truth.extensions.proto;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableListMultimap;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.protobuf.Message;
import java.lang.Integer;
import java.lang.Iterable;
import java.lang.Override;
import java.lang.SuppressWarnings;

final class AutoValue_DiffResult extends $AutoValue_DiffResult {
  @LazyInit
  @SuppressWarnings("Immutable")
  private transient volatile Iterable<? extends RecursableDiffEntity> childEntities;

  AutoValue_DiffResult(Message actual$, Message expected$,
      ImmutableListMultimap<Integer, DiffResult.SingularField> singularFields$,
      ImmutableListMultimap<Integer, DiffResult.RepeatedField> repeatedFields$,
      Optional<DiffResult.UnknownFieldSetDiff> unknownFields$) {
    super(actual$, expected$, singularFields$, repeatedFields$, unknownFields$);
  }

  @Override
  Iterable<? extends RecursableDiffEntity> childEntities() {
    if (childEntities == null) {
      synchronized (this) {
        if (childEntities == null) {
          childEntities = super.childEntities();
          if (childEntities == null) {
            throw new NullPointerException("childEntities() cannot return null");
          }
        }
      }
    }
    return childEntities;
  }
}
