/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.truth.extensions.proto.$AutoValue_DiffResult;
import com.google.common.truth.extensions.proto.$AutoValue_DiffResult_RepeatedField;
import com.google.common.truth.extensions.proto.$AutoValue_DiffResult_RepeatedField_PairResult;
import com.google.common.truth.extensions.proto.$AutoValue_DiffResult_SingularField;
import com.google.common.truth.extensions.proto.$AutoValue_DiffResult_UnknownFieldSetDiff;
import com.google.common.truth.extensions.proto.AnyUtils;
import com.google.common.truth.extensions.proto.RecursableDiffEntity;
import com.google.common.truth.extensions.proto.SubScopeId;
import com.google.common.truth.extensions.proto.UnknownFieldDescriptor;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.ForOverride;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;

@AutoValue
abstract class DiffResult
extends RecursableDiffEntity.WithoutResultCode {
    DiffResult() {
    }

    abstract Message actual();

    abstract Message expected();

    abstract ImmutableListMultimap<Integer, SingularField> singularFields();

    abstract ImmutableListMultimap<Integer, RepeatedField> repeatedFields();

    abstract Optional<UnknownFieldSetDiff> unknownFields();

    @Override
    @Memoized
    Iterable<? extends RecursableDiffEntity> childEntities() {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(this.singularFields().size() + this.repeatedFields().size() + this.unknownFields().asSet().size()));
        Sets.SetView fieldNumbers = Sets.union((Set)this.singularFields().keySet(), (Set)this.repeatedFields().keySet());
        Iterator iterator = Ordering.natural().sortedCopy((Iterable)fieldNumbers).iterator();
        while (iterator.hasNext()) {
            int fieldNumber = (Integer)iterator.next();
            builder.addAll((Iterable)this.singularFields().get((Object)fieldNumber));
            builder.addAll((Iterable)this.repeatedFields().get((Object)fieldNumber));
        }
        builder.addAll((Iterable)this.unknownFields().asSet());
        return builder.build();
    }

    final String printToString(boolean reportMismatchesOnly) {
        StringBuilder sb = new StringBuilder();
        if (!this.isMatched()) {
            sb.append("Differences were found:\n");
            this.printContents(false, "", sb);
            if (!reportMismatchesOnly && this.isAnyChildMatched()) {
                sb.append("\nFull diff report:\n");
                this.printContents(true, "", sb);
            }
        } else {
            sb.append("No differences were found.");
            if (!reportMismatchesOnly) {
                if (this.isAnyChildIgnored()) {
                    sb.append("\nSome fields were ignored for comparison, however.\n");
                } else {
                    sb.append("\nFull diff report:\n");
                }
                this.printContents(true, "", sb);
            }
        }
        return sb.toString();
    }

    @Override
    final void printContents(boolean includeMatches, String fieldPrefix, StringBuilder sb) {
        for (RecursableDiffEntity recursableDiffEntity : this.childEntities()) {
            recursableDiffEntity.printContents(includeMatches, fieldPrefix, sb);
        }
    }

    @Override
    final boolean isContentEmpty() {
        return Iterables.isEmpty(this.childEntities());
    }

    static Builder newBuilder() {
        return new $AutoValue_DiffResult.Builder();
    }

    private static String newFieldPrefix(String rootFieldPrefix, String toAdd) {
        return rootFieldPrefix.isEmpty() ? toAdd : rootFieldPrefix + "." + toAdd;
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setActual(Message var1);

        abstract Builder setExpected(Message var1);

        @ForOverride
        abstract ImmutableListMultimap.Builder<Integer, SingularField> singularFieldsBuilder();

        @CanIgnoreReturnValue
        final Builder addSingularField(int fieldNumber, SingularField singularField) {
            this.singularFieldsBuilder().put((Object)fieldNumber, (Object)singularField);
            return this;
        }

        @CanIgnoreReturnValue
        final Builder addAllSingularFields(int fieldNumber, Iterable<SingularField> singularFields) {
            this.singularFieldsBuilder().putAll((Object)fieldNumber, singularFields);
            return this;
        }

        @ForOverride
        abstract ImmutableListMultimap.Builder<Integer, RepeatedField> repeatedFieldsBuilder();

        @CanIgnoreReturnValue
        final Builder addRepeatedField(int fieldNumber, RepeatedField repeatedField) {
            this.repeatedFieldsBuilder().put((Object)fieldNumber, (Object)repeatedField);
            return this;
        }

        abstract Builder setUnknownFields(UnknownFieldSetDiff var1);

        abstract DiffResult build();
    }

    static interface ProtoPrintable {
        public TextFormat.Printer protoPrinter();

        default public void printMessage(Message m, StringBuilder sb) {
            try {
                this.protoPrinter().print((MessageOrBuilder)m, (Appendable)sb);
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        default public void printFieldValue(SubScopeId subScopeId, Object o, StringBuilder sb) {
            switch (subScopeId.kind()) {
                case FIELD_DESCRIPTOR: {
                    this.printFieldValue(subScopeId.fieldDescriptor(), o, sb);
                    return;
                }
                case UNKNOWN_FIELD_DESCRIPTOR: {
                    this.printFieldValue(subScopeId.unknownFieldDescriptor(), o, sb);
                    return;
                }
                case UNPACKED_ANY_VALUE_TYPE: {
                    this.printFieldValue(AnyUtils.valueFieldDescriptor(), o, sb);
                    return;
                }
            }
            throw new AssertionError((Object)subScopeId.kind());
        }

        default public void printFieldValue(Descriptors.FieldDescriptor field, Object value, StringBuilder sb) {
            try {
                this.protoPrinter().printFieldValue(field, value, (Appendable)sb);
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        default public void printFieldValue(UnknownFieldDescriptor unknownField, Object value, StringBuilder sb) {
            try {
                TextFormat.printUnknownFieldValue((int)unknownField.type().wireType(), (Object)value, (Appendable)sb);
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }
    }

    @AutoValue
    static abstract class UnknownFieldSetDiff
    extends RecursableDiffEntity.WithoutResultCode {
        UnknownFieldSetDiff() {
        }

        abstract Optional<UnknownFieldSet> actual();

        abstract Optional<UnknownFieldSet> expected();

        abstract ImmutableListMultimap<Integer, SingularField> singularFields();

        @Override
        @Memoized
        Iterable<? extends RecursableDiffEntity> childEntities() {
            return this.singularFields().values();
        }

        @Override
        final void printContents(boolean includeMatches, String fieldPrefix, StringBuilder sb) {
            if (!includeMatches && this.isMatched()) {
                return;
            }
            UnmodifiableIterator unmodifiableIterator = this.singularFields().keySet().iterator();
            while (unmodifiableIterator.hasNext()) {
                int fieldNumber = (Integer)unmodifiableIterator.next();
                for (SingularField singularField : this.singularFields().get((Object)fieldNumber)) {
                    singularField.printContents(includeMatches, fieldPrefix, sb);
                }
            }
        }

        @Override
        final boolean isContentEmpty() {
            return this.singularFields().isEmpty();
        }

        static Builder newBuilder() {
            return new $AutoValue_DiffResult_UnknownFieldSetDiff.Builder();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setActual(UnknownFieldSet var1);

            abstract Builder setExpected(UnknownFieldSet var1);

            @ForOverride
            abstract ImmutableListMultimap.Builder<Integer, SingularField> singularFieldsBuilder();

            @CanIgnoreReturnValue
            final Builder addSingularField(int fieldNumber, SingularField singularField) {
                this.singularFieldsBuilder().put((Object)fieldNumber, (Object)singularField);
                return this;
            }

            @CanIgnoreReturnValue
            final Builder addAllSingularFields(int fieldNumber, Iterable<SingularField> singularFields) {
                this.singularFieldsBuilder().putAll((Object)fieldNumber, singularFields);
                return this;
            }

            abstract UnknownFieldSetDiff build();
        }
    }

    @AutoValue
    static abstract class RepeatedField
    extends RecursableDiffEntity.WithoutResultCode {
        RepeatedField() {
        }

        abstract Descriptors.FieldDescriptor fieldDescriptor();

        abstract ImmutableList<Object> actual();

        abstract ImmutableList<Object> expected();

        abstract ImmutableList<PairResult> pairResults();

        @Override
        @Memoized
        Iterable<? extends RecursableDiffEntity> childEntities() {
            return this.pairResults();
        }

        @Override
        final void printContents(boolean includeMatches, String fieldPrefix, StringBuilder sb) {
            fieldPrefix = DiffResult.newFieldPrefix(fieldPrefix, this.fieldDescriptor().getName());
            for (PairResult pairResult : this.pairResults()) {
                pairResult.printContentsForRepeatedField(!this.isMatched(), includeMatches, fieldPrefix, sb);
            }
        }

        @Override
        final boolean isContentEmpty() {
            return this.pairResults().isEmpty();
        }

        static Builder newBuilder() {
            return new $AutoValue_DiffResult_RepeatedField.Builder();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setFieldDescriptor(Descriptors.FieldDescriptor var1);

            abstract Builder setActual(Iterable<?> var1);

            abstract Builder setExpected(Iterable<?> var1);

            @ForOverride
            abstract ImmutableList.Builder<PairResult> pairResultsBuilder();

            @CanIgnoreReturnValue
            final Builder addPairResult(PairResult pairResult) {
                this.pairResultsBuilder().add((Object)pairResult);
                return this;
            }

            abstract RepeatedField build();
        }

        @AutoValue
        static abstract class PairResult
        extends RecursableDiffEntity.WithResultCode
        implements ProtoPrintable {
            PairResult() {
            }

            abstract Descriptors.FieldDescriptor fieldDescriptor();

            abstract Optional<Integer> actualFieldIndex();

            abstract Optional<Integer> expectedFieldIndex();

            abstract Optional<Object> actual();

            abstract Optional<Object> expected();

            abstract Optional<DiffResult> breakdown();

            @Override
            @Memoized
            Iterable<? extends RecursableDiffEntity> childEntities() {
                return this.breakdown().asSet();
            }

            @Memoized
            boolean isMessage() {
                return this.actual().orNull() instanceof Message || this.expected().orNull() instanceof Message;
            }

            private static String indexed(String fieldPrefix, Optional<Integer> fieldIndex) {
                String index = fieldIndex.isPresent() ? ((Integer)fieldIndex.get()).toString() : "?";
                return fieldPrefix + "[" + index + "]";
            }

            @Override
            final void printContents(boolean includeMatches, String fieldPrefix, StringBuilder sb) {
                this.printContentsForRepeatedField(false, includeMatches, fieldPrefix, sb);
            }

            final void printContentsForRepeatedField(boolean includeSelfAlways, boolean includeMatches, String fieldPrefix, StringBuilder sb) {
                if (!includeSelfAlways && !includeMatches && this.isMatched()) {
                    return;
                }
                switch (this.result()) {
                    case ADDED: {
                        sb.append("added: ").append(PairResult.indexed(fieldPrefix, this.actualFieldIndex())).append(": ");
                        if (this.isMessage()) {
                            sb.append("\n");
                            this.printMessage((Message)this.actual().get(), sb);
                        } else {
                            this.printFieldValue(this.fieldDescriptor(), this.actual().get(), sb);
                            sb.append("\n");
                        }
                        return;
                    }
                    case IGNORED: {
                        sb.append("ignored: ");
                        if (this.actualFieldIndex().equals(this.expectedFieldIndex())) {
                            sb.append(PairResult.indexed(fieldPrefix, this.actualFieldIndex()));
                        } else {
                            sb.append(PairResult.indexed(fieldPrefix, this.expectedFieldIndex())).append(" -> ").append(PairResult.indexed(fieldPrefix, this.actualFieldIndex()));
                        }
                        sb.append(":");
                        if (this.isMessage()) {
                            sb.append("\n");
                            this.printChildContents(includeMatches, PairResult.indexed(fieldPrefix, this.actualFieldIndex()), sb);
                        } else {
                            sb.append(" ");
                            this.printFieldValue(this.fieldDescriptor(), this.actual().get(), sb);
                            sb.append("\n");
                        }
                        return;
                    }
                    case MATCHED: {
                        if (((Integer)this.actualFieldIndex().get()).equals(this.expectedFieldIndex().get())) {
                            sb.append("matched: ").append(PairResult.indexed(fieldPrefix, this.actualFieldIndex()));
                        } else {
                            sb.append("moved: ").append(PairResult.indexed(fieldPrefix, this.expectedFieldIndex())).append(" -> ").append(PairResult.indexed(fieldPrefix, this.actualFieldIndex()));
                        }
                        sb.append(":");
                        if (this.isMessage()) {
                            sb.append("\n");
                            this.printChildContents(includeMatches, PairResult.indexed(fieldPrefix, this.actualFieldIndex()), sb);
                        } else {
                            sb.append(" ");
                            this.printFieldValue(this.fieldDescriptor(), this.actual().get(), sb);
                            sb.append("\n");
                        }
                        return;
                    }
                    case MOVED_OUT_OF_ORDER: {
                        sb.append("out_of_order: ").append(PairResult.indexed(fieldPrefix, this.expectedFieldIndex())).append(" -> ").append(PairResult.indexed(fieldPrefix, this.actualFieldIndex()));
                        sb.append(":");
                        if (this.isMessage()) {
                            sb.append("\n");
                            this.printChildContents(includeMatches, PairResult.indexed(fieldPrefix, this.actualFieldIndex()), sb);
                        } else {
                            sb.append(" ");
                            this.printFieldValue(this.fieldDescriptor(), this.actual().get(), sb);
                            sb.append("\n");
                        }
                        return;
                    }
                    case MODIFIED: {
                        sb.append("modified: ");
                        if (((Integer)this.actualFieldIndex().get()).equals(this.expectedFieldIndex().get())) {
                            sb.append(PairResult.indexed(fieldPrefix, this.actualFieldIndex()));
                        } else {
                            sb.append(PairResult.indexed(fieldPrefix, this.expectedFieldIndex())).append(" -> ").append(PairResult.indexed(fieldPrefix, this.actualFieldIndex()));
                        }
                        sb.append(":");
                        if (this.isMessage()) {
                            sb.append("\n");
                            this.printChildContents(includeMatches, PairResult.indexed(fieldPrefix, this.actualFieldIndex()), sb);
                        } else {
                            sb.append(" ");
                            this.printFieldValue(this.fieldDescriptor(), this.expected().get(), sb);
                            sb.append(" -> ");
                            this.printFieldValue(this.fieldDescriptor(), this.actual().get(), sb);
                        }
                        return;
                    }
                    case REMOVED: {
                        sb.append("deleted: ").append(PairResult.indexed(fieldPrefix, this.expectedFieldIndex())).append(": ");
                        if (this.isMessage()) {
                            sb.append("\n");
                            this.printMessage((Message)this.expected().get(), sb);
                        } else {
                            this.printFieldValue(this.fieldDescriptor(), this.expected().get(), sb);
                            sb.append("\n");
                        }
                        return;
                    }
                }
                throw new AssertionError((Object)("Impossible: " + (Object)((Object)this.result())));
            }

            @Override
            final boolean isContentEmpty() {
                return false;
            }

            abstract Builder toBuilder();

            static Builder newBuilder() {
                return new $AutoValue_DiffResult_RepeatedField_PairResult.Builder();
            }

            @AutoValue.Builder
            static abstract class Builder {
                Builder() {
                }

                abstract Builder setResult(RecursableDiffEntity.WithResultCode.Result var1);

                abstract Builder setFieldDescriptor(Descriptors.FieldDescriptor var1);

                abstract Builder setActualFieldIndex(int var1);

                abstract Builder setExpectedFieldIndex(int var1);

                abstract Builder setActual(Object var1);

                abstract Builder setExpected(Object var1);

                abstract Builder setProtoPrinter(TextFormat.Printer var1);

                abstract Builder setBreakdown(DiffResult var1);

                abstract PairResult build();
            }
        }
    }

    @AutoValue
    static abstract class SingularField
    extends RecursableDiffEntity.WithResultCode
    implements ProtoPrintable {
        SingularField() {
        }

        abstract Optional<SubScopeId> subScopeId();

        abstract String fieldName();

        abstract Optional<Object> actual();

        abstract Optional<Object> expected();

        abstract Optional<DiffResult> breakdown();

        abstract Optional<UnknownFieldSetDiff> unknownsBreakdown();

        @Memoized
        Object actualOrExpected() {
            return this.actual().or(this.expected()).get();
        }

        @Override
        @Memoized
        Iterable<? extends RecursableDiffEntity> childEntities() {
            return ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)this.breakdown().asSet(), (Iterable)this.unknownsBreakdown().asSet()));
        }

        @Override
        final void printContents(boolean includeMatches, String fieldPrefix, StringBuilder sb) {
            if (!includeMatches && this.isMatched()) {
                return;
            }
            fieldPrefix = DiffResult.newFieldPrefix(fieldPrefix, this.fieldName());
            switch (this.result()) {
                case ADDED: {
                    sb.append("added: ").append(fieldPrefix).append(": ");
                    if (this.actual().get() instanceof Message) {
                        sb.append("\n");
                        this.printMessage((Message)this.actual().get(), sb);
                    } else {
                        this.printFieldValue((SubScopeId)this.subScopeId().get(), this.actual().get(), sb);
                        sb.append("\n");
                    }
                    return;
                }
                case IGNORED: {
                    sb.append("ignored: ").append(fieldPrefix).append("\n");
                    return;
                }
                case MATCHED: {
                    sb.append("matched: ").append(fieldPrefix);
                    if (this.actualOrExpected() instanceof Message) {
                        sb.append("\n");
                        this.printChildContents(includeMatches, fieldPrefix, sb);
                    } else {
                        sb.append(": ");
                        this.printFieldValue((SubScopeId)this.subScopeId().get(), this.actualOrExpected(), sb);
                        sb.append("\n");
                    }
                    return;
                }
                case MODIFIED: {
                    sb.append("modified: ").append(fieldPrefix);
                    if (this.actualOrExpected() instanceof Message) {
                        sb.append("\n");
                        this.printChildContents(includeMatches, fieldPrefix, sb);
                    } else {
                        sb.append(": ");
                        this.printFieldValue((SubScopeId)this.subScopeId().get(), this.expected().get(), sb);
                        sb.append(" -> ");
                        this.printFieldValue((SubScopeId)this.subScopeId().get(), this.actual().get(), sb);
                        sb.append("\n");
                    }
                    return;
                }
                case REMOVED: {
                    sb.append("deleted: ").append(fieldPrefix).append(": ");
                    if (this.expected().get() instanceof Message) {
                        sb.append("\n");
                        this.printMessage((Message)this.expected().get(), sb);
                    } else {
                        this.printFieldValue((SubScopeId)this.subScopeId().get(), this.expected().get(), sb);
                        sb.append("\n");
                    }
                    return;
                }
            }
            throw new AssertionError((Object)("Impossible: " + (Object)((Object)this.result())));
        }

        @Override
        final boolean isContentEmpty() {
            return false;
        }

        static SingularField ignored(String fieldName) {
            return SingularField.newBuilder().setFieldName(fieldName).setResult(RecursableDiffEntity.WithResultCode.Result.IGNORED).setProtoPrinter(TextFormat.printer()).build();
        }

        static Builder newBuilder() {
            return new $AutoValue_DiffResult_SingularField.Builder();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setResult(RecursableDiffEntity.WithResultCode.Result var1);

            abstract Builder setSubScopeId(SubScopeId var1);

            abstract Builder setFieldName(String var1);

            abstract Builder setActual(Object var1);

            abstract Builder setExpected(Object var1);

            abstract Builder setBreakdown(DiffResult var1);

            abstract Builder setUnknownsBreakdown(UnknownFieldSetDiff var1);

            abstract Builder setProtoPrinter(TextFormat.Printer var1);

            abstract SingularField build();
        }
    }
}

