/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.extensions.proto.DiffResult;
import com.google.common.truth.extensions.proto.FieldScope;
import com.google.common.truth.extensions.proto.FieldScopeUtil;
import com.google.common.truth.extensions.proto.FluentEqualityConfig;
import com.google.common.truth.extensions.proto.LiteProtoSubject;
import com.google.common.truth.extensions.proto.ProtoFluentAssertion;
import com.google.common.truth.extensions.proto.ProtoTruthMessageDifferencer;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.TypeRegistry;
import java.util.Arrays;
import org.jspecify.annotations.Nullable;

public class ProtoSubject
extends LiteProtoSubject {
    private final FailureMetadata metadata;
    private final Message actual;
    private final FluentEqualityConfig config;

    protected ProtoSubject(FailureMetadata failureMetadata, @Nullable Message message) {
        this(failureMetadata, FluentEqualityConfig.defaultInstance(), message);
    }

    ProtoSubject(FailureMetadata failureMetadata, FluentEqualityConfig config, @Nullable Message message) {
        super(failureMetadata, (MessageLite)message);
        this.metadata = failureMetadata;
        this.actual = message;
        this.config = config;
    }

    ProtoFluentAssertionImpl usingConfig(FluentEqualityConfig newConfig) {
        return new ProtoFluentAssertionImpl(new ProtoSubject(this.metadata, newConfig, this.actual));
    }

    public ProtoFluentAssertion ignoringFieldAbsence() {
        return this.usingConfig(this.config.ignoringFieldAbsence());
    }

    public ProtoFluentAssertion ignoringFieldAbsenceOfFields(int firstFieldNumber, int ... rest) {
        return this.usingConfig(this.config.ignoringFieldAbsenceOfFields(FieldScopeUtil.asList(firstFieldNumber, rest)));
    }

    public ProtoFluentAssertion ignoringFieldAbsenceOfFields(Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.ignoringFieldAbsenceOfFields(fieldNumbers));
    }

    public ProtoFluentAssertion ignoringFieldAbsenceOfFieldDescriptors(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.usingConfig(this.config.ignoringFieldAbsenceOfFieldDescriptors(Lists.asList((Object)firstFieldDescriptor, (Object[])rest)));
    }

    public ProtoFluentAssertion ignoringFieldAbsenceOfFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.ignoringFieldAbsenceOfFieldDescriptors(fieldDescriptors));
    }

    public ProtoFluentAssertion ignoringRepeatedFieldOrder() {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrder());
    }

    public ProtoFluentAssertion ignoringRepeatedFieldOrderOfFields(int firstFieldNumber, int ... rest) {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrderOfFields(FieldScopeUtil.asList(firstFieldNumber, rest)));
    }

    public ProtoFluentAssertion ignoringRepeatedFieldOrderOfFields(Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrderOfFields(fieldNumbers));
    }

    public ProtoFluentAssertion ignoringRepeatedFieldOrderOfFieldDescriptors(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrderOfFieldDescriptors(Lists.asList((Object)firstFieldDescriptor, (Object[])rest)));
    }

    public ProtoFluentAssertion ignoringRepeatedFieldOrderOfFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrderOfFieldDescriptors(fieldDescriptors));
    }

    public ProtoFluentAssertion ignoringExtraRepeatedFieldElements() {
        return this.usingConfig(this.config.ignoringExtraRepeatedFieldElements());
    }

    public ProtoFluentAssertion ignoringExtraRepeatedFieldElementsOfFields(int firstFieldNumber, int ... rest) {
        return this.usingConfig(this.config.ignoringExtraRepeatedFieldElementsOfFields(FieldScopeUtil.asList(firstFieldNumber, rest)));
    }

    public ProtoFluentAssertion ignoringExtraRepeatedFieldElementsOfFields(Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.ignoringExtraRepeatedFieldElementsOfFields(fieldNumbers));
    }

    public ProtoFluentAssertion ignoringExtraRepeatedFieldElementsOfFieldDescriptors(Descriptors.FieldDescriptor first, Descriptors.FieldDescriptor ... rest) {
        return this.usingConfig(this.config.ignoringExtraRepeatedFieldElementsOfFieldDescriptors(Lists.asList((Object)first, (Object[])rest)));
    }

    public ProtoFluentAssertion ignoringExtraRepeatedFieldElementsOfFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.ignoringExtraRepeatedFieldElementsOfFieldDescriptors(fieldDescriptors));
    }

    public ProtoFluentAssertion usingDoubleTolerance(double tolerance) {
        return this.usingConfig(this.config.usingDoubleTolerance(tolerance));
    }

    public ProtoFluentAssertion usingDoubleToleranceForFields(double tolerance, int firstFieldNumber, int ... rest) {
        return this.usingConfig(this.config.usingDoubleToleranceForFields(tolerance, FieldScopeUtil.asList(firstFieldNumber, rest)));
    }

    public ProtoFluentAssertion usingDoubleToleranceForFields(double tolerance, Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.usingDoubleToleranceForFields(tolerance, fieldNumbers));
    }

    public ProtoFluentAssertion usingDoubleToleranceForFieldDescriptors(double tolerance, Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.usingConfig(this.config.usingDoubleToleranceForFieldDescriptors(tolerance, Lists.asList((Object)firstFieldDescriptor, (Object[])rest)));
    }

    public ProtoFluentAssertion usingDoubleToleranceForFieldDescriptors(double tolerance, Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.usingDoubleToleranceForFieldDescriptors(tolerance, fieldDescriptors));
    }

    public ProtoFluentAssertion usingFloatTolerance(float tolerance) {
        return this.usingConfig(this.config.usingFloatTolerance(tolerance));
    }

    public ProtoFluentAssertion usingFloatToleranceForFields(float tolerance, int firstFieldNumber, int ... rest) {
        return this.usingConfig(this.config.usingFloatToleranceForFields(tolerance, FieldScopeUtil.asList(firstFieldNumber, rest)));
    }

    public ProtoFluentAssertion usingFloatToleranceForFields(float tolerance, Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.usingFloatToleranceForFields(tolerance, fieldNumbers));
    }

    public ProtoFluentAssertion usingFloatToleranceForFieldDescriptors(float tolerance, Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.usingConfig(this.config.usingFloatToleranceForFieldDescriptors(tolerance, Lists.asList((Object)firstFieldDescriptor, (Object[])rest)));
    }

    public ProtoFluentAssertion usingFloatToleranceForFieldDescriptors(float tolerance, Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.usingFloatToleranceForFieldDescriptors(tolerance, fieldDescriptors));
    }

    public ProtoFluentAssertion comparingExpectedFieldsOnly() {
        return this.usingConfig(this.config.comparingExpectedFieldsOnly());
    }

    public ProtoFluentAssertion withPartialScope(FieldScope fieldScope) {
        return this.usingConfig(this.config.withPartialScope((FieldScope)Preconditions.checkNotNull((Object)fieldScope, (Object)"fieldScope")));
    }

    public ProtoFluentAssertion ignoringFields(int firstFieldNumber, int ... rest) {
        return this.ignoringFields(FieldScopeUtil.asList(firstFieldNumber, rest));
    }

    public ProtoFluentAssertion ignoringFields(Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.ignoringFields(fieldNumbers));
    }

    public ProtoFluentAssertion ignoringFieldDescriptors(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.ignoringFieldDescriptors(Lists.asList((Object)firstFieldDescriptor, (Object[])rest));
    }

    public ProtoFluentAssertion ignoringFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.ignoringFieldDescriptors(fieldDescriptors));
    }

    public ProtoFluentAssertion ignoringFieldScope(FieldScope fieldScope) {
        return this.usingConfig(this.config.ignoringFieldScope((FieldScope)Preconditions.checkNotNull((Object)fieldScope, (Object)"fieldScope")));
    }

    public ProtoFluentAssertion reportingMismatchesOnly() {
        return this.usingConfig(this.config.reportingMismatchesOnly());
    }

    public ProtoFluentAssertion unpackingAnyUsing(TypeRegistry typeRegistry, ExtensionRegistry extensionRegistry) {
        return this.usingConfig(this.config.unpackingAnyUsing(typeRegistry, extensionRegistry));
    }

    private static boolean sameClassMessagesWithDifferentDescriptors(@Nullable Message actual, @Nullable Object expected) {
        if (actual == null || !(expected instanceof Message) || actual.getClass() != expected.getClass()) {
            return false;
        }
        return actual.getDescriptorForType() != ((Message)expected).getDescriptorForType();
    }

    private static boolean notMessagesWithSameDescriptor(@Nullable Message actual, @Nullable Object expected) {
        if (actual != null && expected instanceof Message) {
            return actual.getDescriptorForType() != ((Message)expected).getDescriptorForType();
        }
        return true;
    }

    public void isEqualTo(@Nullable Object expected) {
        if (ProtoSubject.sameClassMessagesWithDifferentDescriptors(this.actual, expected)) {
            this.failWithoutActual(Fact.simpleFact((String)"Not true that messages compare equal; they have different descriptors."), new Fact[]{Fact.fact((String)"expected", (Object)expected), Fact.fact((String)"with descriptor", (Object)((Message)expected).getDescriptorForType()), Fact.fact((String)"but was", (Object)this.actual), Fact.fact((String)"with descriptor", (Object)this.actual.getDescriptorForType())});
        } else if (ProtoSubject.notMessagesWithSameDescriptor(this.actual, expected)) {
            super.isEqualTo(expected);
        } else {
            DiffResult diffResult = this.makeDifferencer((Message)expected).diffMessages(this.actual, (Message)expected);
            if (!diffResult.isMatched()) {
                this.failWithoutActual(Fact.simpleFact((String)("Not true that messages compare equal.\n" + diffResult.printToString(this.config.reportMismatchesOnly()))), new Fact[0]);
            }
        }
    }

    public void isNotEqualTo(@Nullable Object expected) {
        if (ProtoSubject.notMessagesWithSameDescriptor(this.actual, expected)) {
            super.isNotEqualTo(expected);
        } else {
            DiffResult diffResult = this.makeDifferencer((Message)expected).diffMessages(this.actual, (Message)expected);
            if (diffResult.isMatched()) {
                this.failWithoutActual(Fact.simpleFact((String)("Not true that messages compare not equal.\n" + diffResult.printToString(this.config.reportMismatchesOnly()))), new Fact[0]);
            }
        }
    }

    public void hasAllRequiredFields() {
        if (!this.actual.isInitialized()) {
            this.failWithoutActual(Fact.simpleFact((String)"expected to have all required fields set"), new Fact[]{Fact.fact((String)"but was missing", (Object)this.actual.findInitializationErrors()), Fact.fact((String)"proto was", (Object)this.actualCustomStringRepresentationForProtoPackageMembersToCall())});
        }
    }

    private ProtoTruthMessageDifferencer makeDifferencer(Message expected) {
        return this.config.withExpectedMessages(Arrays.asList(expected)).toMessageDifferencer(this.actual.getDescriptorForType());
    }

    static final class ProtoFluentAssertionImpl
    implements ProtoFluentAssertion {
        private final ProtoSubject protoSubject;

        ProtoFluentAssertionImpl(ProtoSubject protoSubject) {
            this.protoSubject = protoSubject;
        }

        @Override
        public ProtoFluentAssertion ignoringFieldAbsence() {
            return this.protoSubject.ignoringFieldAbsence();
        }

        @Override
        public ProtoFluentAssertion ignoringFieldAbsenceOfFields(int firstFieldNumber, int ... rest) {
            return this.protoSubject.ignoringFieldAbsenceOfFields(firstFieldNumber, rest);
        }

        @Override
        public ProtoFluentAssertion ignoringFieldAbsenceOfFields(Iterable<Integer> fieldNumbers) {
            return this.protoSubject.ignoringFieldAbsenceOfFields(fieldNumbers);
        }

        @Override
        public ProtoFluentAssertion ignoringFieldAbsenceOfFieldDescriptors(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.protoSubject.ignoringFieldAbsenceOfFieldDescriptors(firstFieldDescriptor, rest);
        }

        @Override
        public ProtoFluentAssertion ignoringFieldAbsenceOfFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.protoSubject.ignoringFieldAbsenceOfFieldDescriptors(fieldDescriptors);
        }

        @Override
        public ProtoFluentAssertion ignoringRepeatedFieldOrder() {
            return this.protoSubject.ignoringRepeatedFieldOrder();
        }

        @Override
        public ProtoFluentAssertion ignoringRepeatedFieldOrderOfFields(int firstFieldNumber, int ... rest) {
            return this.protoSubject.ignoringRepeatedFieldOrderOfFields(firstFieldNumber, rest);
        }

        @Override
        public ProtoFluentAssertion ignoringRepeatedFieldOrderOfFields(Iterable<Integer> fieldNumbers) {
            return this.protoSubject.ignoringRepeatedFieldOrderOfFields(fieldNumbers);
        }

        @Override
        public ProtoFluentAssertion ignoringRepeatedFieldOrderOfFieldDescriptors(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.protoSubject.ignoringRepeatedFieldOrderOfFieldDescriptors(firstFieldDescriptor, rest);
        }

        @Override
        public ProtoFluentAssertion ignoringRepeatedFieldOrderOfFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.protoSubject.ignoringRepeatedFieldOrderOfFieldDescriptors(fieldDescriptors);
        }

        @Override
        public ProtoFluentAssertion ignoringExtraRepeatedFieldElements() {
            return this.protoSubject.ignoringExtraRepeatedFieldElements();
        }

        @Override
        public ProtoFluentAssertion ignoringExtraRepeatedFieldElementsOfFields(int firstFieldNumber, int ... rest) {
            return this.protoSubject.ignoringExtraRepeatedFieldElementsOfFields(firstFieldNumber, rest);
        }

        @Override
        public ProtoFluentAssertion ignoringExtraRepeatedFieldElementsOfFields(Iterable<Integer> fieldNumbers) {
            return this.protoSubject.ignoringExtraRepeatedFieldElementsOfFields(fieldNumbers);
        }

        @Override
        public ProtoFluentAssertion ignoringExtraRepeatedFieldElementsOfFieldDescriptors(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.protoSubject.ignoringExtraRepeatedFieldElementsOfFieldDescriptors(firstFieldDescriptor, rest);
        }

        @Override
        public ProtoFluentAssertion ignoringExtraRepeatedFieldElementsOfFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.protoSubject.ignoringExtraRepeatedFieldElementsOfFieldDescriptors(fieldDescriptors);
        }

        @Override
        public ProtoFluentAssertion usingDoubleTolerance(double tolerance) {
            return this.protoSubject.usingDoubleTolerance(tolerance);
        }

        @Override
        public ProtoFluentAssertion usingDoubleToleranceForFields(double tolerance, int firstFieldNumber, int ... rest) {
            return this.protoSubject.usingDoubleToleranceForFields(tolerance, firstFieldNumber, rest);
        }

        @Override
        public ProtoFluentAssertion usingDoubleToleranceForFields(double tolerance, Iterable<Integer> fieldNumbers) {
            return this.protoSubject.usingDoubleToleranceForFields(tolerance, fieldNumbers);
        }

        @Override
        public ProtoFluentAssertion usingDoubleToleranceForFieldDescriptors(double tolerance, Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.protoSubject.usingDoubleToleranceForFieldDescriptors(tolerance, firstFieldDescriptor, rest);
        }

        @Override
        public ProtoFluentAssertion usingDoubleToleranceForFieldDescriptors(double tolerance, Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.protoSubject.usingDoubleToleranceForFieldDescriptors(tolerance, fieldDescriptors);
        }

        @Override
        public ProtoFluentAssertion usingFloatTolerance(float tolerance) {
            return this.protoSubject.usingFloatTolerance(tolerance);
        }

        @Override
        public ProtoFluentAssertion usingFloatToleranceForFields(float tolerance, int firstFieldNumber, int ... rest) {
            return this.protoSubject.usingFloatToleranceForFields(tolerance, firstFieldNumber, rest);
        }

        @Override
        public ProtoFluentAssertion usingFloatToleranceForFields(float tolerance, Iterable<Integer> fieldNumbers) {
            return this.protoSubject.usingFloatToleranceForFields(tolerance, fieldNumbers);
        }

        @Override
        public ProtoFluentAssertion usingFloatToleranceForFieldDescriptors(float tolerance, Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.protoSubject.usingFloatToleranceForFieldDescriptors(tolerance, firstFieldDescriptor, rest);
        }

        @Override
        public ProtoFluentAssertion usingFloatToleranceForFieldDescriptors(float tolerance, Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.protoSubject.usingFloatToleranceForFieldDescriptors(tolerance, fieldDescriptors);
        }

        @Override
        public ProtoFluentAssertion comparingExpectedFieldsOnly() {
            return this.protoSubject.comparingExpectedFieldsOnly();
        }

        @Override
        public ProtoFluentAssertion withPartialScope(FieldScope fieldScope) {
            return this.protoSubject.withPartialScope(fieldScope);
        }

        @Override
        public ProtoFluentAssertion ignoringFields(int firstFieldNumber, int ... rest) {
            return this.protoSubject.ignoringFields(firstFieldNumber, rest);
        }

        @Override
        public ProtoFluentAssertion ignoringFields(Iterable<Integer> fieldNumbers) {
            return this.protoSubject.ignoringFields(fieldNumbers);
        }

        @Override
        public ProtoFluentAssertion ignoringFieldDescriptors(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.protoSubject.ignoringFieldDescriptors(firstFieldDescriptor, rest);
        }

        @Override
        public ProtoFluentAssertion ignoringFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.protoSubject.ignoringFieldDescriptors(fieldDescriptors);
        }

        @Override
        public ProtoFluentAssertion ignoringFieldScope(FieldScope fieldScope) {
            return this.protoSubject.ignoringFieldScope(fieldScope);
        }

        @Override
        public ProtoFluentAssertion reportingMismatchesOnly() {
            return this.protoSubject.reportingMismatchesOnly();
        }

        @Override
        public ProtoFluentAssertion unpackingAnyUsing(TypeRegistry typeRegistry, ExtensionRegistry extensionRegistry) {
            return this.protoSubject.unpackingAnyUsing(typeRegistry, extensionRegistry);
        }

        @Override
        public void isEqualTo(@Nullable Message expected) {
            this.protoSubject.isEqualTo(expected);
        }

        @Override
        public void isNotEqualTo(@Nullable Message expected) {
            this.protoSubject.isNotEqualTo(expected);
        }

        boolean testIsEqualTo(@Nullable Message expected) {
            if (ProtoSubject.notMessagesWithSameDescriptor(this.protoSubject.actual, expected)) {
                return Objects.equal((Object)this.protoSubject.actual, (Object)expected);
            }
            return this.protoSubject.makeDifferencer(expected).diffMessages(this.protoSubject.actual, expected).isMatched();
        }
    }
}

