/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.truth.AbstractVerb;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import javax.annotation.Nullable;

public final class SimpleSubjectBuilder<SubjectT extends Subject<SubjectT, ActualT>, ActualT>
extends AbstractVerb.DelegatedVerb<SubjectT, ActualT> {
    private final FailureStrategy failureStrategy;
    private final SubjectFactory<SubjectT, ActualT> subjectFactory;

    SimpleSubjectBuilder(FailureStrategy failureStrategy, SubjectFactory<SubjectT, ActualT> subjectFactory) {
        super(failureStrategy, subjectFactory);
        this.failureStrategy = (FailureStrategy)Preconditions.checkNotNull((Object)failureStrategy);
        this.subjectFactory = (SubjectFactory)Preconditions.checkNotNull(subjectFactory);
    }

    @Override
    public SubjectT that(@Nullable ActualT actual) {
        return this.subjectFactory.getSubject(this.failureStrategy, actual);
    }
}

