/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Table;
import com.google.common.truth.AtomicLongMapSubject;
import com.google.common.truth.BigDecimalSubject;
import com.google.common.truth.BooleanSubject;
import com.google.common.truth.ClassSubject;
import com.google.common.truth.ComparableSubject;
import com.google.common.truth.CustomSubjectBuilder;
import com.google.common.truth.CustomSubjectBuilderFactory;
import com.google.common.truth.DefaultSubject;
import com.google.common.truth.DoubleSubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.FloatSubject;
import com.google.common.truth.GuavaOptionalSubject;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.ListMultimapSubject;
import com.google.common.truth.LongSubject;
import com.google.common.truth.MapSubject;
import com.google.common.truth.MultimapSubject;
import com.google.common.truth.MultisetSubject;
import com.google.common.truth.ObjectArraySubject;
import com.google.common.truth.PrimitiveBooleanArraySubject;
import com.google.common.truth.PrimitiveByteArraySubject;
import com.google.common.truth.PrimitiveCharArraySubject;
import com.google.common.truth.PrimitiveDoubleArraySubject;
import com.google.common.truth.PrimitiveFloatArraySubject;
import com.google.common.truth.PrimitiveIntArraySubject;
import com.google.common.truth.PrimitiveLongArraySubject;
import com.google.common.truth.PrimitiveShortArraySubject;
import com.google.common.truth.SetMultimapSubject;
import com.google.common.truth.SimpleSubjectBuilder;
import com.google.common.truth.SortedMapSubject;
import com.google.common.truth.SortedSetSubject;
import com.google.common.truth.StringSubject;
import com.google.common.truth.StringUtil;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import com.google.common.truth.TableSubject;
import com.google.common.truth.TestVerb;
import com.google.common.truth.ThrowableSubject;
import com.google.common.util.concurrent.AtomicLongMap;
import java.math.BigDecimal;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.annotation.Nullable;

public class StandardSubjectBuilder
extends TestVerb {
    private final FailureStrategy failureStrategyDoNotReferenceDirectly;

    public static StandardSubjectBuilder forCustomFailureStrategy(FailureStrategy failureStrategy) {
        return new StandardSubjectBuilder(failureStrategy);
    }

    StandardSubjectBuilder(FailureStrategy failureStrategy) {
        super(failureStrategy);
        this.failureStrategyDoNotReferenceDirectly = (FailureStrategy)Preconditions.checkNotNull((Object)failureStrategy);
    }

    @Override
    public final <T extends Comparable<?>> ComparableSubject<?, T> that(@Nullable T target) {
        return new ComparableSubject(this.failureStrategy(), target){};
    }

    @Override
    public final BigDecimalSubject that(@Nullable BigDecimal target) {
        return new BigDecimalSubject(this.failureStrategy(), target);
    }

    @Override
    public final Subject<DefaultSubject, Object> that(@Nullable Object target) {
        return new DefaultSubject(this.failureStrategy(), target);
    }

    @Override
    @GwtIncompatible(value="ClassSubject.java")
    public final ClassSubject that(@Nullable Class<?> target) {
        return new ClassSubject(this.failureStrategy(), target);
    }

    @Override
    public final ThrowableSubject that(@Nullable Throwable target) {
        return ThrowableSubject.create(this.failureStrategy(), target);
    }

    @Override
    public final LongSubject that(@Nullable Long target) {
        return new LongSubject(this.failureStrategy(), target);
    }

    @Override
    public final DoubleSubject that(@Nullable Double target) {
        return new DoubleSubject(this.failureStrategy(), target);
    }

    @Override
    public final FloatSubject that(@Nullable Float target) {
        return new FloatSubject(this.failureStrategy(), target);
    }

    @Override
    public final IntegerSubject that(@Nullable Integer target) {
        return new IntegerSubject(this.failureStrategy(), target);
    }

    @Override
    public final BooleanSubject that(@Nullable Boolean target) {
        return new BooleanSubject(this.failureStrategy(), target);
    }

    @Override
    public final StringSubject that(@Nullable String target) {
        return new StringSubject(this.failureStrategy(), target);
    }

    @Override
    public final IterableSubject that(@Nullable Iterable<?> target) {
        return new IterableSubject(this.failureStrategy(), target);
    }

    @Override
    public final SortedSetSubject that(@Nullable SortedSet<?> target) {
        return new SortedSetSubject(this.failureStrategy(), target);
    }

    @Override
    public final <T> ObjectArraySubject<T> that(@Nullable T[] target) {
        return new ObjectArraySubject<T>(this.failureStrategy(), target);
    }

    @Override
    public final PrimitiveBooleanArraySubject that(@Nullable boolean[] target) {
        return new PrimitiveBooleanArraySubject(this.failureStrategy(), target);
    }

    @Override
    public final PrimitiveShortArraySubject that(@Nullable short[] target) {
        return new PrimitiveShortArraySubject(this.failureStrategy(), target);
    }

    @Override
    public final PrimitiveIntArraySubject that(@Nullable int[] target) {
        return new PrimitiveIntArraySubject(this.failureStrategy(), target);
    }

    @Override
    public final PrimitiveLongArraySubject that(@Nullable long[] target) {
        return new PrimitiveLongArraySubject(this.failureStrategy(), target);
    }

    @Override
    public final PrimitiveCharArraySubject that(@Nullable char[] target) {
        return new PrimitiveCharArraySubject(this.failureStrategy(), target);
    }

    @Override
    public final PrimitiveByteArraySubject that(@Nullable byte[] target) {
        return new PrimitiveByteArraySubject(this.failureStrategy(), target);
    }

    @Override
    public final PrimitiveFloatArraySubject that(@Nullable float[] target) {
        return new PrimitiveFloatArraySubject(this.failureStrategy(), target);
    }

    @Override
    public final PrimitiveDoubleArraySubject that(@Nullable double[] target) {
        return new PrimitiveDoubleArraySubject(this.failureStrategy(), target);
    }

    @Override
    public final GuavaOptionalSubject that(@Nullable Optional<?> target) {
        return new GuavaOptionalSubject(this.failureStrategy(), target);
    }

    @Override
    public final MapSubject that(@Nullable Map<?, ?> target) {
        return new MapSubject(this.failureStrategy(), target);
    }

    @Override
    public final SortedMapSubject that(@Nullable SortedMap<?, ?> target) {
        return new SortedMapSubject(this.failureStrategy(), target);
    }

    @Override
    public final MultimapSubject that(@Nullable Multimap<?, ?> target) {
        return new MultimapSubject(this.failureStrategy(), target);
    }

    @Override
    public final ListMultimapSubject that(@Nullable ListMultimap<?, ?> target) {
        return new ListMultimapSubject(this.failureStrategy(), target);
    }

    @Override
    public final SetMultimapSubject that(@Nullable SetMultimap<?, ?> target) {
        return new SetMultimapSubject(this.failureStrategy(), target);
    }

    @Override
    public final MultisetSubject that(@Nullable Multiset<?> target) {
        return new MultisetSubject(this.failureStrategy(), target);
    }

    @Override
    public final TableSubject that(@Nullable Table<?, ?, ?> target) {
        return new TableSubject(this.failureStrategy(), target);
    }

    @Override
    public final AtomicLongMapSubject that(@Nullable AtomicLongMap<?> target) {
        return new AtomicLongMapSubject(this.failureStrategy(), target);
    }

    @Override
    public final StandardSubjectBuilder withMessage(@Nullable String messageToPrepend) {
        return this.withMessage("%s", messageToPrepend);
    }

    @Override
    public final StandardSubjectBuilder withMessage(@Nullable String format, Object ... args) {
        return new StandardSubjectBuilder(new MessagePrependingFailureStrategy(this.failureStrategy(), format, args));
    }

    @Override
    public final <S extends Subject<S, A>, A, SF extends SubjectFactory<S, A>> SimpleSubjectBuilder<S, A> about(SF factory) {
        return new SimpleSubjectBuilder(this.failureStrategy(), factory);
    }

    @Override
    public final <CustomSubjectBuilderT extends CustomSubjectBuilder> CustomSubjectBuilderT about(CustomSubjectBuilderFactory<CustomSubjectBuilderT> factory) {
        return factory.createSubjectBuilder(this.failureStrategy());
    }

    @Override
    public final void fail() {
        this.failureStrategy().fail("");
    }

    @Override
    public final void fail(@Nullable String format, Object ... args) {
        this.failureStrategy().fail(StringUtil.format(format, args));
    }

    private FailureStrategy failureStrategy() {
        this.checkStatePreconditions();
        return this.failureStrategyDoNotReferenceDirectly;
    }

    void checkStatePreconditions() {
    }

    @VisibleForTesting
    static int countPlaceholders(@Nullable String template) {
        if (template == null) {
            return 0;
        }
        int index = 0;
        int count = 0;
        while ((index = template.indexOf("%s", index)) != -1) {
            ++index;
            ++count;
        }
        return count;
    }

    private static final class MessagePrependingFailureStrategy
    extends FailureStrategy {
        private static final String PLACEHOLDER_ERR = "Incorrect number of args (%s) for the given placeholders (%s) in string template:\"%s\"";
        private final FailureStrategy delegate;
        private final String format;
        private final Object[] args;

        MessagePrependingFailureStrategy(FailureStrategy delegate, @Nullable String format, Object ... args) {
            this.delegate = (FailureStrategy)Preconditions.checkNotNull((Object)delegate);
            this.format = format;
            this.args = args;
            int placeholders = StandardSubjectBuilder.countPlaceholders(format);
            Preconditions.checkArgument((placeholders == args.length ? 1 : 0) != 0, (String)PLACEHOLDER_ERR, (Object)args.length, (Object)placeholders, (Object)format);
        }

        @Override
        public void fail(String message) {
            this.delegate.fail(this.prependFailureMessageIfAny(message));
        }

        @Override
        public void fail(String message, Throwable cause) {
            this.delegate.fail(this.prependFailureMessageIfAny(message), cause);
        }

        @Override
        public void failComparing(String message, CharSequence expected, CharSequence actual) {
            this.delegate.failComparing(this.prependFailureMessageIfAny(message), expected, actual);
        }

        @Override
        public void failComparing(String message, CharSequence expected, CharSequence actual, Throwable cause) {
            this.delegate.failComparing(this.prependFailureMessageIfAny(message), expected, actual, cause);
        }

        private String prependFailureMessageIfAny(String message) {
            return this.format == null ? message : StringUtil.format(this.format, this.args) + ": " + message;
        }
    }
}

