/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.tsunami.common.ErrorCode;

public class TsunamiException
extends RuntimeException {
    private final ErrorCode errorCode;

    public TsunamiException() {
        this(ErrorCode.UNKNOWN);
    }

    public TsunamiException(ErrorCode errorCode) {
        this(errorCode, null);
    }

    public TsunamiException(ErrorCode errorCode, String message) {
        this(errorCode, message, null);
    }

    public TsunamiException(ErrorCode errorCode, String message, Throwable cause) {
        super(TsunamiException.buildExceptionMessage((ErrorCode)((Object)Preconditions.checkNotNull((Object)((Object)errorCode))), message), cause);
        this.errorCode = errorCode;
    }

    private static String buildExceptionMessage(ErrorCode errorCode, String message) {
        StringBuilder exceptionMessageBuilder = new StringBuilder();
        exceptionMessageBuilder.append("(Tsunami error ").append((Object)errorCode).append(")");
        if (!Strings.isNullOrEmpty((String)message)) {
            exceptionMessageBuilder.append(": ").append(message);
        }
        return exceptionMessageBuilder.toString();
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }
}

