/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Provider;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class BaseThreadPoolModule<ExecutorServiceT extends ListeningExecutorService>
extends AbstractModule {
    private final ThreadFactory factory;
    private final int maxSize;
    private final int coreSize;
    private final long keepAliveSeconds;
    private final @Nullable Duration shutdownDelay;
    private final Key<ExecutorServiceT> key;
    private final Class<ExecutorServiceT> executorServiceTypeClass;
    private final RejectedExecutionHandler rejectedExecutionHandler;

    BaseThreadPoolModule(BaseThreadPoolModuleBuilder<ExecutorServiceT, ?> builder) {
        Preconditions.checkNotNull(builder);
        this.factory = builder.factoryBuilder.build();
        this.maxSize = builder.maxSize;
        this.coreSize = builder.coreSize;
        this.keepAliveSeconds = builder.keepAliveSeconds;
        this.shutdownDelay = builder.daemon ? builder.shutdownDelay : null;
        this.key = builder.key;
        this.executorServiceTypeClass = builder.executorServiceTypeClass;
        this.rejectedExecutionHandler = builder.rejectedExecutionHandler;
    }

    protected final void configure() {
        this.configureThreadPool(this.key);
    }

    abstract void configureThreadPool(Key<ExecutorServiceT> var1);

    static abstract class BaseThreadPoolModuleBuilder<ExecutorServiceT extends ListeningExecutorService, BuilderImplT extends BaseThreadPoolModuleBuilder<ExecutorServiceT, BuilderImplT>> {
        protected final ThreadFactoryBuilder factoryBuilder = new ThreadFactoryBuilder();
        protected String name;
        protected int maxSize;
        protected int coreSize;
        protected long keepAliveSeconds = 60L;
        protected boolean daemon;
        protected Duration shutdownDelay;
        protected Key<ExecutorServiceT> key;
        protected final Class<ExecutorServiceT> executorServiceTypeClass;
        protected RejectedExecutionHandler rejectedExecutionHandler = new ThreadPoolExecutor.AbortPolicy();

        BaseThreadPoolModuleBuilder(Class<ExecutorServiceT> executorServiceTypeClass) {
            this.executorServiceTypeClass = (Class)Preconditions.checkNotNull(executorServiceTypeClass);
        }

        abstract BuilderImplT self();

        public BuilderImplT setName(String name) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Name should not be empty");
            this.name = name;
            return this.self();
        }

        BuilderImplT setMaxSize(int maxSize) {
            Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0, (Object)"Max thread pool size should be positive.");
            this.maxSize = maxSize;
            return this.self();
        }

        BuilderImplT setCoreSize(int coreSize) {
            Preconditions.checkArgument((coreSize >= 0 ? 1 : 0) != 0, (Object)"The core pool size should be non-negative.");
            this.coreSize = coreSize;
            return this.self();
        }

        public BuilderImplT setKeepAliveSeconds(long keepAliveSeconds) {
            Preconditions.checkArgument((keepAliveSeconds >= 0L ? 1 : 0) != 0, (Object)"The keep alive time should be non-negative.");
            this.keepAliveSeconds = keepAliveSeconds;
            return this.self();
        }

        public BuilderImplT setDaemon(boolean daemon) {
            this.factoryBuilder.setDaemon(daemon);
            this.daemon = daemon;
            return this.self();
        }

        public BuilderImplT setDelayedShutdown(Duration shutdownDelay) {
            this.shutdownDelay = (Duration)Preconditions.checkNotNull((Object)shutdownDelay);
            return this.self();
        }

        public BuilderImplT setPriority(int priority) {
            this.factoryBuilder.setPriority(priority);
            return this.self();
        }

        public BuilderImplT setAnnotation(Annotation annotation) {
            this.key = Key.get(this.executorServiceTypeClass, (Annotation)((Annotation)Preconditions.checkNotNull((Object)annotation)));
            return this.self();
        }

        public BuilderImplT setAnnotation(Class<? extends Annotation> annotationClass) {
            this.key = Key.get(this.executorServiceTypeClass, (Class)((Class)Preconditions.checkNotNull(annotationClass)));
            return this.self();
        }

        public BuilderImplT setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
            this.rejectedExecutionHandler = (RejectedExecutionHandler)Preconditions.checkNotNull((Object)rejectedExecutionHandler);
            return this.self();
        }

        final void validateAll() {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.name) ? 1 : 0) != 0, (Object)"Name is required.");
            Preconditions.checkState((this.maxSize > 0 ? 1 : 0) != 0, (Object)"Max thread pool size must be positive. Did you forget setting maximum thread pool size by calling setMaxSize?");
            Preconditions.checkState((this.coreSize <= this.maxSize ? 1 : 0) != 0, (Object)"Thread pool core size should be less than or equal to max size.");
            Preconditions.checkState((this.key != null ? 1 : 0) != 0, (Object)"Annotation is required.");
            this.validate();
        }

        abstract void validate();

        public final AbstractModule build() {
            this.validateAll();
            return this.newModule();
        }

        abstract AbstractModule newModule();
    }

    abstract class BaseThreadPoolProvider
    implements Provider<ExecutorServiceT> {
        BaseThreadPoolProvider() {
        }

        abstract ExecutorService createThreadPool(int var1, int var2, long var3, ThreadFactory var5, RejectedExecutionHandler var6);

        public final ExecutorServiceT get() {
            ExecutorService service = this.createThreadPool(BaseThreadPoolModule.this.coreSize, BaseThreadPoolModule.this.maxSize, BaseThreadPoolModule.this.keepAliveSeconds, BaseThreadPoolModule.this.factory, BaseThreadPoolModule.this.rejectedExecutionHandler);
            if (BaseThreadPoolModule.this.shutdownDelay != null) {
                MoreExecutors.addDelayedShutdownHook((ExecutorService)service, (long)BaseThreadPoolModule.this.shutdownDelay.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
            }
            return (ListeningExecutorService)BaseThreadPoolModule.this.executorServiceTypeClass.cast(MoreExecutors.listeningDecorator((ExecutorService)service));
        }
    }
}

