/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.inject.Key;
import com.google.tsunami.common.concurrent.BaseThreadPoolModule;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.inject.Provider;
import javax.inject.Singleton;

public final class ScheduledThreadPoolModule
extends BaseThreadPoolModule<ListeningScheduledExecutorService> {
    ScheduledThreadPoolModule(Builder builder) {
        super(builder);
    }

    @Override
    void configureThreadPool(Key<ListeningScheduledExecutorService> key) {
        this.bind(key.ofType(ScheduledExecutorService.class)).to(key);
        this.bind(key).toProvider((Provider)new ScheduledThreadPoolProvider(this)).in(Singleton.class);
    }

    public static final class Builder
    extends BaseThreadPoolModule.BaseThreadPoolModuleBuilder<ListeningScheduledExecutorService, Builder> {
        public Builder() {
            super(ListeningScheduledExecutorService.class);
        }

        @Override
        Builder self() {
            return this;
        }

        public Builder setSize(int size) {
            Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"Thread pool size should be positive.");
            this.setCoreSize(size);
            this.setMaxSize(size);
            return this;
        }

        @Override
        void validate() {
        }

        @Override
        ScheduledThreadPoolModule newModule() {
            return new ScheduledThreadPoolModule(this);
        }
    }

    private final class ScheduledThreadPoolProvider
    extends BaseThreadPoolModule.BaseThreadPoolProvider {
        private ScheduledThreadPoolProvider(ScheduledThreadPoolModule scheduledThreadPoolModule) {
        }

        @Override
        ScheduledThreadPoolExecutor createThreadPool(int coreSize, int maxSize, long keepAliveSeconds, ThreadFactory factory, RejectedExecutionHandler rejectedExecutionHandler) {
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(coreSize, factory, rejectedExecutionHandler);
            scheduledThreadPoolExecutor.setMaximumPoolSize(maxSize);
            scheduledThreadPoolExecutor.setKeepAliveTime(keepAliveSeconds, TimeUnit.SECONDS);
            return scheduledThreadPoolExecutor;
        }
    }
}

