/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Key;
import com.google.inject.Singleton;
import com.google.tsunami.common.concurrent.BaseThreadPoolModule;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Provider;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ThreadPoolModule
extends BaseThreadPoolModule<ListeningExecutorService> {
    private final BlockingQueue<Runnable> blockingQueue;

    private ThreadPoolModule(Builder builder) {
        super((BaseThreadPoolModule.BaseThreadPoolModuleBuilder)Preconditions.checkNotNull((Object)builder));
        this.blockingQueue = builder.getBlockingQueue();
    }

    @Override
    void configureThreadPool(Key<ListeningExecutorService> key) {
        this.bind(key.ofType(Executor.class)).to(key);
        this.bind(key.ofType(ExecutorService.class)).to(key);
        this.bind(key).toProvider((Provider)new ThreadPoolProvider()).in(Singleton.class);
    }

    public static final class Builder
    extends BaseThreadPoolModule.BaseThreadPoolModuleBuilder<ListeningExecutorService, Builder> {
        private int queueCapacity = Integer.MAX_VALUE;
        private @Nullable BlockingQueue<Runnable> blockingQueue;

        public Builder() {
            super(ListeningExecutorService.class);
        }

        @Override
        Builder self() {
            return this;
        }

        @Override
        public Builder setMaxSize(int maxSize) {
            return (Builder)super.setMaxSize(maxSize);
        }

        @Override
        public Builder setCoreSize(int coreSize) {
            return (Builder)super.setCoreSize(coreSize);
        }

        public Builder setQueueCapacity(int queueCapacity) {
            Preconditions.checkArgument((queueCapacity >= 0 ? 1 : 0) != 0, (Object)"The queue capacity should be non-negative value.");
            this.queueCapacity = queueCapacity;
            return this;
        }

        public Builder setBlockingQueue(BlockingQueue<Runnable> blockingQueue) {
            this.blockingQueue = (BlockingQueue)Preconditions.checkNotNull(blockingQueue);
            return this;
        }

        private BlockingQueue<Runnable> getBlockingQueue() {
            if (this.blockingQueue == null) {
                return this.queueCapacity == 0 ? new SynchronousQueue() : new LinkedBlockingQueue(this.queueCapacity);
            }
            return this.blockingQueue;
        }

        private boolean isBoundedQueue() {
            return (this.blockingQueue == null ? this.queueCapacity : this.blockingQueue.remainingCapacity()) < Integer.MAX_VALUE;
        }

        @Override
        void validate() {
            Preconditions.checkState((this.blockingQueue == null || this.queueCapacity == Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"Both custom BlockingQueue and queue capacity are specified.");
            if (this.coreSize < this.maxSize) {
                Preconditions.checkState((boolean)this.isBoundedQueue(), (Object)"Finite capacity queue should be set when the core pool size is less than max pool size. ThreadPoolExecutor will only create new threads past core size when the queue is full.");
            }
        }

        @Override
        ThreadPoolModule newModule() {
            return new ThreadPoolModule(this);
        }
    }

    private final class ThreadPoolProvider
    extends BaseThreadPoolModule.BaseThreadPoolProvider {
        private ThreadPoolProvider() {
            super(ThreadPoolModule.this);
        }

        @Override
        ThreadPoolExecutor createThreadPool(int coreSize, int maxSize, long keepAliveSeconds, ThreadFactory factory, RejectedExecutionHandler rejectedExecutionHandler) {
            return new ThreadPoolExecutor(coreSize, maxSize, keepAliveSeconds, TimeUnit.SECONDS, ThreadPoolModule.this.blockingQueue, factory, rejectedExecutionHandler);
        }
    }
}

