/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.io.archiving.testing;

import com.google.common.collect.Maps;
import com.google.common.truth.Truth;
import com.google.tsunami.common.io.archiving.Archiver;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class FakeArchiver
implements Archiver {
    private final Map<String, byte[]> archivedByteArrayData = Maps.newHashMap();
    private final Map<String, CharSequence> archivedCharSequenceData = Maps.newHashMap();
    private boolean shouldFail = false;

    @Override
    public boolean archive(String name, byte[] data) {
        if (this.shouldFail) {
            return false;
        }
        this.archivedByteArrayData.put(name, data);
        return true;
    }

    @Override
    public boolean archive(String name, CharSequence data) {
        if (this.shouldFail) {
            return false;
        }
        this.archivedCharSequenceData.put(name, data);
        return true;
    }

    public void failArchival() {
        this.shouldFail = true;
    }

    public byte[] getStoredByteArrays(String name) {
        if (!this.archivedByteArrayData.containsKey(name)) {
            throw new NoSuchElementException(String.format("'%s' not found in FakeArchiver", name));
        }
        return this.archivedByteArrayData.get(name);
    }

    public CharSequence getStoredCharSequence(String name) {
        if (!this.archivedCharSequenceData.containsKey(name)) {
            throw new NoSuchElementException(String.format("'%s' not found in FakeArchiver", name));
        }
        return this.archivedCharSequenceData.get(name);
    }

    public void assertNoByteArraysStored() {
        Truth.assertThat(this.archivedByteArrayData).isEmpty();
    }

    public void assertNoCharSequencesStored() {
        Truth.assertThat(this.archivedCharSequenceData).isEmpty();
    }

    public void assertNoDataStored() {
        this.assertNoByteArraysStored();
        this.assertNoCharSequencesStored();
    }

    public void assertByteArraysStored(Map<String, byte[]> expectedData) {
        Truth.assertThat(this.archivedByteArrayData).containsExactlyEntriesIn(expectedData);
    }

    public void assertByteArraysStoredForNames(Set<String> expectedNames) {
        Truth.assertThat(this.archivedByteArrayData.keySet()).containsExactlyElementsIn(expectedNames);
    }

    public void assertByteArraysStoredWithValues(Collection<byte[]> expectedValues) {
        Truth.assertThat(this.archivedByteArrayData.values()).containsExactlyElementsIn(expectedValues);
    }

    public void assertCharSequencesStored(Map<String, CharSequence> expectedData) {
        Truth.assertThat(this.archivedCharSequenceData).containsExactlyEntriesIn(expectedData);
    }

    public void assertCharSequencesStoredForNames(Set<String> expectedNames) {
        Truth.assertThat(this.archivedCharSequenceData.keySet()).containsExactlyElementsIn(expectedNames);
    }

    public void assertCharSequencesStoredWithValues(Collection<CharSequence> expectedValues) {
        Truth.assertThat(this.archivedCharSequenceData.values()).containsExactlyElementsIn(expectedValues);
    }
}

