/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.io.archiving.testing;

import com.google.cloud.storage.Storage;
import com.google.tsunami.common.io.archiving.GoogleCloudStorageArchiver;
import com.google.tsunami.common.io.archiving.testing.FakeArchiver;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public final class FakeGoogleCloudStorageArchivers {
    private final Map<Storage, FakeArchiver> delegatedArchivers = new HashMap<Storage, FakeArchiver>();

    public void assertNoDataStored() {
        for (FakeArchiver delegate : this.delegatedArchivers.values()) {
            delegate.assertNoDataStored();
        }
    }

    public byte[] getStoredByteArrays(Storage storage, String gcsUrl) {
        if (!this.delegatedArchivers.containsKey(storage)) {
            throw new NoSuchElementException(String.format("Storage '%s' not found", storage));
        }
        return this.delegatedArchivers.get(storage).getStoredByteArrays(gcsUrl);
    }

    public CharSequence getStoredCharSequence(Storage storage, String gcsUrl) {
        if (!this.delegatedArchivers.containsKey(storage)) {
            throw new NoSuchElementException(String.format("Storage '%s' not found", storage));
        }
        return this.delegatedArchivers.get(storage).getStoredCharSequence(gcsUrl);
    }

    final class FakeFactory
    implements GoogleCloudStorageArchiver.Factory {
        FakeFactory() {
        }

        @Override
        public GoogleCloudStorageArchiver create(Storage storage) {
            return new FakeGoogleCloudStorageArchiver(storage);
        }
    }

    final class FakeGoogleCloudStorageArchiver
    extends GoogleCloudStorageArchiver {
        private final Storage storage;

        private FakeGoogleCloudStorageArchiver(Storage storage) {
            super(new GoogleCloudStorageArchiver.Options(), storage);
            this.storage = storage;
        }

        @Override
        public boolean archive(String gcsUrl, byte[] data) {
            FakeArchiver fakeArchiver = FakeGoogleCloudStorageArchivers.this.delegatedArchivers.computeIfAbsent(this.storage, unused -> new FakeArchiver());
            return fakeArchiver.archive(gcsUrl, data);
        }

        @Override
        public boolean archive(String gcsUrl, CharSequence data) {
            FakeArchiver fakeArchiver = FakeGoogleCloudStorageArchivers.this.delegatedArchivers.computeIfAbsent(this.storage, unused -> new FakeArchiver());
            return fakeArchiver.archive(gcsUrl, data);
        }
    }
}

