/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.net.http;

import com.google.protobuf.ByteString;
import com.google.tsunami.common.net.http.HttpHeaders;
import com.google.tsunami.common.net.http.HttpMethod;
import com.google.tsunami.common.net.http.HttpRequest;
import java.util.Optional;

final class AutoValue_HttpRequest
extends HttpRequest {
    private final HttpMethod method;
    private final String url;
    private final HttpHeaders headers;
    private final Optional<ByteString> requestBody;

    private AutoValue_HttpRequest(HttpMethod method, String url, HttpHeaders headers, Optional<ByteString> requestBody) {
        this.method = method;
        this.url = url;
        this.headers = headers;
        this.requestBody = requestBody;
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public Optional<ByteString> requestBody() {
        return this.requestBody;
    }

    public String toString() {
        return "HttpRequest{method=" + String.valueOf((Object)this.method) + ", url=" + this.url + ", headers=" + String.valueOf(this.headers) + ", requestBody=" + String.valueOf(this.requestBody) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpRequest) {
            HttpRequest that = (HttpRequest)o;
            return this.method.equals((Object)that.method()) && this.url.equals(that.url()) && this.headers.equals(that.headers()) && this.requestBody.equals(that.requestBody());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.method.hashCode();
        h$ *= 1000003;
        h$ ^= this.url.hashCode();
        h$ *= 1000003;
        h$ ^= this.headers.hashCode();
        h$ *= 1000003;
        return h$ ^= this.requestBody.hashCode();
    }

    static final class Builder
    extends HttpRequest.Builder {
        private HttpMethod method;
        private String url;
        private HttpHeaders headers;
        private Optional<ByteString> requestBody = Optional.empty();

        Builder() {
        }

        @Override
        public HttpRequest.Builder setMethod(HttpMethod method) {
            if (method == null) {
                throw new NullPointerException("Null method");
            }
            this.method = method;
            return this;
        }

        @Override
        public HttpRequest.Builder setUrl(String url) {
            if (url == null) {
                throw new NullPointerException("Null url");
            }
            this.url = url;
            return this;
        }

        @Override
        public HttpRequest.Builder setHeaders(HttpHeaders headers) {
            if (headers == null) {
                throw new NullPointerException("Null headers");
            }
            this.headers = headers;
            return this;
        }

        @Override
        public HttpRequest.Builder setRequestBody(ByteString requestBody) {
            this.requestBody = Optional.of(requestBody);
            return this;
        }

        @Override
        public HttpRequest.Builder setRequestBody(Optional<ByteString> requestBody) {
            if (requestBody == null) {
                throw new NullPointerException("Null requestBody");
            }
            this.requestBody = requestBody;
            return this;
        }

        @Override
        HttpRequest autoBuild() {
            if (this.method == null || this.url == null || this.headers == null) {
                StringBuilder missing = new StringBuilder();
                if (this.method == null) {
                    missing.append(" method");
                }
                if (this.url == null) {
                    missing.append(" url");
                }
                if (this.headers == null) {
                    missing.append(" headers");
                }
                throw new IllegalStateException("Missing required properties:" + String.valueOf(missing));
            }
            return new AutoValue_HttpRequest(this.method, this.url, this.headers, this.requestBody);
        }
    }
}

