/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.net.http;

import com.google.auto.value.AutoValue;
import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.tsunami.common.net.http.AutoValue_HttpHeaders;
import java.lang.reflect.Field;
import java.util.Optional;

@Immutable
@AutoValue
public abstract class HttpHeaders {
    private static final ImmutableBiMap<String, String> LOWER_TO_KNOWN = HttpHeaders.createKnownHeaders();
    private static final ImmutableSet<String> KNOWN = LOWER_TO_KNOWN.values();

    private static String canonicalize(String headerName) {
        if (KNOWN.contains((Object)headerName)) {
            return headerName;
        }
        String lower = Ascii.toLowerCase((String)headerName);
        String known = (String)LOWER_TO_KNOWN.get((Object)lower);
        return (String)MoreObjects.firstNonNull((Object)known, (Object)lower);
    }

    private static ImmutableBiMap<String, String> createKnownHeaders() {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        HttpHeaders.addFields((ImmutableBiMap.Builder<String, String>)builder, com.google.common.net.HttpHeaders.class);
        return builder.build();
    }

    private static void addFields(ImmutableBiMap.Builder<String, String> builder, Class<?> clazz) {
        try {
            for (Field field : clazz.getFields()) {
                if (!field.getType().equals(String.class)) continue;
                String known = (String)field.get(null);
                String lower = Ascii.toLowerCase((String)known);
                builder.put((Object)lower, (Object)known);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    abstract ImmutableListMultimap<String, String> rawHeaders();

    public ImmutableSet<String> names() {
        return this.rawHeaders().keySet();
    }

    public Optional<String> get(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null.");
        ImmutableList<String> values = this.getAll(name);
        return values.isEmpty() ? Optional.empty() : Optional.of((String)values.get(0));
    }

    public ImmutableList<String> getAll(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null.");
        ImmutableList values = this.rawHeaders().get((Object)name);
        if (!values.isEmpty()) {
            return values;
        }
        String fixedName = HttpHeaders.canonicalize(name);
        if (fixedName.equals(name)) {
            return values;
        }
        return this.rawHeaders().get((Object)fixedName);
    }

    public static Builder builder() {
        return new AutoValue_HttpHeaders.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        private static final CharMatcher HEADER_NAME_MATCHER = CharMatcher.inRange((char)'!', (char)'~').and(CharMatcher.isNot((char)':'));
        private static final CharMatcher HEADER_VALUE_MATCHER = CharMatcher.inRange((char)'\u0000', (char)'\u001f').or(CharMatcher.is((char)'\u007f')).negate().or(CharMatcher.is((char)'\t'));

        abstract ImmutableListMultimap.Builder<String, String> rawHeadersBuilder();

        public Builder addHeader(String name, String value) {
            Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null.");
            Preconditions.checkNotNull((Object)value, (Object)"Value cannot be null.");
            Preconditions.checkArgument((boolean)Builder.isLegalHeaderName(name), (String)"Illegal header name %s", (Object)name);
            Preconditions.checkArgument((boolean)Builder.isLegalHeaderValue(value), (String)"Illegal header value %s", (Object)value);
            this.rawHeadersBuilder().put((Object)HttpHeaders.canonicalize(name), (Object)value);
            return this;
        }

        public Builder addHeader(String name, String value, boolean canonicalize) {
            Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null.");
            Preconditions.checkNotNull((Object)value, (Object)"Value cannot be null.");
            if (canonicalize) {
                return this.addHeader(name, value);
            }
            this.rawHeadersBuilder().put((Object)name, (Object)value);
            return this;
        }

        public abstract HttpHeaders build();

        private static boolean isLegalHeaderName(String str) {
            return HEADER_NAME_MATCHER.matchesAllOf((CharSequence)str);
        }

        private static boolean isLegalHeaderValue(String value) {
            return HEADER_VALUE_MATCHER.matchesAllOf((CharSequence)value);
        }
    }
}

