/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.version;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.tsunami.common.version.$AutoValue_Version;
import com.google.tsunami.common.version.ComparisonUtility;
import com.google.tsunami.common.version.Segment;
import java.util.Arrays;
import java.util.regex.Pattern;

@Immutable
@AutoValue
public abstract class Version
implements Comparable<Version> {
    private static final Pattern EPOCH_PATTERN = Pattern.compile("\\d+[:|_].*");
    private static final Pattern SEMANTIC_SEGMENT_SEPARATORS = Pattern.compile("[-:_~]");
    private static final Version MAXIMUM = Version.builder().setVersionType(Type.MAXIMUM).setVersionString("").build();
    private static final Version MINIMUM = Version.builder().setVersionType(Type.MINIMUM).setVersionString("").build();

    abstract Type versionType();

    public abstract String versionString();

    @Memoized
    ImmutableList<Segment> segments() {
        Object normalizedString = this.versionString();
        if (!EPOCH_PATTERN.matcher((CharSequence)normalizedString).matches()) {
            normalizedString = "0:" + (String)normalizedString;
        }
        return (ImmutableList)Arrays.stream(SEMANTIC_SEGMENT_SEPARATORS.split((CharSequence)normalizedString)).filter(segment -> !segment.isEmpty()).map(Segment::fromString).filter(segment -> !segment.equals(Segment.NULL)).collect(ImmutableList.toImmutableList());
    }

    public static Builder builder() {
        return new $AutoValue_Version.Builder();
    }

    public static Version fromString(String versionString) {
        boolean isValid;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)versionString) ? 1 : 0) != 0);
        Version version = Version.builder().setVersionType(Type.NORMAL).setVersionString((String)versionString).build();
        if (!EPOCH_PATTERN.matcher((CharSequence)versionString).matches()) {
            versionString = "0:" + (String)versionString;
        }
        if (!(isValid = version.segments().stream().flatMap(segment -> segment.tokens().stream()).anyMatch(token -> token.isNumeric() && token.getNumeric() != 0L || token.isText() && !token.getText().isEmpty()))) {
            throw new IllegalArgumentException(String.format("Input version string %s is not valid, it should contain at least one non-empty field.", versionString));
        }
        return version;
    }

    public static Version maximum() {
        return MAXIMUM;
    }

    public boolean isMaximum() {
        return this.versionType().equals((Object)Type.MAXIMUM);
    }

    public static Version minimum() {
        return MINIMUM;
    }

    public boolean isMinimum() {
        return this.versionType().equals((Object)Type.MINIMUM);
    }

    @Override
    public int compareTo(Version other) {
        if (this.isMinimum() && other.isMinimum() || this.isMaximum() && other.isMaximum()) {
            return 0;
        }
        if (this.isMinimum() || other.isMaximum()) {
            return -1;
        }
        if (this.isMaximum() || other.isMinimum()) {
            return 1;
        }
        return ComparisonUtility.compareListWithFillValue(this.segments(), other.segments(), Segment.NULL);
    }

    public boolean isLessThan(Version version) {
        return this.compareTo(version) < 0;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setVersionType(Type var1);

        public abstract Builder setVersionString(String var1);

        public abstract Version build();
    }

    public static enum Type {
        NORMAL,
        MINIMUM,
        MAXIMUM;

    }
}

