/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import com.google.inject.AbstractModule;
import com.google.tsunami.common.cli.CliOption;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Constructor;

public final class CliOptionsModule
extends AbstractModule {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final String CLI_OPTION_INTERFACE = "com.google.tsunami.common.cli.CliOption";
    private final ScanResult scanResult;
    private final String[] args;
    private final JCommander jCommander;

    public CliOptionsModule(ScanResult scanResult, String programName, String[] args) {
        this.scanResult = (ScanResult)Preconditions.checkNotNull((Object)scanResult);
        this.args = (String[])Preconditions.checkNotNull((Object)args);
        this.jCommander = new JCommander();
        this.jCommander.setProgramName(programName);
    }

    protected void configure() {
        ImmutableList.Builder cliOptions = ImmutableList.builder();
        for (ClassInfo classInfo2 : this.scanResult.getClassesImplementing(CLI_OPTION_INTERFACE).filter(classInfo -> !classInfo.isInterface())) {
            ((GoogleLogger.Api)logger.atInfo()).log("Found CliOption: %s", (Object)classInfo2.getName());
            CliOption cliOption = (CliOption)this.bindCliOption(classInfo2.loadClass(CliOption.class));
            this.jCommander.addObject((Object)cliOption);
            cliOptions.add((Object)cliOption);
        }
        try {
            this.jCommander.parse(this.args);
            cliOptions.build().forEach(CliOption::validate);
        }
        catch (ParameterException e) {
            this.jCommander.usage();
            throw e;
        }
    }

    private <T> T bindCliOption(Class<T> cliOptionClass) {
        try {
            Constructor<T> cliOptionCtor = cliOptionClass.getDeclaredConstructor(new Class[0]);
            cliOptionCtor.setAccessible(true);
            T cliOption = cliOptionCtor.newInstance(new Object[0]);
            this.bind(cliOptionClass).toInstance(cliOption);
            return cliOption;
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError(String.format("CliOption '%s' must be constructable via a no-argument constructor", cliOptionClass.getTypeName()), e);
        }
    }
}

