/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.command;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;

public class CommandExecutor {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final Joiner COMMAND_ARGS_JOINER = Joiner.on((String)" ");
    private final ProcessBuilder processBuilder;
    private final String[] args;
    private Process process;
    @Nullable
    private String output;
    @Nullable
    private String error;

    public CommandExecutor(String ... args) {
        this.args = (String[])Preconditions.checkNotNull((Object)args);
        this.processBuilder = new ProcessBuilder(args);
    }

    @VisibleForTesting
    Process execute() throws IOException, InterruptedException, ExecutionException {
        ExecutorService executor = Executors.newCachedThreadPool();
        return this.execute(executor);
    }

    public Process execute(Executor executor) throws IOException, InterruptedException, ExecutionException {
        ((GoogleLogger.Api)logger.atInfo()).log("Executing the following command: '%s'", (Object)COMMAND_ARGS_JOINER.join((Object[])this.args));
        this.process = this.processBuilder.start();
        this.output = CompletableFuture.supplyAsync(() -> CommandExecutor.collectStream(this.process.getInputStream()), executor).get();
        this.error = CompletableFuture.supplyAsync(() -> CommandExecutor.collectStream(this.process.getErrorStream()), executor).get();
        return this.process;
    }

    @Nullable
    public String getOutput() {
        return this.output;
    }

    @Nullable
    public String getError() {
        return this.error;
    }

    private static String collectStream(InputStream stream) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String output;
            BufferedReader streamReader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            while ((output = streamReader.readLine()) != null) {
                stringBuilder.append(output);
                stringBuilder.append("\n");
            }
        }
        catch (IOException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause((Throwable)e)).log("Error collecting output stream from command execution.");
        }
        return stringBuilder.toString();
    }
}

