/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.data;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.tsunami.common.data.NetworkEndpointUtils;
import com.google.tsunami.proto.NetworkService;
import java.util.Optional;

public final class NetworkServiceUtils {
    private static final ImmutableMap<String, Boolean> IS_PLAIN_HTTP_BY_KNOWN_WEB_SERVICE_NAME = ImmutableMap.builder().put((Object)"http", (Object)true).put((Object)"http-alt", (Object)true).put((Object)"http-proxy", (Object)true).put((Object)"https", (Object)false).put((Object)"radan-http", (Object)true).put((Object)"ssl/http", (Object)false).put((Object)"ssl/https", (Object)false).build();

    private NetworkServiceUtils() {
    }

    public static boolean isWebService(Optional<String> serviceName) {
        return serviceName.isPresent() && IS_PLAIN_HTTP_BY_KNOWN_WEB_SERVICE_NAME.containsKey((Object)Ascii.toLowerCase((String)serviceName.get()));
    }

    public static boolean isWebService(NetworkService networkService) {
        Preconditions.checkNotNull((Object)networkService);
        return NetworkServiceUtils.isWebService(Optional.of(networkService.getServiceName()));
    }

    public static boolean isPlainHttp(NetworkService networkService) {
        Preconditions.checkNotNull((Object)networkService);
        return NetworkServiceUtils.isWebService(networkService) && (Boolean)IS_PLAIN_HTTP_BY_KNOWN_WEB_SERVICE_NAME.getOrDefault((Object)Ascii.toLowerCase((String)networkService.getServiceName()), (Object)false) != false;
    }

    public static String getServiceName(NetworkService networkService) {
        if (NetworkServiceUtils.isWebService(networkService) && networkService.hasSoftware()) {
            return Ascii.toLowerCase((String)networkService.getSoftware().getName());
        }
        return Ascii.toLowerCase((String)networkService.getServiceName());
    }

    public static String buildWebApplicationRootUrl(NetworkService networkService) {
        Preconditions.checkNotNull((Object)networkService);
        Preconditions.checkArgument((boolean)NetworkServiceUtils.isWebService(networkService));
        String string = NetworkServiceUtils.isPlainHttp(networkService) ? "http://" : "https://";
        String string2 = NetworkServiceUtils.buildWebUriAuthority(networkService);
        String string3 = NetworkServiceUtils.buildWebAppRootPath(networkService);
        String rootUrl = new StringBuilder(String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(string2).append(string3).toString();
        return rootUrl.endsWith("/") ? rootUrl : String.valueOf(rootUrl).concat("/");
    }

    private static String buildWebAppRootPath(NetworkService networkService) {
        String rootPath;
        String string = rootPath = networkService.getServiceContext().hasWebServiceContext() ? networkService.getServiceContext().getWebServiceContext().getApplicationRoot() : "/";
        if (!rootPath.startsWith("/")) {
            String string2 = String.valueOf(rootPath);
            rootPath = string2.length() != 0 ? "/".concat(string2) : new String("/");
        }
        return rootPath;
    }

    private static String buildWebUriAuthority(NetworkService networkService) {
        String uriAuthority = NetworkEndpointUtils.toUriAuthority(networkService.getNetworkEndpoint());
        boolean isPlainHttp = NetworkServiceUtils.isPlainHttp(networkService);
        if (isPlainHttp && uriAuthority.endsWith(":80")) {
            uriAuthority = uriAuthority.substring(0, uriAuthority.lastIndexOf(":80"));
        }
        if (!isPlainHttp && uriAuthority.endsWith(":443")) {
            uriAuthority = uriAuthority.substring(0, uriAuthority.lastIndexOf(":443"));
        }
        return uriAuthority;
    }
}

