/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.net;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import okhttp3.HttpUrl;

public final class UrlUtils {
    private static final Joiner PATH_JOINER = Joiner.on((String)"/");
    private static final Pattern SLASH_PREFIX_PATTERN = Pattern.compile("^/+");
    private static final Pattern TRAILING_SLASH_PATTERN = Pattern.compile("/+$");

    public static ImmutableSet<HttpUrl> allSubPaths(String url) {
        return UrlUtils.allSubPaths(HttpUrl.parse((String)url));
    }

    public static ImmutableSet<HttpUrl> allSubPaths(HttpUrl url) {
        if (url == null) {
            return ImmutableSet.of();
        }
        List pathSegments = url.encodedPathSegments();
        if (pathSegments.size() == 1 && ((String)pathSegments.get(0)).isEmpty()) {
            return ImmutableSet.of((Object)url.newBuilder().query(null).fragment(null).build());
        }
        ImmutableSet.Builder allSubUrlsBuilder = ImmutableSet.builder();
        for (int pathEnd = 0; pathEnd <= pathSegments.size(); ++pathEnd) {
            ArrayList subPathSegments = Lists.newArrayList(pathSegments.subList(0, pathEnd));
            if (subPathSegments.isEmpty() || !((String)subPathSegments.get(0)).isEmpty()) {
                subPathSegments.add(0, "");
            }
            if (subPathSegments.size() == 1 || !((String)Iterables.getLast((Iterable)subPathSegments)).isEmpty()) {
                subPathSegments.add("");
            }
            allSubUrlsBuilder.add((Object)url.newBuilder().encodedPath(PATH_JOINER.join((Iterable)subPathSegments)).query(null).fragment(null).build());
        }
        return allSubUrlsBuilder.build();
    }

    public static String removeLeadingSlashes(String path) {
        return SLASH_PREFIX_PATTERN.matcher(path).replaceFirst("");
    }

    public static String removeTrailingSlashes(String path) {
        return TRAILING_SLASH_PATTERN.matcher(path).replaceFirst("");
    }

    private UrlUtils() {
    }
}

