/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.net.http;

import com.google.protobuf.ByteString;
import com.google.tsunami.common.net.http.AutoValue_HttpResponse;
import com.google.tsunami.common.net.http.HttpHeaders;
import com.google.tsunami.common.net.http.HttpResponse;
import com.google.tsunami.common.net.http.HttpStatus;
import java.util.Optional;
import okhttp3.HttpUrl;

abstract class $AutoValue_HttpResponse
extends HttpResponse {
    private final HttpStatus status;
    private final HttpHeaders headers;
    private final Optional<ByteString> bodyBytes;
    private final Optional<HttpUrl> responseUrl;

    $AutoValue_HttpResponse(HttpStatus status, HttpHeaders headers, Optional<ByteString> bodyBytes, Optional<HttpUrl> responseUrl) {
        if (status == null) {
            throw new NullPointerException("Null status");
        }
        this.status = status;
        if (headers == null) {
            throw new NullPointerException("Null headers");
        }
        this.headers = headers;
        if (bodyBytes == null) {
            throw new NullPointerException("Null bodyBytes");
        }
        this.bodyBytes = bodyBytes;
        if (responseUrl == null) {
            throw new NullPointerException("Null responseUrl");
        }
        this.responseUrl = responseUrl;
    }

    @Override
    public HttpStatus status() {
        return this.status;
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public Optional<ByteString> bodyBytes() {
        return this.bodyBytes;
    }

    @Override
    public Optional<HttpUrl> responseUrl() {
        return this.responseUrl;
    }

    public String toString() {
        String string = String.valueOf((Object)this.status);
        String string2 = String.valueOf(this.headers);
        String string3 = String.valueOf(this.bodyBytes);
        String string4 = String.valueOf(this.responseUrl);
        return new StringBuilder(57 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("HttpResponse{status=").append(string).append(", headers=").append(string2).append(", bodyBytes=").append(string3).append(", responseUrl=").append(string4).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpResponse) {
            HttpResponse that = (HttpResponse)o;
            return this.status.equals((Object)that.status()) && this.headers.equals(that.headers()) && this.bodyBytes.equals(that.bodyBytes()) && this.responseUrl.equals(that.responseUrl());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.status.hashCode();
        h$ *= 1000003;
        h$ ^= this.headers.hashCode();
        h$ *= 1000003;
        h$ ^= this.bodyBytes.hashCode();
        h$ *= 1000003;
        return h$ ^= this.responseUrl.hashCode();
    }

    static class Builder
    extends HttpResponse.Builder {
        private HttpStatus status;
        private HttpHeaders headers;
        private Optional<ByteString> bodyBytes = Optional.empty();
        private Optional<HttpUrl> responseUrl = Optional.empty();

        Builder() {
        }

        @Override
        public HttpResponse.Builder setStatus(HttpStatus status) {
            if (status == null) {
                throw new NullPointerException("Null status");
            }
            this.status = status;
            return this;
        }

        @Override
        public HttpResponse.Builder setHeaders(HttpHeaders headers) {
            if (headers == null) {
                throw new NullPointerException("Null headers");
            }
            this.headers = headers;
            return this;
        }

        @Override
        public HttpResponse.Builder setBodyBytes(ByteString bodyBytes) {
            this.bodyBytes = Optional.of(bodyBytes);
            return this;
        }

        @Override
        public HttpResponse.Builder setBodyBytes(Optional<ByteString> bodyBytes) {
            if (bodyBytes == null) {
                throw new NullPointerException("Null bodyBytes");
            }
            this.bodyBytes = bodyBytes;
            return this;
        }

        @Override
        public HttpResponse.Builder setResponseUrl(HttpUrl responseUrl) {
            this.responseUrl = Optional.of(responseUrl);
            return this;
        }

        @Override
        public HttpResponse.Builder setResponseUrl(Optional<HttpUrl> responseUrl) {
            if (responseUrl == null) {
                throw new NullPointerException("Null responseUrl");
            }
            this.responseUrl = responseUrl;
            return this;
        }

        @Override
        public HttpResponse build() {
            String missing = "";
            if (this.status == null) {
                missing = String.valueOf(missing).concat(" status");
            }
            if (this.headers == null) {
                missing = String.valueOf(missing).concat(" headers");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_HttpResponse(this.status, this.headers, this.bodyBytes, this.responseUrl);
        }
    }
}

