/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.net.http;

import com.google.protobuf.ByteString;
import com.google.tsunami.common.net.http.HttpHeaders;
import com.google.tsunami.common.net.http.HttpMethod;
import com.google.tsunami.common.net.http.HttpRequest;
import java.util.Optional;

final class AutoValue_HttpRequest
extends HttpRequest {
    private final HttpMethod method;
    private final String url;
    private final HttpHeaders headers;
    private final Optional<ByteString> requestBody;

    private AutoValue_HttpRequest(HttpMethod method, String url, HttpHeaders headers, Optional<ByteString> requestBody) {
        this.method = method;
        this.url = url;
        this.headers = headers;
        this.requestBody = requestBody;
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public Optional<ByteString> requestBody() {
        return this.requestBody;
    }

    public String toString() {
        String string = String.valueOf((Object)this.method);
        String string2 = this.url;
        String string3 = String.valueOf(this.headers);
        String string4 = String.valueOf(this.requestBody);
        return new StringBuilder(50 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("HttpRequest{method=").append(string).append(", url=").append(string2).append(", headers=").append(string3).append(", requestBody=").append(string4).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpRequest) {
            HttpRequest that = (HttpRequest)o;
            return this.method.equals((Object)that.method()) && this.url.equals(that.url()) && this.headers.equals(that.headers()) && this.requestBody.equals(that.requestBody());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.method.hashCode();
        h$ *= 1000003;
        h$ ^= this.url.hashCode();
        h$ *= 1000003;
        h$ ^= this.headers.hashCode();
        h$ *= 1000003;
        return h$ ^= this.requestBody.hashCode();
    }

    static final class Builder
    extends HttpRequest.Builder {
        private HttpMethod method;
        private String url;
        private HttpHeaders headers;
        private Optional<ByteString> requestBody = Optional.empty();

        Builder() {
        }

        @Override
        public HttpRequest.Builder setMethod(HttpMethod method) {
            if (method == null) {
                throw new NullPointerException("Null method");
            }
            this.method = method;
            return this;
        }

        @Override
        public HttpRequest.Builder setUrl(String url) {
            if (url == null) {
                throw new NullPointerException("Null url");
            }
            this.url = url;
            return this;
        }

        @Override
        public HttpRequest.Builder setHeaders(HttpHeaders headers) {
            if (headers == null) {
                throw new NullPointerException("Null headers");
            }
            this.headers = headers;
            return this;
        }

        @Override
        public HttpRequest.Builder setRequestBody(ByteString requestBody) {
            this.requestBody = Optional.of(requestBody);
            return this;
        }

        @Override
        public HttpRequest.Builder setRequestBody(Optional<ByteString> requestBody) {
            if (requestBody == null) {
                throw new NullPointerException("Null requestBody");
            }
            this.requestBody = requestBody;
            return this;
        }

        @Override
        HttpRequest autoBuild() {
            String missing = "";
            if (this.method == null) {
                missing = String.valueOf(missing).concat(" method");
            }
            if (this.url == null) {
                missing = String.valueOf(missing).concat(" url");
            }
            if (this.headers == null) {
                missing = String.valueOf(missing).concat(" headers");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_HttpRequest(this.method, this.url, this.headers, this.requestBody);
        }
    }
}

