/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.net.http;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.flogger.GoogleLogger;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.ByteString;
import com.google.tsunami.common.net.http.HttpClientModule;
import com.google.tsunami.common.net.http.HttpHeaders;
import com.google.tsunami.common.net.http.HttpMethod;
import com.google.tsunami.common.net.http.HttpRequest;
import com.google.tsunami.common.net.http.HttpResponse;
import com.google.tsunami.common.net.http.HttpStatus;
import com.google.tsunami.common.net.http.javanet.ConnectionFactory;
import com.google.tsunami.proto.NetworkService;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.net.ssl.HttpsURLConnection;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dns;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class HttpClient {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final String TSUNAMI_USER_AGENT = "TsunamiSecurityScanner";
    private final OkHttpClient okHttpClient;
    private final boolean trustAllCertificates;
    private final ConnectionFactory connectionFactory;

    @Inject
    HttpClient(OkHttpClient okHttpClient, @HttpClientModule.TrustAllCertificates boolean trustAllCertificates, ConnectionFactory connectionFactory) {
        this.okHttpClient = (OkHttpClient)Preconditions.checkNotNull((Object)okHttpClient);
        this.trustAllCertificates = trustAllCertificates;
        this.connectionFactory = (ConnectionFactory)Preconditions.checkNotNull((Object)connectionFactory);
    }

    public HttpResponse sendAsIs(HttpRequest httpRequest) throws IOException {
        if (!httpRequest.method().equals((Object)HttpMethod.GET)) {
            throw new IllegalArgumentException("sendAsIs method should only be used for GET method.");
        }
        HttpURLConnection connection = this.connectionFactory.openConnection(httpRequest.url());
        connection.setRequestMethod(httpRequest.method().toString());
        httpRequest.headers().names().stream().filter(headerName -> !Ascii.equalsIgnoreCase((CharSequence)headerName, (CharSequence)"User-Agent")).forEach(headerName -> httpRequest.headers().getAll((String)headerName).forEach(headerValue -> connection.setRequestProperty((String)headerName, (String)headerValue)));
        connection.setRequestProperty("User-Agent", TSUNAMI_USER_AGENT);
        connection.connect();
        int responseCode = connection.getResponseCode();
        HttpHeaders.Builder responseHeadersBuilder = HttpHeaders.builder();
        for (Map.Entry<String, List<String>> headerEntry : connection.getHeaderFields().entrySet()) {
            String headerName2 = headerEntry.getKey();
            if (Strings.isNullOrEmpty((String)headerName2)) continue;
            for (String headerValue : headerEntry.getValue()) {
                if (Strings.isNullOrEmpty((String)headerValue)) continue;
                responseHeadersBuilder.addHeader(headerName2, headerValue);
            }
        }
        return HttpResponse.builder().setStatus(HttpStatus.fromCode(responseCode)).setHeaders(responseHeadersBuilder.build()).setBodyBytes(ByteString.readFrom((InputStream)connection.getInputStream())).build();
    }

    public HttpResponse send(HttpRequest httpRequest) throws IOException {
        return this.send(httpRequest, null);
    }

    public HttpResponse send(HttpRequest httpRequest, @Nullable NetworkService networkService) throws IOException {
        ((GoogleLogger.Api)logger.atInfo()).log("Sending HTTP '%s' request to '%s'.", (Object)httpRequest.method(), (Object)httpRequest.url());
        OkHttpClient callHttpClient = this.clientWithHostnameAsProxy(networkService);
        try (Response okHttpResponse = callHttpClient.newCall(HttpClient.buildOkHttpRequest(httpRequest)).execute();){
            HttpResponse httpResponse = HttpClient.parseResponse(okHttpResponse);
            return httpResponse;
        }
    }

    public ListenableFuture<HttpResponse> sendAsync(HttpRequest httpRequest) {
        return this.sendAsync(httpRequest, null);
    }

    public ListenableFuture<HttpResponse> sendAsync(HttpRequest httpRequest, @Nullable NetworkService networkService) {
        ((GoogleLogger.Api)logger.atInfo()).log("Sending async HTTP '%s' request to '%s'.", (Object)httpRequest.method(), (Object)httpRequest.url());
        OkHttpClient callHttpClient = this.clientWithHostnameAsProxy(networkService);
        final SettableFuture responseFuture = SettableFuture.create();
        Call requestCall = callHttpClient.newCall(HttpClient.buildOkHttpRequest(httpRequest));
        try {
            requestCall.enqueue(new Callback(this){

                public void onFailure(Call call, IOException e) {
                    responseFuture.setException((Throwable)e);
                }

                public void onResponse(Call call, Response response) {
                    try (ResponseBody unused = response.body();){
                        responseFuture.set((Object)HttpClient.parseResponse(response));
                    }
                    catch (Throwable t) {
                        responseFuture.setException(t);
                    }
                }
            });
        }
        catch (Throwable t) {
            responseFuture.setException(t);
        }
        responseFuture.addListener(() -> {
            if (responseFuture.isCancelled()) {
                requestCall.cancel();
            }
        }, MoreExecutors.directExecutor());
        return responseFuture;
    }

    private OkHttpClient clientWithHostnameAsProxy(NetworkService networkService) {
        if (networkService == null) {
            return this.okHttpClient;
        }
        String serviceIp = networkService.getNetworkEndpoint().getIpAddress().getAddress();
        String serviceHostname = networkService.getNetworkEndpoint().getHostname().getName();
        return this.okHttpClient.newBuilder().dns(hostname -> {
            if (hostname.equals(serviceHostname)) {
                hostname = serviceIp;
            }
            return Dns.SYSTEM.lookup(hostname);
        }).hostnameVerifier((hostname, session) -> {
            if (this.trustAllCertificates) {
                return true;
            }
            if (hostname.equals(serviceHostname)) {
                return true;
            }
            return HttpsURLConnection.getDefaultHostnameVerifier().verify(hostname, session);
        }).build();
    }

    private static Request buildOkHttpRequest(HttpRequest httpRequest) {
        Request.Builder okRequestBuilder = new Request.Builder().url(httpRequest.url());
        httpRequest.headers().names().stream().filter(headerName -> !Ascii.equalsIgnoreCase((CharSequence)headerName, (CharSequence)"User-Agent")).forEach(headerName -> httpRequest.headers().getAll((String)headerName).forEach(headerValue -> okRequestBuilder.addHeader(headerName, headerValue)));
        okRequestBuilder.addHeader("User-Agent", TSUNAMI_USER_AGENT);
        switch (httpRequest.method()) {
            case GET: {
                okRequestBuilder.get();
                break;
            }
            case HEAD: {
                okRequestBuilder.head();
                break;
            }
            case POST: {
                okRequestBuilder.post(HttpClient.buildRequestBody(httpRequest));
                break;
            }
            case DELETE: {
                okRequestBuilder.delete(HttpClient.buildRequestBody(httpRequest));
            }
        }
        return okRequestBuilder.build();
    }

    private static RequestBody buildRequestBody(HttpRequest httpRequest) {
        MediaType mediaType = MediaType.parse((String)httpRequest.headers().get("Content-Type").orElse(""));
        return RequestBody.create((MediaType)mediaType, (byte[])httpRequest.requestBody().orElse(ByteString.EMPTY).toByteArray());
    }

    private static HttpResponse parseResponse(Response okResponse) throws IOException {
        ((GoogleLogger.Api)logger.atInfo()).log("Received HTTP response with code '%d' for request to '%s'.", okResponse.code(), (Object)okResponse.request().url());
        HttpResponse.Builder httpResponseBuilder = HttpResponse.builder().setStatus(HttpStatus.fromCode(okResponse.code())).setHeaders(HttpClient.convertHeaders(okResponse.headers())).setResponseUrl(okResponse.request().url());
        if (!okResponse.request().method().equals(HttpMethod.HEAD.name()) && okResponse.body() != null) {
            httpResponseBuilder.setBodyBytes(ByteString.copyFrom((byte[])okResponse.body().bytes()));
        }
        return httpResponseBuilder.build();
    }

    private static HttpHeaders convertHeaders(Headers headers) {
        HttpHeaders.Builder headersBuilder = HttpHeaders.builder();
        for (int i = 0; i < headers.size(); ++i) {
            headersBuilder.addHeader(headers.name(i), headers.value(i));
        }
        return headersBuilder.build();
    }

    public Builder modify() {
        return new Builder(this);
    }

    public static class Builder {
        private final OkHttpClient okHttpClient;
        private boolean followRedirects;
        private boolean trustAllCertificates;
        private ConnectionFactory connectionFactory;

        private Builder(HttpClient httpClient) {
            this.okHttpClient = httpClient.okHttpClient;
            this.followRedirects = this.okHttpClient.followRedirects();
            this.trustAllCertificates = httpClient.trustAllCertificates;
            this.connectionFactory = httpClient.connectionFactory;
        }

        public Builder setFollowRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        public Builder setTrustAllCertificates(boolean trustAllCertificates) {
            this.trustAllCertificates = trustAllCertificates;
            return this;
        }

        public HttpClient build() {
            return new HttpClient(this.okHttpClient.newBuilder().followRedirects(this.followRedirects).build(), this.trustAllCertificates, this.connectionFactory);
        }
    }
}

