/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.net.http;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.google.tsunami.common.cli.CliOption;
import org.checkerframework.checker.nullness.qual.Nullable;

@Parameters(separators="=")
public final class HttpClientCliOptions
implements CliOption {
    @Parameter(names={"--http-client-trust-all-certificates"}, description="Whether the HTTP client should trust all certificates on HTTPS traffic.")
    Boolean trustAllCertificates;
    @Parameter(names={"--http-client-call-timeout-seconds"}, description="The timeout in seconds for complete HTTP calls. See https://square.github.io/okhttp/4.x/okhttp/okhttp3/-ok-http-client/-builder/call-timeout/ for more details.")
    Integer callTimeoutSeconds;
    @Parameter(names={"--http-client-connect-timeout-seconds"}, description="The timeout in seconds for new HTTP connections. See https://square.github.io/okhttp/4.x/okhttp/okhttp3/-ok-http-client/-builder/connect-timeout/ for more details.")
    Integer connectTimeoutSeconds;
    @Parameter(names={"--http-client-read-timeout-seconds"}, description="The timeout in seconds for the read operations for HTTP connections. See https://square.github.io/okhttp/4.x/okhttp/okhttp3/-ok-http-client/-builder/read-timeout/ for more details.")
    Integer readTimeoutSeconds;
    @Parameter(names={"--http-client-write-timeout-seconds"}, description="The timeout in seconds for the write operations for HTTP connections. See https://square.github.io/okhttp/4.x/okhttp/okhttp3/-ok-http-client/-builder/write-timeout/ for more details.")
    Integer writeTimeoutSeconds;

    @Override
    public void validate() {
        HttpClientCliOptions.validateTimeout("--http-client-call-timeout-seconds", this.callTimeoutSeconds);
        HttpClientCliOptions.validateTimeout("--http-client-connect-timeout-seconds", this.connectTimeoutSeconds);
        HttpClientCliOptions.validateTimeout("--http-client-read-timeout-seconds", this.readTimeoutSeconds);
        HttpClientCliOptions.validateTimeout("--http-client-write-timeout-seconds", this.writeTimeoutSeconds);
    }

    private static void validateTimeout(String flagName, @Nullable Integer value) {
        if (value != null && value < 0) {
            throw new ParameterException(String.format("%s cannot be a negative number, received %d.", flagName, value));
        }
    }
}

