/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.net.http;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.tsunami.common.net.http.HttpClientCliOptions;
import com.google.tsunami.common.net.http.HttpClientConfigProperties;
import com.google.tsunami.common.net.http.javanet.ConnectionFactory;
import com.google.tsunami.common.net.http.javanet.DefaultConnectionFactory;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.inject.Qualifier;
import javax.inject.Singleton;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;

public final class HttpClientModule
extends AbstractModule {
    private static final X509TrustManager TRUST_ALL_CERTS_MANAGER = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    };
    private final int connectionPoolMaxIdle;
    private final Duration connectionPoolKeepAliveDuration;
    private final int maxRequests;
    private final int maxRequestsPerHost;
    private final boolean followRedirects;

    public HttpClientModule(Builder builder) {
        Preconditions.checkNotNull((Object)builder);
        this.connectionPoolMaxIdle = builder.connectionPoolMaxIdle;
        this.connectionPoolKeepAliveDuration = builder.connectionPoolKeepAliveDuration;
        this.maxRequests = builder.maxRequests;
        this.maxRequestsPerHost = builder.maxRequestsPerHost;
        this.followRedirects = builder.followRedirects;
    }

    @Provides
    @Singleton
    ConnectionPool provideConnectionPool() {
        return new ConnectionPool(this.connectionPoolMaxIdle, this.connectionPoolKeepAliveDuration.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Provides
    @Singleton
    Dispatcher provideDispatcher() {
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(this.maxRequests);
        dispatcher.setMaxRequestsPerHost(this.maxRequestsPerHost);
        return dispatcher;
    }

    @Provides
    @Singleton
    @TrustAllCertsSocketFactory
    SSLSocketFactory provideTrustAllCertsSocketFactory() throws GeneralSecurityException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{TRUST_ALL_CERTS_MANAGER}, new SecureRandom());
        return sslContext.getSocketFactory();
    }

    @Provides
    @Singleton
    OkHttpClient provideOkHttpClient(ConnectionPool connectionPool, Dispatcher dispatcher, @TrustAllCertsSocketFactory SSLSocketFactory trustAllCertsSocketFactory, @TrustAllCertificates boolean trustAllCertificates, @CallTimeoutSeconds int callTimeoutSeconds, @ConnectTimeoutSeconds int connectTimeoutSeconds, @ReadTimeoutSeconds int readTimeoutSeconds, @WriteTimeoutSeconds int writeTimeoutSeconds) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().callTimeout(Duration.ofSeconds(callTimeoutSeconds)).connectTimeout(Duration.ofSeconds(connectTimeoutSeconds)).readTimeout(Duration.ofSeconds(readTimeoutSeconds)).writeTimeout(Duration.ofSeconds(writeTimeoutSeconds)).connectionPool(connectionPool).dispatcher(dispatcher).followRedirects(this.followRedirects);
        if (trustAllCertificates) {
            clientBuilder.sslSocketFactory(trustAllCertsSocketFactory, TRUST_ALL_CERTS_MANAGER).hostnameVerifier((hostname, session) -> true);
        }
        return clientBuilder.build();
    }

    @Provides
    @Singleton
    ConnectionFactory provideJavaNetConnectionFactory(@TrustAllCertificates boolean trustAllCertificates, @TrustAllCertsSocketFactory SSLSocketFactory trustAllCertsSocketFactory, @ConnectTimeoutSeconds int connectTimeoutSeconds, @ReadTimeoutSeconds int readTimeoutSeconds) {
        return new DefaultConnectionFactory(trustAllCertificates, trustAllCertsSocketFactory, Duration.ofSeconds(connectTimeoutSeconds), Duration.ofSeconds(readTimeoutSeconds));
    }

    @Provides
    @TrustAllCertificates
    boolean shouldTrustAllCertificates(HttpClientCliOptions httpClientCliOptions, HttpClientConfigProperties httpClientConfigProperties) {
        if (httpClientCliOptions.trustAllCertificates != null) {
            return httpClientCliOptions.trustAllCertificates;
        }
        if (httpClientConfigProperties.trustAllCertificates != null) {
            return httpClientConfigProperties.trustAllCertificates;
        }
        return false;
    }

    @Provides
    @CallTimeoutSeconds
    int provideCallTimeoutSeconds(HttpClientCliOptions httpClientCliOptions, HttpClientConfigProperties httpClientConfigProperties) {
        if (httpClientCliOptions.callTimeoutSeconds != null) {
            return httpClientCliOptions.callTimeoutSeconds;
        }
        if (httpClientConfigProperties.callTimeoutSeconds != null) {
            return httpClientConfigProperties.callTimeoutSeconds;
        }
        return 0;
    }

    @Provides
    @ConnectTimeoutSeconds
    int provideConnectTimeoutSeconds(HttpClientCliOptions httpClientCliOptions, HttpClientConfigProperties httpClientConfigProperties) {
        if (httpClientCliOptions.connectTimeoutSeconds != null) {
            return httpClientCliOptions.connectTimeoutSeconds;
        }
        if (httpClientConfigProperties.connectTimeoutSeconds != null) {
            return httpClientConfigProperties.connectTimeoutSeconds;
        }
        return 10;
    }

    @Provides
    @ReadTimeoutSeconds
    int provideReadTimeoutSeconds(HttpClientCliOptions httpClientCliOptions, HttpClientConfigProperties httpClientConfigProperties) {
        if (httpClientCliOptions.readTimeoutSeconds != null) {
            return httpClientCliOptions.readTimeoutSeconds;
        }
        if (httpClientConfigProperties.readTimeoutSeconds != null) {
            return httpClientConfigProperties.readTimeoutSeconds;
        }
        return 10;
    }

    @Provides
    @WriteTimeoutSeconds
    int provideWriteTimeoutSeconds(HttpClientCliOptions httpClientCliOptions, HttpClientConfigProperties httpClientConfigProperties) {
        if (httpClientCliOptions.writeTimeoutSeconds != null) {
            return httpClientCliOptions.writeTimeoutSeconds;
        }
        if (httpClientConfigProperties.writeTimeoutSeconds != null) {
            return httpClientConfigProperties.writeTimeoutSeconds;
        }
        return 10;
    }

    public static final class Builder {
        private static final int DEFAULT_CONNECTION_POOL_MAX_IDLE = 5;
        private static final Duration DEFAULT_CONNECTION_POOL_KEEP_ALIVE_DURATION = Duration.ofMinutes(5L);
        private static final int DEFAULT_MAX_REQUESTS = 64;
        private static final int DEFAULT_MAX_REQUESTS_PER_HOST = 5;
        private static final boolean DEFAULT_FOLLOW_REDIRECTS = true;
        private int connectionPoolMaxIdle = 5;
        private Duration connectionPoolKeepAliveDuration = DEFAULT_CONNECTION_POOL_KEEP_ALIVE_DURATION;
        private int maxRequests = 64;
        private int maxRequestsPerHost = 5;
        private boolean followRedirects = true;

        public Builder setConnectionPoolMaxIdle(int maxIdle) {
            Preconditions.checkArgument((maxIdle > 0 ? 1 : 0) != 0);
            this.connectionPoolMaxIdle = maxIdle;
            return this;
        }

        public Builder setConnectionPoolKeepAliveDuration(Duration keepAliveDuration) {
            Preconditions.checkNotNull((Object)keepAliveDuration);
            Preconditions.checkArgument((!keepAliveDuration.isNegative() ? 1 : 0) != 0);
            this.connectionPoolKeepAliveDuration = keepAliveDuration;
            return this;
        }

        public Builder setMaxRequests(int maxRequests) {
            Preconditions.checkArgument((maxRequests > 0 ? 1 : 0) != 0);
            this.maxRequests = maxRequests;
            return this;
        }

        public Builder setMaxRequestsPerHost(int maxRequestsPerHost) {
            Preconditions.checkArgument((maxRequestsPerHost > 0 ? 1 : 0) != 0);
            this.maxRequestsPerHost = maxRequestsPerHost;
            return this;
        }

        public Builder setFollowRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        public HttpClientModule build() {
            return new HttpClientModule(this);
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD, ElementType.FIELD})
    static @interface WriteTimeoutSeconds {
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD, ElementType.FIELD})
    static @interface ReadTimeoutSeconds {
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD, ElementType.FIELD})
    static @interface ConnectTimeoutSeconds {
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD, ElementType.FIELD})
    static @interface CallTimeoutSeconds {
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD, ElementType.FIELD})
    static @interface TrustAllCertsSocketFactory {
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD, ElementType.FIELD})
    static @interface TrustAllCertificates {
    }
}

