/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.net.http;

import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.Immutable;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.protobuf.ByteString;
import com.google.tsunami.common.net.http.;
import com.google.tsunami.common.net.http.HttpHeaders;
import com.google.tsunami.common.net.http.HttpStatus;
import java.util.Optional;
import okhttp3.HttpUrl;

@Immutable
@AutoValue
@AutoValue.CopyAnnotations
public abstract class HttpResponse {
    public abstract HttpStatus status();

    public abstract HttpHeaders headers();

    public abstract Optional<ByteString> bodyBytes();

    public abstract Optional<HttpUrl> responseUrl();

    public Optional<String> bodyString() {
        return this.bodyBytes().map(ByteString::toStringUtf8);
    }

    public Optional<JsonElement> bodyJson() {
        return this.bodyString().map(JsonParser::parseString);
    }

    public static Builder builder() {
        return new .AutoValue_HttpResponse.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setStatus(HttpStatus var1);

        public abstract Builder setHeaders(HttpHeaders var1);

        public abstract Builder setBodyBytes(ByteString var1);

        public abstract Builder setBodyBytes(Optional<ByteString> var1);

        public abstract Builder setResponseUrl(HttpUrl var1);

        public abstract Builder setResponseUrl(Optional<HttpUrl> var1);

        public abstract HttpResponse build();
    }
}

