/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.common.net.http.javanet;

import com.google.common.base.Preconditions;
import com.google.tsunami.common.net.http.javanet.ConnectionFactory;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.Duration;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class DefaultConnectionFactory
implements ConnectionFactory {
    private final boolean trustAllCertificates;
    private final SSLSocketFactory trustAllCertsSocketFactory;
    private final Duration connectTimeout;
    private final Duration readTimeout;

    public DefaultConnectionFactory(boolean trustAllCertificates, SSLSocketFactory trustAllCertsSocketFactory, Duration connectTimeout, Duration readTimeout) {
        this.trustAllCertificates = trustAllCertificates;
        this.trustAllCertsSocketFactory = (SSLSocketFactory)Preconditions.checkNotNull((Object)trustAllCertsSocketFactory);
        this.connectTimeout = (Duration)Preconditions.checkNotNull((Object)connectTimeout);
        this.readTimeout = (Duration)Preconditions.checkNotNull((Object)readTimeout);
    }

    @Override
    public HttpURLConnection openConnection(String url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setConnectTimeout((int)this.connectTimeout.toMillis());
        connection.setReadTimeout((int)this.readTimeout.toMillis());
        if (connection instanceof HttpsURLConnection && this.trustAllCertificates) {
            HttpsURLConnection secureConnection = (HttpsURLConnection)connection;
            secureConnection.setSSLSocketFactory(this.trustAllCertsSocketFactory);
            secureConnection.setHostnameVerifier((hostname, session) -> true);
        }
        return connection;
    }
}

