/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.plugin;

import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.multibindings.MapBinder;
import com.google.tsunami.plugin.PluginDefinition;
import com.google.tsunami.plugin.TsunamiPlugin;

public abstract class PluginBootstrapModule
extends AbstractModule {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private MapBinder<PluginDefinition, TsunamiPlugin> tsunamiPluginBinder;

    protected final void configure() {
        this.tsunamiPluginBinder = MapBinder.newMapBinder((Binder)this.binder(), PluginDefinition.class, TsunamiPlugin.class);
        this.configurePlugin();
    }

    protected abstract void configurePlugin();

    protected final void registerPlugin(Class<? extends TsunamiPlugin> tsunamiPluginClazz) {
        Preconditions.checkNotNull(tsunamiPluginClazz);
        this.tsunamiPluginBinder.addBinding((Object)PluginDefinition.forPlugin(tsunamiPluginClazz)).to(tsunamiPluginClazz);
        ((GoogleLogger.Api)logger.atInfo()).log("Plugin %s is registered.", tsunamiPluginClazz);
    }
}

