/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.plugin;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.tsunami.plugin.AutoValue_PluginDefinition;
import com.google.tsunami.plugin.PluginType;
import com.google.tsunami.plugin.TsunamiPlugin;
import com.google.tsunami.plugin.annotations.ForServiceName;
import com.google.tsunami.plugin.annotations.ForSoftware;
import com.google.tsunami.plugin.annotations.ForWebService;
import com.google.tsunami.plugin.annotations.PluginInfo;
import java.util.Optional;

@AutoValue
abstract class PluginDefinition {
    PluginDefinition() {
    }

    abstract PluginInfo pluginInfo();

    abstract Optional<ForServiceName> targetServiceName();

    abstract Optional<ForSoftware> targetSoftware();

    abstract boolean isForWebService();

    public String id() {
        return String.format("/%s/%s/%s/%s", new Object[]{this.author(), this.type(), this.name(), this.version()});
    }

    public PluginType type() {
        return this.pluginInfo().type();
    }

    public String name() {
        return this.pluginInfo().name();
    }

    public String author() {
        return this.pluginInfo().author();
    }

    public String version() {
        return this.pluginInfo().version();
    }

    public static PluginDefinition forPlugin(Class<? extends TsunamiPlugin> pluginClazz) {
        Optional<PluginInfo> pluginInfo = Optional.ofNullable(pluginClazz.getAnnotation(PluginInfo.class));
        Optional<ForServiceName> targetServiceName = Optional.ofNullable(pluginClazz.getAnnotation(ForServiceName.class));
        Optional<ForSoftware> targetSoftware = Optional.ofNullable(pluginClazz.getAnnotation(ForSoftware.class));
        boolean isForWebService = pluginClazz.isAnnotationPresent(ForWebService.class);
        Preconditions.checkState((boolean)pluginInfo.isPresent(), (String)"A @PluginInfo annotation is required when creating a PluginDefinition for plugin: %s", pluginClazz);
        return new AutoValue_PluginDefinition(pluginInfo.get(), targetServiceName, targetSoftware, isForWebService);
    }
}

