/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.plugin;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.flogger.GoogleLogger;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.tsunami.plugin.PluginExecutionException;
import com.google.tsunami.plugin.PluginExecutionResult;
import com.google.tsunami.plugin.PluginExecutionThreadPool;
import com.google.tsunami.plugin.PluginExecutor;
import javax.inject.Inject;

class PluginExecutorImpl
implements PluginExecutor {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final ListeningExecutorService pluginExecutionThreadPool;
    private final Stopwatch executionStopwatch;

    @Inject
    PluginExecutorImpl(@PluginExecutionThreadPool ListeningExecutorService pluginExecutionThreadPool) {
        this(pluginExecutionThreadPool, Stopwatch.createUnstarted());
    }

    PluginExecutorImpl(ListeningExecutorService pluginExecutionThreadPool, Stopwatch executionStopwatch) {
        this.pluginExecutionThreadPool = (ListeningExecutorService)Preconditions.checkNotNull((Object)pluginExecutionThreadPool);
        this.executionStopwatch = (Stopwatch)Preconditions.checkNotNull((Object)executionStopwatch);
    }

    @Override
    public <T> ListenableFuture<PluginExecutionResult<T>> executeAsync(PluginExecutor.PluginExecutorConfig<T> executorConfig) {
        return FluentFuture.from((ListenableFuture)this.pluginExecutionThreadPool.submit(() -> {
            this.executionStopwatch.start();
            return executorConfig.pluginExecutionLogic().call();
        })).transform(resultData -> this.buildSucceededResult(resultData, executorConfig), MoreExecutors.directExecutor()).catching(Throwable.class, exception -> this.buildFailedResult((Throwable)exception, executorConfig), MoreExecutors.directExecutor());
    }

    private <T> PluginExecutionResult<T> buildSucceededResult(T resultData, PluginExecutor.PluginExecutorConfig<T> executorConfig) {
        if (this.executionStopwatch.isRunning()) {
            this.executionStopwatch.stop();
        }
        return PluginExecutionResult.builder().setExecutionStatus(PluginExecutionResult.ExecutionStatus.SUCCEEDED).setResultData(resultData).setExecutionStopwatch(this.executionStopwatch).setExecutorConfig(executorConfig).build();
    }

    private <T> PluginExecutionResult<T> buildFailedResult(Throwable t, PluginExecutor.PluginExecutorConfig<T> executorConfig) {
        ((GoogleLogger.Api)logger.atWarning()).log("Plugin '%s' failed.", (Object)executorConfig.matchedPlugin().pluginId());
        if (this.executionStopwatch.isRunning()) {
            this.executionStopwatch.stop();
        }
        return PluginExecutionResult.builder().setExecutionStatus(PluginExecutionResult.ExecutionStatus.FAILED).setExecutionStopwatch(this.executionStopwatch).setException(PluginExecutorImpl.wrapException(t, executorConfig)).setExecutorConfig(executorConfig).build();
    }

    private static <T> PluginExecutionException wrapException(Throwable t, PluginExecutor.PluginExecutorConfig<T> executorConfig) {
        if (t instanceof PluginExecutionException) {
            return (PluginExecutionException)((Object)t);
        }
        return new PluginExecutionException(String.format("Plugin execution error on '%s'.", executorConfig.matchedPlugin().pluginId()), t);
    }
}

