/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.plugin;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.tsunami.plugin.PluginBootstrapModule;
import io.github.classgraph.AnnotationClassRef;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Constructor;

public final class PluginLoadingModule
extends AbstractModule {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final String TSUNAMI_PLUGIN_INTERFACE = "com.google.tsunami.plugin.TsunamiPlugin";
    private static final String PLUGIN_INFO_ANNOTATION = "com.google.tsunami.plugin.annotations.PluginInfo";
    private static final String BOOTSTRAP_MODULE_PARAM_NAME = "bootstrapModule";
    private final boolean bootstrapModuleAlwaysAccessible;
    private final ScanResult classScanResult;

    public PluginLoadingModule(ScanResult classScanResult) {
        this(false, classScanResult);
    }

    @VisibleForTesting
    PluginLoadingModule(boolean bootstrapModuleAlwaysAccessible, ScanResult classScanResult) {
        this.bootstrapModuleAlwaysAccessible = bootstrapModuleAlwaysAccessible;
        this.classScanResult = (ScanResult)Preconditions.checkNotNull((Object)classScanResult);
    }

    protected void configure() {
        ClassInfoList tsunamiPluginClasses = this.classScanResult.getClassesImplementing(TSUNAMI_PLUGIN_INTERFACE).filter(classInfo -> !classInfo.isInterface());
        for (ClassInfo tsunamiPluginClass : tsunamiPluginClasses) {
            ((GoogleLogger.Api)logger.atInfo()).log("Found plugin class: %s", (Object)tsunamiPluginClass.getName());
            if (!tsunamiPluginClass.hasAnnotation(PLUGIN_INFO_ANNOTATION)) {
                throw new IllegalStateException(String.format("Tsunami plugin '%s' must be annotated with PluginInfo", tsunamiPluginClass.getSimpleName()));
            }
            this.install((Module)this.newPluginBootstrapModule(tsunamiPluginClass));
        }
    }

    private PluginBootstrapModule newPluginBootstrapModule(ClassInfo tsunamiPluginClass) {
        Object bootstrapModuleValue = tsunamiPluginClass.getAnnotationInfo(PLUGIN_INFO_ANNOTATION).getParameterValues().getValue(BOOTSTRAP_MODULE_PARAM_NAME);
        if (!(bootstrapModuleValue instanceof AnnotationClassRef)) {
            throw new AssertionError((Object)String.format("Invalid bootstrapModule parameter type for Tsunami plugin '%s'", tsunamiPluginClass.getSimpleName()));
        }
        ClassInfo bootstrapModuleClassInfo = ((AnnotationClassRef)bootstrapModuleValue).getClassInfo();
        if (bootstrapModuleClassInfo == null) {
            throw new AssertionError((Object)String.format("bootstrapModule class for plugin '%s' not found in classpath", tsunamiPluginClass.getSimpleName()));
        }
        try {
            Constructor pluginBootstrapModuleConstructor = bootstrapModuleClassInfo.loadClass(PluginBootstrapModule.class).getDeclaredConstructor(new Class[0]);
            if (this.bootstrapModuleAlwaysAccessible) {
                pluginBootstrapModuleConstructor.setAccessible(true);
            }
            return (PluginBootstrapModule)((Object)pluginBootstrapModuleConstructor.newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError(String.format("PluginBootstrapModule '%s' for plugin '%s' must be publicly constructable via a no-argument constructor", bootstrapModuleClassInfo.getSimpleName(), tsunamiPluginClass.getSimpleName()), e);
        }
    }
}

