/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.plugin;

import com.google.auto.value.AutoValue;
import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.tsunami.common.data.NetworkServiceUtils;
import com.google.tsunami.plugin.AutoValue_PluginManager_PluginMatchingResult;
import com.google.tsunami.plugin.PluginDefinition;
import com.google.tsunami.plugin.PluginType;
import com.google.tsunami.plugin.PortScanner;
import com.google.tsunami.plugin.ServiceFingerprinter;
import com.google.tsunami.plugin.TsunamiPlugin;
import com.google.tsunami.plugin.VulnDetector;
import com.google.tsunami.proto.NetworkService;
import com.google.tsunami.proto.ReconnaissanceReport;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;

public class PluginManager {
    private final Map<PluginDefinition, Provider<TsunamiPlugin>> tsunamiPlugins;

    @Inject
    PluginManager(Map<PluginDefinition, Provider<TsunamiPlugin>> tsunamiPlugins) {
        this.tsunamiPlugins = tsunamiPlugins;
    }

    public ImmutableList<PluginMatchingResult<PortScanner>> getPortScanners() {
        return (ImmutableList)this.tsunamiPlugins.entrySet().stream().filter(entry -> ((PluginDefinition)entry.getKey()).type().equals((Object)PluginType.PORT_SCAN)).map(entry -> PluginMatchingResult.builder().setPluginDefinition((PluginDefinition)entry.getKey()).setTsunamiPlugin((PortScanner)((Provider)entry.getValue()).get()).build()).collect(ImmutableList.toImmutableList());
    }

    public Optional<PluginMatchingResult<PortScanner>> getPortScanner() {
        ImmutableList<PluginMatchingResult<PortScanner>> allPortScanners = this.getPortScanners();
        return allPortScanners.isEmpty() ? Optional.empty() : Optional.of((PluginMatchingResult)allPortScanners.get(0));
    }

    public Optional<PluginMatchingResult<ServiceFingerprinter>> getServiceFingerprinter(NetworkService networkService) {
        return this.tsunamiPlugins.entrySet().stream().filter(entry -> ((PluginDefinition)entry.getKey()).type().equals((Object)PluginType.SERVICE_FINGERPRINT)).filter(entry -> PluginManager.hasMatchingServiceName(networkService, (PluginDefinition)entry.getKey())).map(entry -> PluginMatchingResult.builder().setPluginDefinition((PluginDefinition)entry.getKey()).setTsunamiPlugin((ServiceFingerprinter)((Provider)entry.getValue()).get()).addMatchedService(networkService).build()).findFirst();
    }

    public ImmutableList<PluginMatchingResult<VulnDetector>> getVulnDetectors(ReconnaissanceReport reconnaissanceReport) {
        return (ImmutableList)this.tsunamiPlugins.entrySet().stream().filter(entry -> ((PluginDefinition)entry.getKey()).type().equals((Object)PluginType.VULN_DETECTION)).map(entry -> PluginManager.matchVulnDetectors((PluginDefinition)entry.getKey(), (Provider<TsunamiPlugin>)((Provider)entry.getValue()), reconnaissanceReport)).flatMap(Streams::stream).collect(ImmutableList.toImmutableList());
    }

    private static Optional<PluginMatchingResult<VulnDetector>> matchVulnDetectors(PluginDefinition pluginDefinition, Provider<TsunamiPlugin> vulnDetectorProvider, ReconnaissanceReport reconnaissanceReport) {
        List matchedNetworkServices = !pluginDefinition.targetServiceName().isPresent() && !pluginDefinition.targetSoftware().isPresent() && !pluginDefinition.isForWebService() ? reconnaissanceReport.getNetworkServicesList() : (List)reconnaissanceReport.getNetworkServicesList().stream().filter(networkService -> PluginManager.hasMatchingServiceName(networkService, pluginDefinition) || PluginManager.hasMatchingSoftware(networkService, pluginDefinition)).collect(ImmutableList.toImmutableList());
        return matchedNetworkServices.isEmpty() ? Optional.empty() : Optional.of(PluginMatchingResult.builder().setPluginDefinition(pluginDefinition).setTsunamiPlugin((VulnDetector)vulnDetectorProvider.get()).addAllMatchedServices(matchedNetworkServices).build());
    }

    private static boolean hasMatchingServiceName(NetworkService networkService, PluginDefinition pluginDefinition) {
        String serviceName = networkService.getServiceName();
        boolean hasServiceNameMatch = pluginDefinition.targetServiceName().isPresent() && (serviceName.isEmpty() || Arrays.stream(pluginDefinition.targetServiceName().get().value()).anyMatch(targetServiceName -> Ascii.equalsIgnoreCase((CharSequence)targetServiceName, (CharSequence)serviceName)));
        boolean hasWebServiceMatch = pluginDefinition.isForWebService() && NetworkServiceUtils.isWebService((NetworkService)networkService);
        return hasServiceNameMatch || hasWebServiceMatch;
    }

    private static boolean hasMatchingSoftware(NetworkService networkService, PluginDefinition pluginDefinition) {
        String softwareName = networkService.getSoftware().getName();
        return pluginDefinition.targetSoftware().isPresent() && (softwareName.isEmpty() || Ascii.equalsIgnoreCase((CharSequence)pluginDefinition.targetSoftware().get().name(), (CharSequence)softwareName));
    }

    @AutoValue
    public static abstract class PluginMatchingResult<T extends TsunamiPlugin> {
        public abstract PluginDefinition pluginDefinition();

        public abstract T tsunamiPlugin();

        public abstract ImmutableList<NetworkService> matchedServices();

        public String pluginId() {
            return this.pluginDefinition().id();
        }

        public static <T extends TsunamiPlugin> Builder<T> builder() {
            return new AutoValue_PluginManager_PluginMatchingResult.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder<T extends TsunamiPlugin> {
            public abstract Builder<T> setPluginDefinition(PluginDefinition var1);

            public abstract Builder<T> setTsunamiPlugin(T var1);

            abstract ImmutableList.Builder<NetworkService> matchedServicesBuilder();

            public Builder<T> addMatchedService(NetworkService networkService) {
                this.matchedServicesBuilder().add((Object)networkService);
                return this;
            }

            public Builder<T> addAllMatchedServices(Iterable<NetworkService> networkServices) {
                this.matchedServicesBuilder().addAll(networkServices);
                return this;
            }

            public abstract PluginMatchingResult<T> build();
        }
    }
}

