/*
 * Decompiled with CFR 0.152.
 */
package com.google.tsunami.plugin.testing;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.util.Timestamps;
import com.google.tsunami.plugin.PluginType;
import com.google.tsunami.plugin.VulnDetector;
import com.google.tsunami.plugin.annotations.PluginInfo;
import com.google.tsunami.plugin.testing.FakeVulnDetectorBootstrapModule;
import com.google.tsunami.proto.DetectionReport;
import com.google.tsunami.proto.DetectionReportList;
import com.google.tsunami.proto.DetectionStatus;
import com.google.tsunami.proto.NetworkService;
import com.google.tsunami.proto.Severity;
import com.google.tsunami.proto.TargetInfo;
import com.google.tsunami.proto.Vulnerability;
import com.google.tsunami.proto.VulnerabilityId;

@PluginInfo(type=PluginType.VULN_DETECTION, name="FakeVulnDetector", version="v0.1", description="A fake VulnDetector.", author="fake", bootstrapModule=FakeVulnDetectorBootstrapModule.class)
public class FakeVulnDetector
implements VulnDetector {
    public static DetectionReport getFakeDetectionReport(TargetInfo targetInfo, NetworkService networkService) {
        return DetectionReport.newBuilder().setTargetInfo(targetInfo).setNetworkService(networkService).setDetectionTimestamp(Timestamps.fromMillis((long)1234567890L)).setDetectionStatus(DetectionStatus.VULNERABILITY_VERIFIED).setVulnerability(Vulnerability.newBuilder().setMainId(VulnerabilityId.newBuilder().setPublisher("GOOGLE").setValue("FakeVuln1")).setSeverity(Severity.CRITICAL).setTitle("FakeTitle1").setDescription("FakeDescription1")).build();
    }

    @Override
    public DetectionReportList detect(TargetInfo targetInfo, ImmutableList<NetworkService> matchedServices) {
        return DetectionReportList.newBuilder().addAllDetectionReports((Iterable)matchedServices.stream().map(networkService -> FakeVulnDetector.getFakeDetectionReport(targetInfo, networkService)).collect(ImmutableList.toImmutableList())).build();
    }
}

