/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.datatable.value;

import com.google.visualization.datasource.datatable.value.NullValueException;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;

public class BooleanValue
extends Value {
    private static final BooleanValue NULL_VALUE = new BooleanValue(false);
    public static final BooleanValue TRUE = new BooleanValue(true);
    public static final BooleanValue FALSE = new BooleanValue(false);
    private boolean value;

    public static BooleanValue getNullValue() {
        return NULL_VALUE;
    }

    public static BooleanValue getInstance(Boolean bl) {
        if (bl == null) {
            return NULL_VALUE;
        }
        return bl != false ? TRUE : FALSE;
    }

    private BooleanValue(boolean bl) {
        this.value = bl;
    }

    @Override
    public ValueType getType() {
        return ValueType.BOOLEAN;
    }

    public boolean getValue() {
        if (this == NULL_VALUE) {
            throw new NullValueException("This null boolean has no value");
        }
        return this.value;
    }

    public String toString() {
        if (this == NULL_VALUE) {
            return "null";
        }
        return Boolean.toString(this.value);
    }

    @Override
    public boolean isNull() {
        return this == NULL_VALUE;
    }

    @Override
    public int compareTo(Value value) {
        if (this == value) {
            return 0;
        }
        BooleanValue booleanValue = (BooleanValue)value;
        if (this.isNull()) {
            return -1;
        }
        if (booleanValue.isNull()) {
            return 1;
        }
        return this.value == booleanValue.value ? 0 : (this.value ? 1 : -1);
    }

    @Override
    public int hashCode() {
        return this.isNull() ? -1 : (this.value ? 1 : 0);
    }

    @Override
    public Boolean getObjectToFormat() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    protected String innerToQueryString() {
        return this.value ? "true" : "false";
    }
}

