/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.datatable.value;

import com.google.visualization.datasource.datatable.value.BooleanValue;
import com.google.visualization.datasource.datatable.value.DateTimeValue;
import com.google.visualization.datasource.datatable.value.DateValue;
import com.google.visualization.datasource.datatable.value.NumberValue;
import com.google.visualization.datasource.datatable.value.TextValue;
import com.google.visualization.datasource.datatable.value.TimeOfDayValue;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.ibm.icu.util.ULocale;
import java.util.Comparator;

public abstract class Value
implements Comparable<Value> {
    public abstract ValueType getType();

    public abstract boolean isNull();

    public boolean equals(Object object) {
        if (null == object || this.getClass() != object.getClass()) {
            return false;
        }
        return this.compareTo((Value)object) == 0;
    }

    public abstract int hashCode();

    public abstract Object getObjectToFormat();

    public static Value getNullValueFromValueType(ValueType valueType) {
        switch (valueType) {
            case BOOLEAN: {
                return BooleanValue.getNullValue();
            }
            case TEXT: {
                return TextValue.getNullValue();
            }
            case NUMBER: {
                return NumberValue.getNullValue();
            }
            case TIMEOFDAY: {
                return TimeOfDayValue.getNullValue();
            }
            case DATE: {
                return DateValue.getNullValue();
            }
            case DATETIME: {
                return DateTimeValue.getNullValue();
            }
        }
        return null;
    }

    public final String toQueryString() {
        if (this.isNull()) {
            throw new RuntimeException("Cannot run toQueryString() on a null value.");
        }
        return this.innerToQueryString();
    }

    protected abstract String innerToQueryString();

    public static Comparator<Value> getLocalizedComparator(final ULocale uLocale) {
        return new Comparator<Value>(){
            private Comparator<TextValue> textValueComparator;
            {
                this.textValueComparator = TextValue.getTextLocalizedComparator(uLocale);
            }

            @Override
            public int compare(Value value, Value value2) {
                if (value == value2) {
                    return 0;
                }
                if (value.getType() == ValueType.TEXT) {
                    return this.textValueComparator.compare((TextValue)value, (TextValue)value2);
                }
                return value.compareTo(value2);
            }
        };
    }
}

