/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.ComparisonFilter;
import com.google.visualization.datasource.query.DataTableColumnLookup;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ColumnColumnFilter
extends ComparisonFilter {
    private AbstractColumn firstColumn;
    private AbstractColumn secondColumn;

    public ColumnColumnFilter(AbstractColumn abstractColumn, AbstractColumn abstractColumn2, ComparisonFilter.Operator operator) {
        super(operator);
        this.firstColumn = abstractColumn;
        this.secondColumn = abstractColumn2;
    }

    @Override
    public boolean isMatch(DataTable dataTable, TableRow tableRow) {
        DataTableColumnLookup dataTableColumnLookup = new DataTableColumnLookup(dataTable);
        Value value = this.firstColumn.getValue(dataTableColumnLookup, tableRow);
        Value value2 = this.secondColumn.getValue(dataTableColumnLookup, tableRow);
        return this.isOperatorMatch(value, value2);
    }

    @Override
    public Set<String> getAllColumnIds() {
        HashSet hashSet = Sets.newHashSet(this.firstColumn.getAllSimpleColumnIds());
        hashSet.addAll(this.secondColumn.getAllSimpleColumnIds());
        return hashSet;
    }

    @Override
    public List<ScalarFunctionColumn> getScalarFunctionColumns() {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.addAll(this.firstColumn.getAllScalarFunctionColumns());
        arrayList.addAll(this.secondColumn.getAllScalarFunctionColumns());
        return arrayList;
    }

    @Override
    protected List<AggregationColumn> getAggregationColumns() {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.addAll(this.firstColumn.getAllAggregationColumns());
        arrayList.addAll(this.secondColumn.getAllAggregationColumns());
        return arrayList;
    }

    public AbstractColumn getFirstColumn() {
        return this.firstColumn;
    }

    public AbstractColumn getSecondColumn() {
        return this.secondColumn;
    }

    @Override
    public String toQueryString() {
        return this.firstColumn.toQueryString() + " " + this.operator.toQueryString() + " " + this.secondColumn.toQueryString();
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.firstColumn == null ? 0 : this.firstColumn.hashCode());
        n = 31 * n + (this.secondColumn == null ? 0 : this.secondColumn.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ColumnColumnFilter columnColumnFilter = (ColumnColumnFilter)object;
        if (this.firstColumn == null ? columnColumnFilter.firstColumn != null : !this.firstColumn.equals(columnColumnFilter.firstColumn)) {
            return false;
        }
        return !(this.secondColumn == null ? columnColumnFilter.secondColumn != null : !this.secondColumn.equals(columnColumnFilter.secondColumn));
    }
}

