/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.Query;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import com.google.visualization.datasource.query.SimpleColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class QueryGroup {
    private List<AbstractColumn> columns = Lists.newArrayList();

    public void addColumn(AbstractColumn abstractColumn) {
        this.columns.add(abstractColumn);
    }

    public List<String> getColumnIds() {
        ArrayList arrayList = Lists.newArrayList();
        for (AbstractColumn abstractColumn : this.columns) {
            arrayList.add(abstractColumn.getId());
        }
        return ImmutableList.copyOf((Collection)arrayList);
    }

    public List<String> getSimpleColumnIds() {
        ArrayList arrayList = Lists.newArrayList();
        for (AbstractColumn abstractColumn : this.columns) {
            arrayList.addAll(abstractColumn.getAllSimpleColumnIds());
        }
        return arrayList;
    }

    public List<AbstractColumn> getColumns() {
        return ImmutableList.copyOf(this.columns);
    }

    public List<SimpleColumn> getSimpleColumns() {
        ArrayList arrayList = Lists.newArrayList();
        for (AbstractColumn abstractColumn : this.columns) {
            arrayList.addAll(abstractColumn.getAllSimpleColumns());
        }
        return arrayList;
    }

    public List<ScalarFunctionColumn> getScalarFunctionColumns() {
        ArrayList arrayList = Lists.newArrayList();
        for (AbstractColumn abstractColumn : this.columns) {
            arrayList.addAll(abstractColumn.getAllScalarFunctionColumns());
        }
        return arrayList;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.columns == null ? 0 : ((Object)this.columns).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        QueryGroup queryGroup = (QueryGroup)object;
        return !(this.columns == null ? queryGroup.columns != null : !((Object)this.columns).equals(queryGroup.columns));
    }

    public String toQueryString() {
        return Query.columnListToQueryString(this.columns);
    }
}

