/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.engine;

import com.google.common.collect.Maps;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.query.AggregationType;
import com.google.visualization.datasource.query.engine.ValueAggregator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class AggregationNode {
    private AggregationNode parent;
    private Value value;
    private Map<String, ValueAggregator> columnAggregators = Maps.newHashMap();
    private Map<Value, AggregationNode> children = Maps.newHashMap();

    public AggregationNode(Set<String> set, DataTable dataTable) {
        for (String string : set) {
            this.columnAggregators.put(string, new ValueAggregator(dataTable.getColumnDescription(string).getType()));
        }
    }

    public void aggregate(Map<String, Value> map) {
        for (String string : map.keySet()) {
            this.columnAggregators.get(string).aggregate(map.get(string));
        }
    }

    public Value getAggregationValue(String string, AggregationType aggregationType) {
        ValueAggregator valueAggregator = this.columnAggregators.get(string);
        if (valueAggregator == null) {
            throw new IllegalArgumentException("Column " + string + " is not aggregated");
        }
        return valueAggregator.getValue(aggregationType);
    }

    public AggregationNode getChild(Value value) {
        AggregationNode aggregationNode = this.children.get(value);
        if (aggregationNode == null) {
            throw new NoSuchElementException("Value " + value + " is not a child.");
        }
        return aggregationNode;
    }

    public boolean containsChild(Value value) {
        return this.children.containsKey(value);
    }

    public void addChild(Value value, Set<String> set, DataTable dataTable) {
        if (this.children.containsKey(value)) {
            throw new IllegalArgumentException("A child with key: " + value + " already exists.");
        }
        AggregationNode aggregationNode = new AggregationNode(set, dataTable);
        aggregationNode.parent = this;
        aggregationNode.value = value;
        this.children.put(value, aggregationNode);
    }

    public Map<Value, AggregationNode> getChildren() {
        return Maps.newHashMap(this.children);
    }

    protected Value getValue() {
        return this.value;
    }

    protected AggregationNode getParent() {
        return this.parent;
    }
}

