/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.engine;

import com.google.common.collect.Sets;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.query.engine.AggregationNode;
import com.google.visualization.datasource.query.engine.AggregationPath;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AggregationTree {
    private AggregationNode root;
    private Set<String> columnsToAggregate;
    private DataTable table;

    public AggregationTree(Set<String> set, DataTable dataTable) {
        this.columnsToAggregate = set;
        this.table = dataTable;
        this.root = new AggregationNode(set, dataTable);
    }

    public void aggregate(AggregationPath aggregationPath, Map<String, Value> map) {
        AggregationNode aggregationNode = this.root;
        this.root.aggregate(map);
        for (Value value : aggregationPath.getValues()) {
            if (!aggregationNode.containsChild(value)) {
                aggregationNode.addChild(value, this.columnsToAggregate, this.table);
            }
            aggregationNode = aggregationNode.getChild(value);
            aggregationNode.aggregate(map);
        }
    }

    public AggregationNode getNode(AggregationPath aggregationPath) {
        AggregationNode aggregationNode = this.root;
        for (Value value : aggregationPath.getValues()) {
            aggregationNode = aggregationNode.getChild(value);
        }
        return aggregationNode;
    }

    public Set<AggregationPath> getPathsToLeaves() {
        HashSet hashSet = Sets.newHashSet();
        this.getPathsToLeavesInternal(this.root, hashSet);
        return hashSet;
    }

    private void getPathsToLeavesInternal(AggregationNode aggregationNode, Set<AggregationPath> set) {
        Map<Value, AggregationNode> map = aggregationNode.getChildren();
        if (map.isEmpty()) {
            set.add(AggregationTree.getPathToNode(aggregationNode));
        } else {
            for (AggregationNode aggregationNode2 : map.values()) {
                this.getPathsToLeavesInternal(aggregationNode2, set);
            }
        }
    }

    private static final AggregationPath getPathToNode(AggregationNode aggregationNode) {
        AggregationPath aggregationPath = new AggregationPath();
        AggregationNode aggregationNode2 = aggregationNode;
        while (aggregationNode2.getValue() != null) {
            aggregationPath.add(aggregationNode2.getValue());
            aggregationNode2 = aggregationNode2.getParent();
        }
        aggregationPath.reverse();
        return aggregationPath;
    }
}

