/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.engine;

import com.google.common.collect.Maps;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.query.AggregationType;
import com.google.visualization.datasource.query.engine.AggregationPath;
import com.google.visualization.datasource.query.engine.AggregationTree;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TableAggregator {
    private List<String> groupByColumns;
    private Set<String> aggregateColumns;
    private AggregationTree tree;

    public TableAggregator(List<String> list, Set<String> set, DataTable dataTable) {
        this.groupByColumns = list;
        this.aggregateColumns = set;
        this.tree = new AggregationTree(set, dataTable);
        for (TableRow tableRow : dataTable.getRows()) {
            this.tree.aggregate(this.getRowPath(tableRow, dataTable, list.size() - 1), this.getValuesToAggregate(tableRow, dataTable));
        }
    }

    public AggregationPath getRowPath(TableRow tableRow, DataTable dataTable, int n) {
        AggregationPath aggregationPath = new AggregationPath();
        for (int i = 0; i <= n; ++i) {
            String string = this.groupByColumns.get(i);
            Value value = tableRow.getCell(dataTable.getColumnIndex(string)).getValue();
            aggregationPath.add(value);
        }
        return aggregationPath;
    }

    public Set<AggregationPath> getPathsToLeaves() {
        return this.tree.getPathsToLeaves();
    }

    private Map<String, Value> getValuesToAggregate(TableRow tableRow, DataTable dataTable) {
        HashMap hashMap = Maps.newHashMap();
        for (String string : this.aggregateColumns) {
            Value value = tableRow.getCell(dataTable.getColumnIndex(string)).getValue();
            hashMap.put(string, value);
        }
        return hashMap;
    }

    public Value getAggregationValue(AggregationPath aggregationPath, String string, AggregationType aggregationType) {
        return this.tree.getNode(aggregationPath).getAggregationValue(string, aggregationType);
    }
}

